/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers;

import dev.architectury.registry.registries.RegistrySupplier;
import jp.artan.artansprojectcoremod.utils.lang.LangUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public abstract class AbstractUSLanguageProvider
extends LanguageProvider {
    private final String modid;

    public AbstractUSLanguageProvider(PackOutput output, String modid) {
        super(output, modid, "en_us");
        this.modid = modid;
    }

    protected void addTranslations() {
        BuiltInRegistries.f_256975_.m_123024_().filter(block -> this.modid.equals(BuiltInRegistries.f_256975_.m_7981_(block).m_135827_())).forEach(block -> {
            String blockId = BuiltInRegistries.f_256975_.m_7981_(block).m_135815_();
            this.add((Block)block, LangUtils.toEnglishName(blockId));
        });
        BuiltInRegistries.f_257033_.m_123024_().filter(item -> this.modid.equals(BuiltInRegistries.f_257033_.m_7981_(item).m_135827_()) && (!(item instanceof BlockItem) || item instanceof ItemNameBlockItem)).forEach(item -> {
            String itemId = BuiltInRegistries.f_257033_.m_7981_(item).m_135815_();
            this.add((Item)item, LangUtils.toEnglishName(itemId));
        });
        BuiltInRegistries.f_256980_.m_123024_().filter(item -> this.modid.equals(BuiltInRegistries.f_256980_.m_7981_(item).m_135827_())).forEach(block -> {
            String potionId = BuiltInRegistries.f_256980_.m_7981_(block).m_135815_();
            this.add("item.minecraft.lingering_potion.effect." + potionId, LangUtils.toEnglishName("lingering_" + potionId + "_bottle"));
            this.add("item.minecraft.potion.effect." + potionId, LangUtils.toEnglishName(potionId + "_bottle"));
            this.add("item.minecraft.splash_potion.effect." + potionId, LangUtils.toEnglishName("splash_" + potionId + "_bottle"));
        });
    }

    protected void addCreativeModeTab(RegistrySupplier<CreativeModeTab> creativeModeTab) {
        String id = "itemGroup." + creativeModeTab.getId().m_135827_() + "." + creativeModeTab.getId().m_135815_();
        this.addCreativeModeTab(creativeModeTab, LangUtils.toEnglishName(id.replace("itemGroup." + this.modid + ".", "")));
    }

    protected void addCreativeModeTab(RegistrySupplier<CreativeModeTab> creativeModeTab, String name) {
        String id = "itemGroup." + creativeModeTab.getId().m_135827_() + "." + creativeModeTab.getId().m_135815_();
        this.add(id, name);
    }
}

