/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import jp.artan.artansprojectcoremod.block.QuarterBlock;
import jp.artan.artansprojectcoremod.block.TileBlock;
import jp.artan.artansprojectcoremod.block.VerticalSlabBlock;
import jp.artan.artansprojectcoremod.block.properties.QuarterPlacementType;
import jp.artan.artansprojectcoremod.block.properties.VerticalSlabType;
import jp.artan.artansprojectcoremod.sets.Decoration;
import jp.artan.artansprojectcoremod.sets.Flower;
import jp.artan.artansprojectcoremod.sets.LeavesDecoration;
import jp.artan.artansprojectcoremod.sets.SignalDecoration;
import jp.artan.artansprojectcoremod.sets.SignalStoneDecoration;
import jp.artan.artansprojectcoremod.sets.SignalWoodDecoration;
import jp.artan.artansprojectcoremod.sets.StoneDecoration;
import jp.artan.artansprojectcoremod.sets.TreeBlocks;
import jp.artan.artansprojectcoremod.sets.TreeDecoration;
import jp.artan.artansprojectcoremod.sets.WoodDecoration;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class AbstractLootTableProvider
extends LootTableProvider {
    protected String modid;

    public AbstractLootTableProvider(PackOutput arg, String modid, Supplier<LootTableSubProvider> lootCreator) {
        super(arg, Set.of(), AbstractLootTableProvider.blockLootTable(lootCreator));
        this.modid = modid;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    public static List<LootTableProvider.SubProviderEntry> blockLootTable(Supplier<LootTableSubProvider> lootCreator) {
        ImmutableList.Builder builder = ImmutableList.builder();
        LootContextParamSet lootContextParamSet = LootContextParamSets.f_81421_;
        builder.add((Object)new LootTableProvider.SubProviderEntry(lootCreator, lootContextParamSet));
        return builder.build();
    }

    protected abstract <T extends AbstractBlockLoot> Function<String, T> getBlockLootTable();

    public static abstract class AbstractBlockLoot
    extends VanillaBlockLoot {
        protected String modid;

        public AbstractBlockLoot(String modid) {
            this.modid = modid;
        }

        protected Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.f_256975_.m_123024_().filter(block -> this.modid.equals(BuiltInRegistries.f_256975_.m_7981_(block).m_135827_())).toList();
        }

        protected LootTable.Builder createVerticalSlabItemTable(Block arg) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)arg, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)arg).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)arg).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))))))));
        }

        protected LootTable.Builder createTileEntityLootTable(Block block) {
            LootPoolSingletonContainer.Builder lootTable = LootItem.m_79579_((ItemLike)block);
            for (int i = 2; i <= 16; ++i) {
                lootTable.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)i)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)TileBlock.LAYERS, i))));
            }
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)lootTable)));
        }

        protected LootTable.Builder createQuarterEntityLootTable(Block block) {
            LootPoolSingletonContainer.Builder lootTable = LootItem.m_79579_((ItemLike)block);
            Arrays.stream(QuarterPlacementType.values()).forEach(f -> lootTable.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)Integer.bitCount(f.getMatrix()))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(QuarterBlock.QUARTER_TYPE, (Comparable)((Object)f.getQuarterType()))))));
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)lootTable)));
        }

        protected void addCreateSingleItemTableWithSilkTouch(Block block, Item item, int count) {
            this.m_247577_(block, this.m_245142_(block, (ItemLike)item, (NumberProvider)ConstantValue.m_165692_((float)count)));
        }

        protected void dropSlab(SlabBlock block) {
            this.m_247577_((Block)block, this.m_247233_((Block)block));
        }

        protected void dropVerticalSlab(VerticalSlabBlock block) {
            this.m_247577_(block, this.createVerticalSlabItemTable(block));
        }

        protected void dropTile(TileBlock block) {
            this.m_247577_(block, this.createTileEntityLootTable(block));
        }

        protected void dropQuarter(QuarterBlock block) {
            this.m_247577_(block, this.createQuarterEntityLootTable(block));
        }

        protected void dropLeavesDecoration(LeavesDecoration decoration) {
            this.dropSlab((SlabBlock)decoration.Slab.get());
            this.dropVerticalSlab((VerticalSlabBlock)((Object)decoration.VerticalSlab.get()));
            this.m_245724_((Block)decoration.Stairs.get());
            this.dropTile((TileBlock)((Object)decoration.Tile.get()));
        }

        protected void dropDecoration(Decoration decoration) {
            this.dropSlab((SlabBlock)decoration.Slab.get());
            this.dropVerticalSlab((VerticalSlabBlock)((Object)decoration.VerticalSlab.get()));
            this.m_245724_((Block)decoration.Stairs.get());
            this.dropTile((TileBlock)((Object)decoration.Tile.get()));
        }

        protected void dropStoneDecoration(StoneDecoration decoration) {
            this.dropDecoration(decoration);
            this.m_245724_((Block)decoration.Wall.get());
        }

        protected void dropWoodDecoration(WoodDecoration decoration) {
            this.dropDecoration(decoration);
            this.m_245724_((Block)decoration.Fence.get());
        }

        protected void dropSignalDecoration(SignalDecoration decoration) {
            this.dropDecoration(decoration);
            this.m_245724_((Block)decoration.Button.get());
            this.m_245724_((Block)decoration.PressurePlate.get());
        }

        protected void dropSignalStoneDecoration(SignalStoneDecoration decoration) {
            this.dropSignalDecoration(decoration);
            this.m_245724_((Block)decoration.Wall.get());
        }

        protected void dropSignalWoodDecoration(SignalWoodDecoration decoration) {
            this.dropSignalDecoration(decoration);
            this.m_245724_((Block)decoration.Fence.get());
        }

        protected void dropDecoration(TreeBlocks treeBlocks) {
            this.m_245724_((Block)treeBlocks.Log.get());
            this.m_245724_((Block)treeBlocks.StrippedWood.get());
            this.m_245724_((Block)treeBlocks.Wood.get());
            this.m_245724_((Block)treeBlocks.StrippedWood.get());
            this.m_245724_((Block)treeBlocks.Planks.get());
            this.m_245724_((Block)treeBlocks.Leave.get());
            this.m_245724_((Block)treeBlocks.Sapling.get());
            this.m_247577_((Block)treeBlocks.FlowerPotSapling.get(), this.m_245602_((ItemLike)treeBlocks.FlowerPotSapling.get()));
        }

        protected void dropTreeDecoration(TreeDecoration treeDecoration) {
            this.dropWoodDecoration(treeDecoration.LogDecoration);
            this.dropWoodDecoration(treeDecoration.StrippedLogDecoration);
            this.dropWoodDecoration(treeDecoration.WoodDecoration);
            this.dropWoodDecoration(treeDecoration.StrippedWoodDecoration);
            this.dropSignalWoodDecoration(treeDecoration.PlanksDecoration);
            this.dropLeavesDecoration(treeDecoration.LeavesDecoration);
        }

        protected void flower(Flower<?> flower) {
            this.m_245724_((Block)flower.FlowerBlock.get());
            this.m_247577_((Block)flower.FlowerPotted.get(), this.m_245602_((ItemLike)flower.FlowerPotted.get()));
        }

        protected void dropPlant(CropBlock plantBlock, Supplier<Item> crops, List<Supplier<Item>> plantDropItems, int fortuneBonus) {
            LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.m_81769_((Block)plantBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7));
            Item seed = plantBlock.m_5456_();
            LootTable.Builder lootTableBuilder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)crops.get())).m_79080_((LootItemCondition.Builder)builder)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed))));
            for (int i = 0; i < plantDropItems.size(); ++i) {
                lootTableBuilder = lootTableBuilder.m_79161_(LootPool.m_79043_().m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)plantDropItems.get(i).get())).m_79080_((LootItemCondition.Builder)builder)));
            }
            lootTableBuilder = lootTableBuilder.m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)builder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)fortuneBonus))));
            this.m_247577_((Block)plantBlock, (LootTable.Builder)this.m_246108_((ItemLike)plantBlock, (FunctionUserBuilder)lootTableBuilder));
        }
    }
}

