/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers;

import dev.architectury.registry.registries.RegistrySupplier;
import jp.artan.artansprojectcoremod.sets.ArmorItems;
import jp.artan.artansprojectcoremod.sets.Decoration;
import jp.artan.artansprojectcoremod.sets.LeavesDecoration;
import jp.artan.artansprojectcoremod.sets.SignalDecoration;
import jp.artan.artansprojectcoremod.sets.SignalStoneDecoration;
import jp.artan.artansprojectcoremod.sets.SignalWoodDecoration;
import jp.artan.artansprojectcoremod.sets.StoneDecoration;
import jp.artan.artansprojectcoremod.sets.TreeBlocks;
import jp.artan.artansprojectcoremod.sets.TreeDecoration;
import jp.artan.artansprojectcoremod.sets.WoodDecoration;
import jp.artan.artansprojectcoremod.utils.lang.LangUtils;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public abstract class AbstractJPLanguageProvider
extends LanguageProvider {
    public AbstractJPLanguageProvider(PackOutput output, String modid) {
        super(output, modid, "ja_jp");
    }

    protected void add(RegistrySupplier<Potion> potion, String name) {
        String id = potion.getId().m_135815_();
        this.add("item.minecraft.lingering_potion.effect." + id, name + "\u5165\u308a\u6b8b\u7559\u74f6");
        this.add("item.minecraft.potion.effect." + id, name + "\u5165\u308a\u306e\u74f6");
        this.add("item.minecraft.splash_potion.effect." + id, name + "\u5165\u308a\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u74f6");
    }

    protected void addCreativeModeTab(RegistrySupplier<CreativeModeTab> creativeModeTab, String name) {
        String id = "itemGroup." + creativeModeTab.getId().m_135827_() + "." + creativeModeTab.getId().m_135815_();
        this.add(id, LangUtils.toEnglishName(name));
    }

    protected void addLeavesDecoration(LeavesDecoration decoration, String name) {
        this.add((Block)decoration.Slab.get(), name + "\u306e\u30cf\u30fc\u30d5\u30d6\u30ed\u30c3\u30af");
        this.add((Block)decoration.VerticalSlab.get(), name + "\u306e\u7e26\u30cf\u30fc\u30d5\u30d6\u30ed\u30c3\u30af");
        this.add((Block)decoration.Stairs.get(), name + "\u306e\u968e\u6bb5");
        this.add((Block)decoration.Tile.get(), name + "\u306e\u30bf\u30a4\u30eb");
    }

    protected void addDecoration(Decoration decoration, String name) {
        this.add((Block)decoration.Slab.get(), name + "\u306e\u30cf\u30fc\u30d5\u30d6\u30ed\u30c3\u30af");
        this.add((Block)decoration.VerticalSlab.get(), name + "\u306e\u7e26\u30cf\u30fc\u30d5\u30d6\u30ed\u30c3\u30af");
        this.add((Block)decoration.Stairs.get(), name + "\u306e\u968e\u6bb5");
        this.add((Block)decoration.Tile.get(), name + "\u306e\u30bf\u30a4\u30eb");
    }

    protected void addWoodDecoration(WoodDecoration decoration, String name) {
        this.addDecoration(decoration, name);
        this.add((Block)decoration.Fence.get(), name + "\u306e\u67f5");
    }

    protected void addStoneDecoration(StoneDecoration decoration, String name) {
        this.addDecoration(decoration, name);
        this.add((Block)decoration.Wall.get(), name + "\u306e\u5840");
    }

    protected void addSignalDecoration(SignalDecoration decoration, String name) {
        this.addDecoration(decoration, name);
        this.add((Block)decoration.Button.get(), name + "\u306e\u30dc\u30bf\u30f3");
        this.add((Block)decoration.PressurePlate.get(), name + "\u306e\u611f\u5727\u677f");
    }

    protected void addSignalWoodDecoration(SignalWoodDecoration decoration, String name) {
        this.addSignalDecoration(decoration, name);
        this.add((Block)decoration.Fence.get(), name + "\u306e\u67f5");
    }

    protected void addSignalStoneDecoration(SignalStoneDecoration decoration, String name) {
        this.addSignalDecoration(decoration, name);
        this.add((Block)decoration.Wall.get(), name + "\u306e\u5840");
    }

    protected void addTreeBlocks(TreeBlocks treeBlocks, String name) {
        this.add((Block)treeBlocks.Log.get(), name + "\u306e\u539f\u6728");
        this.add((Block)treeBlocks.StrippedLog.get(), "\u6a39\u76ae\u3092\u5265\u3044\u3060" + name + "\u306e\u539f\u6728");
        this.add((Block)treeBlocks.Wood.get(), name + "\u306e\u6728");
        this.add((Block)treeBlocks.StrippedWood.get(), "\u6a39\u76ae\u3092\u5265\u3044\u3060" + name + "\u306e\u6728");
        this.add((Block)treeBlocks.Planks.get(), name + "\u306e\u677f\u6750");
        this.add((Block)treeBlocks.Leave.get(), name + "\u306e\u8449");
        this.add((Block)treeBlocks.Sapling.get(), name + "\u306e\u82d7\u6728");
    }

    protected void addTreeBlocks(TreeDecoration treeDecoration, String name) {
        this.addWoodDecoration(treeDecoration.LogDecoration, name + "\u306e\u539f\u6728");
        this.addWoodDecoration(treeDecoration.StrippedLogDecoration, "\u6a39\u76ae\u3092\u5265\u3044\u3060" + name + "\u306e\u539f\u6728");
        this.addWoodDecoration(treeDecoration.WoodDecoration, name + "\u306e\u6728");
        this.addWoodDecoration(treeDecoration.StrippedWoodDecoration, "\u6a39\u76ae\u3092\u5265\u3044\u3060" + name + "\u306e\u6728");
        this.addSignalWoodDecoration(treeDecoration.PlanksDecoration, name + "\u306e\u677f\u6750");
        this.addLeavesDecoration(treeDecoration.LeavesDecoration, name + "\u306e\u8449");
    }

    protected void addArmorItems(ArmorItems<?> armorItems, String name) {
        this.add((Item)armorItems.Helmet.get(), name + "\u306e\u30d8\u30eb\u30e1\u30c3\u30c8");
        this.add((Item)armorItems.Chestplate.get(), name + "\u306e\u30c1\u30a7\u30b9\u30c8\u30d7\u30ec\u30fc\u30c8");
        this.add((Item)armorItems.Leggings.get(), name + "\u306e\u30ec\u30ae\u30f3\u30b9");
        this.add((Item)armorItems.Boots.get(), name + "\u306e\u30d6\u30fc\u30c4");
    }
}

