/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.forge.providers;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import jp.artan.artansprojectcoremod.ArtansProjectCoreMod;
import jp.artan.artansprojectcoremod.block.AbstractFlowerPotBlock;
import jp.artan.artansprojectcoremod.block.AbstractHexapodBlock;
import jp.artan.artansprojectcoremod.block.AbstractQuarterHexapodBlock;
import jp.artan.artansprojectcoremod.block.QuarterBlock;
import jp.artan.artansprojectcoremod.block.TileBlock;
import jp.artan.artansprojectcoremod.block.VerticalQuarterBlock;
import jp.artan.artansprojectcoremod.block.VerticalSlabBlock;
import jp.artan.artansprojectcoremod.block.properties.FlowerPotDirtType;
import jp.artan.artansprojectcoremod.block.properties.ModBlockStateProperties;
import jp.artan.artansprojectcoremod.block.properties.QuarterPlacementType;
import jp.artan.artansprojectcoremod.block.properties.QuarterRotationType;
import jp.artan.artansprojectcoremod.block.properties.QuarterType;
import jp.artan.artansprojectcoremod.block.properties.VerticalSlabType;
import jp.artan.artansprojectcoremod.sets.Decoration;
import jp.artan.artansprojectcoremod.sets.Flower;
import jp.artan.artansprojectcoremod.sets.LeavesDecoration;
import jp.artan.artansprojectcoremod.sets.SignalDecoration;
import jp.artan.artansprojectcoremod.sets.SignalStoneDecoration;
import jp.artan.artansprojectcoremod.sets.SignalWoodDecoration;
import jp.artan.artansprojectcoremod.sets.StoneDecoration;
import jp.artan.artansprojectcoremod.sets.TreeBlocks;
import jp.artan.artansprojectcoremod.sets.TreeDecoration;
import jp.artan.artansprojectcoremod.sets.WoodDecoration;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockModelProvider
extends BlockStateProvider {
    public AbstractBlockModelProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void quarterHexapod(AbstractQuarterHexapodBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        BlockModelBuilder centerModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_center")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_quarter_hexapod_center")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        BlockModelBuilder connectModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_connect_side")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_quarter_hexapod_connect_side")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        BlockModelBuilder topModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_connect_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_quarter_hexapod_connect_top")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        BlockModelBuilder bottomModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_connect_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_quarter_hexapod_connect_top")))).texture("top", top)).texture("side", side);
        BlockModelBuilder inventoryModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_hexapod_inventory")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        if (renderType != null) {
            centerModel.renderType(renderType);
            connectModel.renderType(renderType);
            topModel.renderType(renderType);
            bottomModel.renderType(renderType);
            inventoryModel.renderType(renderType);
        }
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)centerModel).addModel()).end();
        Arrays.stream(Direction.values()).toList().stream().forEach(e -> ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(e.m_122434_().m_122478_() ? (e == Direction.DOWN ? bottomModel : topModel) : connectModel)).rotationX(e.m_122434_().m_122478_() ? (e == Direction.DOWN ? 90 : 270) : 0).rotationY(e.m_122434_().m_122479_() ? ((int)e.m_122435_() + 180) % 360 : 0).uvLock(true).addModel()).condition((Property)AbstractQuarterHexapodBlock.HEXAPOD_CONNECTS.get(e), (Comparable[])new Boolean[]{true}).end());
        this.simpleBlockItem(block, (ModelFile)inventoryModel);
    }

    protected void hexapod(AbstractHexapodBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        BlockModelBuilder centerModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_center")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_hexapod_center")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        BlockModelBuilder connectModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_connect_side")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_hexapod_connect_side")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        BlockModelBuilder topModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_connect_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_hexapod_connect_top")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        BlockModelBuilder bottomModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_connect_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_hexapod_connect_top")))).texture("top", top)).texture("side", side);
        BlockModelBuilder inventoryModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/hexapod_inventory")))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
        if (renderType != null) {
            centerModel.renderType(renderType);
            connectModel.renderType(renderType);
            topModel.renderType(renderType);
            bottomModel.renderType(renderType);
            inventoryModel.renderType(renderType);
        }
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)centerModel).addModel()).end();
        Arrays.stream(Direction.values()).toList().stream().forEach(e -> ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(e.m_122434_().m_122478_() ? (e == Direction.DOWN ? bottomModel : topModel) : connectModel)).rotationX(e.m_122434_().m_122478_() ? (e == Direction.DOWN ? 90 : 270) : 0).rotationY(e.m_122434_().m_122479_() ? ((int)e.m_122435_() + 180) % 360 : 0).uvLock(true).addModel()).condition((Property)AbstractHexapodBlock.HEXAPOD_CONNECTS.get(e), (Comparable[])new Boolean[]{true}).end());
        this.simpleBlockItem(block, (ModelFile)inventoryModel);
    }

    protected void pressurePlate(PressurePlateBlock block, ResourceLocation all, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        BlockModelBuilder pressurePlate = (BlockModelBuilder)this.models().singleTexture(blockId, this.mcLoc("minecraft:block/pressure_plate_up"), all);
        BlockModelBuilder pressurePlatePressed = (BlockModelBuilder)this.models().singleTexture(blockId + "_pressed", this.mcLoc("minecraft:block/pressure_plate_down"), all);
        if (renderType != null) {
            pressurePlate.renderType(renderType);
            pressurePlatePressed.renderType(renderType);
        }
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)pressurePlate).addModel()).partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)pressurePlatePressed).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)pressurePlate);
    }

    protected void button(ButtonBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        BlockModelBuilder button = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId)).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/button")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder buttonPressed = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_pressed")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/button_pressed")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder buttonInventory = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/button_inventory")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        if (renderType != null) {
            button.renderType(renderType);
            buttonPressed.renderType(renderType);
            buttonInventory.renderType(renderType);
        }
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            Boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            return ConfiguredModel.builder().modelFile((ModelFile)(powered != false ? buttonPressed : button)).rotationX(((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)).ordinal() * 90).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180 + (state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)) % 360).uvLock(state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.WALL).build();
        });
        this.simpleBlockItem((Block)block, (ModelFile)buttonInventory);
    }

    protected void fence(FenceBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        BlockModelBuilder fencePost = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_post")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/fence_post")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder fenceSide = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_side")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/fence_side")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder fenceInventory = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/fence_inventory")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        if (renderType != null) {
            fencePost.renderType(renderType);
            fenceSide.renderType(renderType);
            fenceInventory.renderType(renderType);
        }
        this.fourWayBlock((CrossCollisionBlock)block, (ModelFile)fencePost, (ModelFile)fenceSide);
        this.simpleBlockItem((Block)block, (ModelFile)fenceInventory);
    }

    protected void wall(WallBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        BlockModelBuilder wallPost = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_post")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_wall_post")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder wallSide = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_side")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_wall_side")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder wallSideTall = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_side_tall")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/template_wall_side_tall")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder inventory = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/wall_inventory")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        if (renderType != null) {
            wallPost.renderType(renderType);
            wallSide.renderType(renderType);
            wallSideTall.renderType(renderType);
            inventory.renderType(renderType);
        }
        this.wallBlock(block, (ModelFile)wallPost, (ModelFile)wallSide, (ModelFile)wallSideTall);
        this.simpleBlockItem((Block)block, (ModelFile)inventory);
    }

    protected void tile(TileBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        this.getVariantBuilder(block).forAllStatesExcept(blockState -> {
            Direction facing = (Direction)blockState.m_61143_((Property)TileBlock.FACING);
            Integer value = (Integer)blockState.m_61143_((Property)TileBlock.LAYERS);
            int yRot = (int)facing.m_122435_();
            if (facing == Direction.DOWN) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || facing == Direction.DOWN;
            Function<Direction, Integer> getRotationX = direction -> switch (direction) {
                case Direction.UP -> 180;
                case Direction.DOWN -> 0;
                default -> 270;
            };
            BlockModelBuilder modelFile = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_height" + value)).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/tile_height" + value)))).texture("top", top)).texture("side", side)).texture("bottom", bottom);
            if (renderType != null) {
                modelFile.renderType(renderType);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationX(getRotationX.apply(facing).intValue()).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{TileBlock.WATERLOGGED});
        ModelBuilder itemModelFile = this.models().withExistingParent(blockId, this.getBlockId(() -> block) + "_height1");
        this.simpleBlockItem(block, (ModelFile)itemModelFile);
    }

    protected void stairs(StairBlock block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        BlockModelBuilder stairs = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId)).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/stairs")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder stairsInner = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inner")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/inner_stairs")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        BlockModelBuilder stairsOuter = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_outer")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/outer_stairs")))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
        if (renderType != null) {
            stairs.renderType(renderType);
            stairsInner.renderType(renderType);
            stairsOuter.renderType(renderType);
        }
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((Block)block, (ModelFile)stairs);
    }

    protected void verticalSlab(VerticalSlabBlock block, @Nullable ResourceLocation baseCubeBlockModel, @Nullable ResourceLocation horizontalBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        Property[] propertyArray;
        String blockId = this.getBlockId(block).m_135815_();
        ModelFile.UncheckedModelFile doubleSlab = new ModelFile.UncheckedModelFile(baseCubeBlockModel);
        boolean isDoubleRotateNull = horizontalBlockModel == null;
        ModelFile.UncheckedModelFile doubleSlabRotate = isDoubleRotateNull ? null : new ModelFile.UncheckedModelFile(horizontalBlockModel);
        BlockModelBuilder halfSlab = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_half")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_slab")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder halfSlabRotate = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_half_rotate")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_slab_rotate")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        if (renderType != null) {
            halfSlab.renderType(renderType);
            halfSlabRotate.renderType(renderType);
        }
        VariantBlockStateBuilder variantBlockStateBuilder = this.getVariantBuilder(block);
        Function<BlockState, ConfiguredModel[]> function = arg_0 -> AbstractBlockModelProvider.lambda$verticalSlab$6(isDoubleRotateNull, halfSlabRotate, halfSlab, (ModelFile)doubleSlabRotate, (ModelFile)doubleSlab, horizontalBlockModel, arg_0);
        if (isDoubleRotateNull) {
            Property[] propertyArray2 = new Property[2];
            propertyArray2[0] = VerticalSlabBlock.WATERLOGGED;
            propertyArray = propertyArray2;
            propertyArray2[1] = VerticalSlabBlock.HORIZONTAL_CLICKED;
        } else {
            Property[] propertyArray3 = new Property[1];
            propertyArray = propertyArray3;
            propertyArray3[0] = VerticalSlabBlock.WATERLOGGED;
        }
        variantBlockStateBuilder.forAllStatesExcept(function, propertyArray);
        this.simpleBlockItem(block, (ModelFile)halfSlab);
    }

    protected void slab(SlabBlock block, ResourceLocation baseCubeBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        ModelFile.UncheckedModelFile doubleSlab = new ModelFile.UncheckedModelFile(baseCubeBlockModel);
        BlockModelBuilder bottomSlab = (BlockModelBuilder)this.models().slab(blockId + "_bottom", side, bottom, top);
        BlockModelBuilder topSlab = (BlockModelBuilder)this.models().slabTop(blockId + "_top", side, bottom, top);
        if (renderType != null) {
            bottomSlab.renderType(renderType);
            topSlab.renderType(renderType);
        }
        this.slabBlock(block, (ModelFile)bottomSlab, (ModelFile)topSlab, (ModelFile)doubleSlab);
        this.simpleBlockItem((Block)block, (ModelFile)bottomSlab);
    }

    protected void verticalQuarter(VerticalQuarterBlock block, @Nullable ResourceLocation baseCubeBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        BlockModelBuilder vertical_quarter_q1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q1")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q1")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q2")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q2")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q3 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q3")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q3")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q4 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q4")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q4")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q5 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q5")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q5")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q6 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q6")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q6")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q7 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q7")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q7")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q8 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q8")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q8")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder vertical_quarter_q9 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q9")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_q9")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        ModelFile.UncheckedModelFile vertical_quarter_q10 = new ModelFile.UncheckedModelFile(baseCubeBlockModel);
        BlockModelBuilder vertical_quarter_inventory = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/vertical_quarter_block_inventory")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        if (renderType != null) {
            vertical_quarter_q1.renderType(renderType);
            vertical_quarter_q2.renderType(renderType);
            vertical_quarter_q3.renderType(renderType);
            vertical_quarter_q4.renderType(renderType);
            vertical_quarter_q5.renderType(renderType);
            vertical_quarter_q6.renderType(renderType);
            vertical_quarter_q7.renderType(renderType);
            vertical_quarter_q8.renderType(renderType);
            vertical_quarter_q9.renderType(renderType);
            vertical_quarter_inventory.renderType(renderType);
        }
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ImmutableMap MODEL_MAP = ImmutableMap.builder().put((Object)QuarterType.Q1, (Object)vertical_quarter_q1).put((Object)QuarterType.Q2, (Object)vertical_quarter_q2).put((Object)QuarterType.Q3, (Object)vertical_quarter_q3).put((Object)QuarterType.Q4, (Object)vertical_quarter_q4).put((Object)QuarterType.Q5, (Object)vertical_quarter_q5).put((Object)QuarterType.Q6, (Object)vertical_quarter_q6).put((Object)QuarterType.Q7, (Object)vertical_quarter_q7).put((Object)QuarterType.Q8, (Object)vertical_quarter_q8).put((Object)QuarterType.Q9, (Object)vertical_quarter_q9).build();
        MODEL_MAP.forEach((quarterType, model) -> Arrays.stream(QuarterPlacementType.values()).filter(f -> f.getQuarterType() == quarterType).forEach(type -> ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).uvLock(true).rotationY(type.getQuarterRotationType().getRotation()).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{quarterType}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{type.getQuarterRotationType()}).end()));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)vertical_quarter_q10).uvLock(true).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{QuarterType.Q10}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{QuarterRotationType.R0}).end();
        this.simpleBlockItem(block, (ModelFile)vertical_quarter_inventory);
    }

    protected void quarter(QuarterBlock block, ResourceLocation baseCubeBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        BlockModelBuilder quarter_q1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q1")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q1")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q2")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q2")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q3 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q3")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q3")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q4 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q4")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q4")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q5 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q5")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q5")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q6 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q6")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q6")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q7 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q7")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q7")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q8 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q8")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q8")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        BlockModelBuilder quarter_q9 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_q9")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_q9")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        ModelFile.UncheckedModelFile quarter_q10 = new ModelFile.UncheckedModelFile(baseCubeBlockModel);
        BlockModelBuilder quarter_inventory = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/quarter_block_inventory")))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
        if (renderType != null) {
            quarter_q1.renderType(renderType);
            quarter_q2.renderType(renderType);
            quarter_q3.renderType(renderType);
            quarter_q4.renderType(renderType);
            quarter_q5.renderType(renderType);
            quarter_q6.renderType(renderType);
            quarter_q7.renderType(renderType);
            quarter_q8.renderType(renderType);
            quarter_q9.renderType(renderType);
            quarter_inventory.renderType(renderType);
        }
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ImmutableMap MODEL_MAP = ImmutableMap.builder().put((Object)QuarterType.Q1, (Object)quarter_q1).put((Object)QuarterType.Q2, (Object)quarter_q2).put((Object)QuarterType.Q3, (Object)quarter_q3).put((Object)QuarterType.Q4, (Object)quarter_q4).put((Object)QuarterType.Q5, (Object)quarter_q5).put((Object)QuarterType.Q6, (Object)quarter_q6).put((Object)QuarterType.Q7, (Object)quarter_q7).put((Object)QuarterType.Q8, (Object)quarter_q8).put((Object)QuarterType.Q9, (Object)quarter_q9).build();
        MODEL_MAP.forEach((quarterType, model) -> Arrays.stream(QuarterPlacementType.values()).filter(f -> f.getQuarterType() == quarterType).forEach(type -> {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).uvLock(true).rotationX(type.getQuarterRotationType().getRotation()).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{quarterType}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{type.getQuarterRotationType()}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{Direction.WEST}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).uvLock(true).rotationY(180).rotationX(type.getQuarterRotationType().getRotation()).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{quarterType}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{type.getQuarterRotationType()}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{Direction.EAST}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).uvLock(true).rotationY(90).rotationX(type.getQuarterRotationType().getRotation()).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{quarterType}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{type.getQuarterRotationType()}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{Direction.NORTH}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).uvLock(true).rotationY(270).rotationX(type.getQuarterRotationType().getRotation()).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{quarterType}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{type.getQuarterRotationType()}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{Direction.SOUTH}).end();
        }));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)quarter_q10).uvLock(true).addModel()).condition(ModBlockStateProperties.QUARTER_TYPE, (Comparable[])new QuarterType[]{QuarterType.Q10}).condition(ModBlockStateProperties.QUARTER_ROTATION_TYPE, (Comparable[])new QuarterRotationType[]{QuarterRotationType.R0}).end();
        this.simpleBlockItem(block, (ModelFile)quarter_inventory);
    }

    protected void leaves(LeavesBlock block, ResourceLocation all) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        ModelBuilder modelFile = ((BlockModelBuilder)this.models().withExistingParent(blockId, "minecraft:block/leaves")).texture("all", all);
        this.simpleBlock((Block)block, (ModelFile)modelFile);
        this.simpleBlockItem((Block)block, (ModelFile)modelFile);
    }

    protected void wood(RotatedPillarBlock block, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        ResourceLocation all = this.blockTexture((Block)block);
        BlockModelBuilder modelFile = (BlockModelBuilder)this.models().cubeColumn(blockId, all, all);
        if (renderType != null) {
            modelFile.renderType(renderType);
        }
        this.axisBlock(block, (ModelFile)modelFile, (ModelFile)modelFile);
        this.simpleBlockItem((Block)block, (ModelFile)modelFile);
    }

    protected void log(RotatedPillarBlock block, @Nullable String renderType) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        ResourceLocation side = this.blockTexture((Block)block);
        ResourceLocation end = new ResourceLocation(side.m_135827_(), side.m_135815_() + "_top");
        BlockModelBuilder vertical = (BlockModelBuilder)this.models().cubeColumn(blockId, side, end);
        BlockModelBuilder horizontal = (BlockModelBuilder)this.models().cubeColumnHorizontal(blockId + "_horizontal", side, end);
        if (renderType != null) {
            vertical.renderType(renderType);
            horizontal.renderType(renderType);
        }
        this.axisBlock(block, (ModelFile)vertical, (ModelFile)horizontal);
        this.simpleBlockItem((Block)block, (ModelFile)vertical);
    }

    protected void plant(CropBlock block) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (int i = 0; i <= 7; ++i) {
            String label = blockId + "_" + i;
            ResourceLocation resourceLocation = this.modLoc("block/plants/" + label);
            BlockModelBuilder modelFile = (BlockModelBuilder)((BlockModelBuilder)this.models().crop(label, resourceLocation)).renderType("cutout");
            builder.partialState().with((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelFile)});
        }
        this.itemModels().basicItem(block.m_5456_());
    }

    protected void flowerPot(AbstractFlowerPotBlock block, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        ResourceLocation blockTexture = this.blockTexture(block);
        BlockModelBuilder noneModelFile = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId)).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/flower_pot")))).texture("flowerpot", blockTexture)).texture("particle", blockTexture);
        ResourceLocation dirtResourceLocation = FlowerPotDirtType.DIRT.getTextPath();
        BlockModelBuilder dirtModelFile = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_" + dirtResourceLocation.m_135815_().replace("block/", ""))).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/flower_pot_dirt")))).texture("flowerpot", blockTexture)).texture("particle", blockTexture)).texture("dirt", dirtResourceLocation);
        this.getVariantBuilder(block).forAllStates(state -> {
            BlockModelBuilder modelFile;
            ResourceLocation resourceLocation = ((FlowerPotDirtType)((Object)((Object)state.m_61143_(AbstractFlowerPotBlock.TYPE)))).getTextPath();
            switch ((FlowerPotDirtType)((Object)((Object)state.m_61143_(AbstractFlowerPotBlock.TYPE)))) {
                case NONE: {
                    BlockModelBuilder blockModelBuilder = noneModelFile;
                    break;
                }
                case DUMMY_DIRT: {
                    BlockModelBuilder blockModelBuilder = dirtModelFile;
                    break;
                }
                case DIRT: {
                    BlockModelBuilder blockModelBuilder = dirtModelFile;
                    break;
                }
                default: {
                    BlockModelBuilder blockModelBuilder = modelFile = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId + "_" + resourceLocation.m_135815_().replace("block/", ""))).parent((ModelFile)new ModelFile.UncheckedModelFile(ArtansProjectCoreMod.getResource("block/flower_pot_dirt")))).texture("flowerpot", blockTexture)).texture("particle", blockTexture)).texture("dirt", resourceLocation);
                }
            }
            if (renderType != null) {
                modelFile.renderType(renderType);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
        });
        if (renderType != null) {
            noneModelFile.renderType(renderType);
            dirtModelFile.renderType(renderType);
        }
        this.itemModels().basicItem(this.getBlockId(block));
    }

    public void flowerPotted(FlowerPotBlock block) {
        String blockId = this.getBlockId((Block)block).m_135815_();
        ResourceLocation blockTexture = this.blockTexture(block.m_53560_());
        ModelBuilder flowerPot = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId, "block/flower_pot_cross")).renderType("cutout")).texture("particle", new ResourceLocation("block/flower_pot"))).texture("flowerpot", new ResourceLocation("block/flower_pot"))).texture("plant", blockTexture);
        this.simpleBlock((Block)block, (ModelFile)flowerPot);
    }

    protected void cross(Block block) {
        String blockId = this.getBlockId(block).m_135815_();
        ResourceLocation blockTexture = this.blockTexture(block);
        BlockModelBuilder modelFile = (BlockModelBuilder)((BlockModelBuilder)this.models().cross(blockId, blockTexture)).renderType("cutout");
        this.simpleBlock(block, (ModelFile)modelFile);
    }

    protected void cubeAll(Block block, @Nullable String renderType) {
        String blockId = this.getBlockId(block).m_135815_();
        ResourceLocation blockTexture = this.blockTexture(block);
        BlockModelBuilder modelFile = (BlockModelBuilder)this.models().cubeAll(blockId, blockTexture);
        if (renderType != null) {
            modelFile.renderType(renderType);
        }
        this.simpleBlock(block, (ModelFile)modelFile);
        this.simpleBlockItem(block, (ModelFile)modelFile);
    }

    protected ResourceLocation getBlockId(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    protected ResourceLocation getBlockId(Supplier<? extends Block> block) {
        return this.getBlockId(block.get());
    }

    protected void leavesDecoration(LeavesDecoration decoration, Supplier<? extends Block> resource) {
        this.leavesDecoration(decoration, resource, "translucent");
    }

    protected void leavesDecoration(LeavesDecoration decoration, Supplier<? extends Block> resource, @Nullable String renderType) {
        ResourceLocation base = this.getBlockId(resource);
        ResourceLocation all = new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
        ResourceLocation baseBlockModelFile = this.blockTexture(resource.get());
        this.slab((SlabBlock)decoration.Slab.get(), baseBlockModelFile, all, all, all, "translucent");
        this.verticalSlab((VerticalSlabBlock)((Object)decoration.VerticalSlab.get()), baseBlockModelFile, null, all, all, all, renderType);
        this.stairs((StairBlock)decoration.Stairs.get(), all, all, all, renderType);
        this.tile((TileBlock)((Object)decoration.Tile.get()), all, all, all, renderType);
        this.fence((FenceBlock)decoration.Fence.get(), all, all, all, renderType);
    }

    protected void decoration(Decoration decoration, Supplier<? extends Block> resource) {
        this.decoration(decoration, resource, null);
    }

    protected void decoration(Decoration decoration, Supplier<? extends Block> resource, @Nullable String renderType) {
        ResourceLocation base = this.getBlockId(resource);
        ResourceLocation all = new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
        ResourceLocation baseBlockModelFile = this.blockTexture(resource.get());
        this.slab((SlabBlock)decoration.Slab.get(), baseBlockModelFile, all, all, all, renderType);
        this.verticalSlab((VerticalSlabBlock)((Object)decoration.VerticalSlab.get()), baseBlockModelFile, null, all, all, all, renderType);
        this.stairs((StairBlock)decoration.Stairs.get(), all, all, all, renderType);
        this.tile((TileBlock)((Object)decoration.Tile.get()), all, all, all, renderType);
    }

    protected void woodDecoration(WoodDecoration decoration, ResourceLocation baseBlockModelFile, @Nullable ResourceLocation horizontalBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        this.woodDecoration(decoration, baseBlockModelFile, horizontalBlockModel, side, top, bottom, null);
    }

    protected void woodDecoration(WoodDecoration decoration, ResourceLocation baseBlockModelFile, @Nullable ResourceLocation horizontalBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        this.slab((SlabBlock)decoration.Slab.get(), baseBlockModelFile, side, top, bottom, renderType);
        this.verticalSlab((VerticalSlabBlock)((Object)decoration.VerticalSlab.get()), baseBlockModelFile, horizontalBlockModel, side, top, bottom, renderType);
        this.stairs((StairBlock)decoration.Stairs.get(), side, top, bottom, renderType);
        this.tile((TileBlock)((Object)decoration.Tile.get()), side, top, bottom, renderType);
        this.fence((FenceBlock)decoration.Fence.get(), side, top, bottom, renderType);
    }

    protected void stoneDecoration(StoneDecoration decoration, Supplier<? extends Block> resource) {
        this.stoneDecoration(decoration, resource, null);
    }

    protected void stoneDecoration(StoneDecoration decoration, Supplier<? extends Block> resource, @Nullable String renderType) {
        ResourceLocation base = this.getBlockId(resource);
        ResourceLocation all = new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
        this.decoration(decoration, resource, renderType);
        this.wall((WallBlock)decoration.Wall.get(), all, all, all, renderType);
    }

    protected void signalDecoration(SignalDecoration decoration, Supplier<? extends Block> resource) {
        this.signalDecoration(decoration, resource, null);
    }

    protected void signalDecoration(SignalDecoration decoration, Supplier<? extends Block> resource, @Nullable String renderType) {
        ResourceLocation base = this.getBlockId(resource);
        ResourceLocation all = new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
        ResourceLocation baseBlockModelFile = this.blockTexture(resource.get());
        this.decoration(decoration, resource, renderType);
        this.button((ButtonBlock)decoration.Button.get(), all, all, all, renderType);
        this.pressurePlate((PressurePlateBlock)decoration.PressurePlate.get(), all, renderType);
    }

    protected void signalStoneDecoration(SignalStoneDecoration decoration, Supplier<? extends Block> resource) {
        this.signalStoneDecoration(decoration, resource, null);
    }

    protected void signalStoneDecoration(SignalStoneDecoration decoration, Supplier<? extends Block> resource, @Nullable String renderType) {
        ResourceLocation base = this.getBlockId(resource);
        ResourceLocation all = new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
        this.signalDecoration(decoration, resource, renderType);
        this.wall((WallBlock)decoration.Wall.get(), all, all, all, renderType);
    }

    protected void signalWoodDecoration(SignalWoodDecoration decoration, ResourceLocation baseBlockModelFile, @Nullable ResourceLocation horizontalBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        this.signalWoodDecoration(decoration, baseBlockModelFile, horizontalBlockModel, side, top, bottom, null);
    }

    protected void signalWoodDecoration(SignalWoodDecoration decoration, ResourceLocation baseBlockModelFile, @Nullable ResourceLocation horizontalBlockModel, ResourceLocation side, ResourceLocation top, ResourceLocation bottom, @Nullable String renderType) {
        this.slab((SlabBlock)decoration.Slab.get(), baseBlockModelFile, side, top, bottom, renderType);
        this.verticalSlab((VerticalSlabBlock)((Object)decoration.VerticalSlab.get()), baseBlockModelFile, horizontalBlockModel, side, top, bottom, renderType);
        this.stairs((StairBlock)decoration.Stairs.get(), side, top, bottom, renderType);
        this.tile((TileBlock)((Object)decoration.Tile.get()), side, top, bottom, renderType);
        this.button((ButtonBlock)decoration.Button.get(), side, top, bottom, renderType);
        this.pressurePlate((PressurePlateBlock)decoration.PressurePlate.get(), top, renderType);
        this.fence((FenceBlock)decoration.Fence.get(), side, top, bottom, renderType);
    }

    protected void treeBlocks(TreeBlocks treeBlocks, Supplier<? extends Block> resource) {
        this.treeBlocks(treeBlocks, resource, null);
    }

    protected void treeBlocks(TreeBlocks treeBlocks, Supplier<? extends Block> resource, @Nullable String renderType) {
        ResourceLocation base = this.getBlockId(resource);
        ResourceLocation all = new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
        this.log((RotatedPillarBlock)treeBlocks.Log.get(), renderType);
        this.log((RotatedPillarBlock)treeBlocks.StrippedLog.get(), renderType);
        this.wood((RotatedPillarBlock)treeBlocks.Wood.get(), renderType);
        this.wood((RotatedPillarBlock)treeBlocks.StrippedWood.get(), renderType);
        this.cubeAll((Block)treeBlocks.Planks.get(), renderType);
        this.leaves((LeavesBlock)treeBlocks.Leave.get(), all);
        this.cross((Block)treeBlocks.Sapling.get());
        this.flowerPotted((FlowerPotBlock)treeBlocks.FlowerPotSapling.get());
    }

    protected void treeDecoration(TreeDecoration decoration, TreeBlocks treeBlocks, ResourceLocation naseName) {
        this.treeDecoration(decoration, treeBlocks, naseName, null);
    }

    protected void treeDecoration(TreeDecoration decoration, TreeBlocks treeBlocks, ResourceLocation naseName, @Nullable String renderType) {
        ResourceLocation log = new ResourceLocation(naseName.m_135827_(), "block/" + naseName.m_135815_() + "_log");
        ResourceLocation top = new ResourceLocation(naseName.m_135827_(), "block/" + naseName.m_135815_() + "_log_top");
        ResourceLocation stripedLog = new ResourceLocation(naseName.m_135827_(), "block/stripped_" + naseName.m_135815_() + "_log");
        ResourceLocation plank = new ResourceLocation(naseName.m_135827_(), "block/" + naseName.m_135815_() + "_planks");
        ResourceLocation horizontal = new ResourceLocation(naseName.m_135827_(), "block/" + naseName.m_135815_() + "_log_horizontal");
        ResourceLocation stripedHorizontal = new ResourceLocation(naseName.m_135827_(), "block/stripped_" + naseName.m_135815_() + "_log_horizontal");
        this.woodDecoration(decoration.LogDecoration, log, horizontal, log, top, top, renderType);
        this.woodDecoration(decoration.StrippedLogDecoration, stripedLog, stripedHorizontal, stripedLog, top, top, renderType);
        this.woodDecoration(decoration.WoodDecoration, log, horizontal, log, top, top, renderType);
        this.woodDecoration(decoration.StrippedWoodDecoration, stripedLog, stripedHorizontal, stripedLog, top, top, renderType);
        this.signalWoodDecoration(decoration.PlanksDecoration, plank, null, plank, plank, plank, renderType);
        this.leavesDecoration(decoration.LeavesDecoration, (Supplier<? extends Block>)treeBlocks.Leave, renderType);
    }

    protected void flower(Flower<?> flower) {
        ResourceLocation blockId = this.getBlockId((Block)flower.FlowerBlock.get());
        this.cross((Block)flower.FlowerBlock.get());
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)((FlowerBlock)flower.FlowerBlock.get()).m_5456_());
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(itemId.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_()));
        this.flowerPotted((FlowerPotBlock)flower.FlowerPotted.get());
    }

    private static /* synthetic */ ConfiguredModel[] lambda$verticalSlab$6(boolean isDoubleRotateNull, BlockModelBuilder halfSlabRotate, BlockModelBuilder halfSlab, ModelFile doubleSlabRotate, ModelFile doubleSlab, ResourceLocation horizontalBlockModel, BlockState state) {
        boolean horizontalClicked = (Boolean)state.m_61143_((Property)VerticalSlabBlock.HORIZONTAL_CLICKED);
        return ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_(VerticalSlabBlock.TYPE) == VerticalSlabType.HALF ? (horizontalClicked && !isDoubleRotateNull ? halfSlabRotate : halfSlab) : (horizontalClicked && !isDoubleRotateNull ? doubleSlabRotate : doubleSlab))).rotationX(state.m_61143_(VerticalSlabBlock.TYPE) == VerticalSlabType.DOUBLE && horizontalClicked && !isDoubleRotateNull ? 90 : 0).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).uvLock(horizontalBlockModel == null).build();
    }
}

