/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.entity;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHexapodBlockEntity
extends BlockEntity {
    private final HexapodConnect connect = new HexapodConnect(0);
    public static final String CONNECT_KEY = "connect";

    public AbstractHexapodBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public HexapodConnect getHexapodConnect() {
        return this.connect;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(CONNECT_KEY, this.connect.connect);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_(CONNECT_KEY)) {
            this.connect.setConnect(compoundTag.m_128451_(CONNECT_KEY));
        } else {
            this.connect.setConnect(0);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static class HexapodConnect {
        private int connect;

        private HexapodConnect(int connect) {
            this.connect = connect;
        }

        public int getConnection() {
            return this.connect;
        }

        public HexapodConnectType getConnect(Direction direction) {
            return HexapodConnectType.getHexapodConnectType(this.connect >> direction.m_122411_() * 2 & 3);
        }

        public HexapodConnect setConnect(Direction direction, HexapodConnectType connectType) {
            int shift = direction.m_122411_() * 2;
            this.connect = this.connect & ~(3 << shift) | connectType.getValue() << shift;
            return this;
        }

        private HexapodConnect setConnect(int connect) {
            this.connect = connect;
            return this;
        }
    }

    public static enum HexapodConnectType {
        DISCONNECT(0, false),
        CONNECT(1, true),
        FORCE_DISCONNECT(2, false),
        FORCE_CONNECT(3, true);

        private int value;
        private boolean isConnect;

        private HexapodConnectType(int value, boolean isConnect) {
            this.value = value;
            this.isConnect = isConnect;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isConnect() {
            return this.isConnect;
        }

        public static HexapodConnectType getHexapodConnectType(int value) {
            return Arrays.stream(HexapodConnectType.values()).toList().stream().filter(type -> type.getValue() == (value & 3)).findFirst().orElseThrow();
        }
    }
}

