/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.block.properties;

import java.util.Arrays;
import jp.artan.artansprojectcoremod.block.properties.QuarterDirection;
import jp.artan.artansprojectcoremod.block.properties.QuarterRotationType;
import jp.artan.artansprojectcoremod.block.properties.QuarterType;
import org.jetbrains.annotations.Nullable;

public enum QuarterPlacementType {
    Q1_R0(QuarterType.Q1, QuarterRotationType.R0, 128, 47),
    Q1_R1(QuarterType.Q1, QuarterRotationType.R1, 32, 151),
    Q1_R2(QuarterType.Q1, QuarterRotationType.R2, 1, 244),
    Q1_R3(QuarterType.Q1, QuarterRotationType.R3, 4, 233),
    Q2_R0(QuarterType.Q2, QuarterRotationType.R0, 64, 7),
    Q2_R1(QuarterType.Q2, QuarterRotationType.R1, 8, 148),
    Q2_R2(QuarterType.Q2, QuarterRotationType.R2, 2, 224),
    Q2_R3(QuarterType.Q2, QuarterRotationType.R3, 16, 41),
    Q3_R0(QuarterType.Q3, QuarterRotationType.R0, 160, 7),
    Q3_R1(QuarterType.Q3, QuarterRotationType.R1, 33, 148),
    Q3_R2(QuarterType.Q3, QuarterRotationType.R2, 5, 224),
    Q3_R3(QuarterType.Q3, QuarterRotationType.R3, 132, 41),
    Q4_R0(QuarterType.Q4, QuarterRotationType.R0, 136, 4),
    Q4_R1(QuarterType.Q4, QuarterRotationType.R1, 34, 128),
    Q4_R2(QuarterType.Q4, QuarterRotationType.R2, 17, 32),
    Q4_R3(QuarterType.Q4, QuarterRotationType.R3, 68, 1),
    Q5_R0(QuarterType.Q5, QuarterRotationType.R0, 65, 4),
    Q5_R1(QuarterType.Q5, QuarterRotationType.R1, 12, 128),
    Q5_R2(QuarterType.Q5, QuarterRotationType.R2, 130, 32),
    Q5_R3(QuarterType.Q5, QuarterRotationType.R3, 48, 1),
    Q6_R0(QuarterType.Q6, QuarterRotationType.R0, 129, 36),
    Q6_R1(QuarterType.Q6, QuarterRotationType.R1, 36, 129),
    Q7_R0(QuarterType.Q7, QuarterRotationType.R0, 66, 0),
    Q7_R1(QuarterType.Q7, QuarterRotationType.R1, 24, 0),
    Q8_R0(QuarterType.Q8, QuarterRotationType.R0, 161, 4),
    Q8_R1(QuarterType.Q8, QuarterRotationType.R1, 37, 128),
    Q8_R2(QuarterType.Q8, QuarterRotationType.R2, 133, 32),
    Q8_R3(QuarterType.Q8, QuarterRotationType.R3, 164, 1),
    Q9_R0(QuarterType.Q9, QuarterRotationType.R0, 69, 0),
    Q9_R1(QuarterType.Q9, QuarterRotationType.R1, 140, 0),
    Q9_R2(QuarterType.Q9, QuarterRotationType.R2, 162, 0),
    Q9_R3(QuarterType.Q9, QuarterRotationType.R3, 49, 0),
    Q10_R0(QuarterType.Q10, QuarterRotationType.R0, 165, 0);

    private final QuarterType quarterType;
    private final QuarterRotationType quarterRotationType;
    private final int matrix;
    private final int mask;

    private QuarterPlacementType(QuarterType quarterType, QuarterRotationType quarterRotationType, int matrix, int mask) {
        this.quarterType = quarterType;
        this.quarterRotationType = quarterRotationType;
        this.matrix = matrix;
        this.mask = mask;
    }

    public static QuarterPlacementType get(int matrix) {
        return Arrays.stream(QuarterPlacementType.values()).filter(type -> type.getMatrix() == matrix).findFirst().orElse(null);
    }

    @Nullable
    public static QuarterPlacementType get(QuarterType quarterType, QuarterRotationType quarterRotationType) {
        return Arrays.stream(QuarterPlacementType.values()).filter(type -> type.getQuarterType() == quarterType && type.quarterRotationType == quarterRotationType).findFirst().orElse(null);
    }

    public static boolean includeDirection(QuarterPlacementType quarterPlacementType, QuarterDirection quarterDirection) {
        return (quarterPlacementType.getMatrix() & quarterDirection.getMatrix()) != 0;
    }

    public static boolean includeMaskDirection(QuarterPlacementType quarterPlacementType, QuarterDirection quarterDirection) {
        return (quarterPlacementType.getMask() & quarterDirection.getMatrix()) != 0;
    }

    public QuarterType getQuarterType() {
        return this.quarterType;
    }

    public QuarterRotationType getQuarterRotationType() {
        return this.quarterRotationType;
    }

    public int getMatrix() {
        return this.matrix;
    }

    public int getMask() {
        return this.mask;
    }
}

