/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.block;

import java.util.ArrayList;
import jp.artan.artansprojectcoremod.block.properties.ModBlockStateProperties;
import jp.artan.artansprojectcoremod.block.properties.QuarterDirection;
import jp.artan.artansprojectcoremod.block.properties.QuarterPlacementType;
import jp.artan.artansprojectcoremod.block.properties.QuarterRotationType;
import jp.artan.artansprojectcoremod.block.properties.QuarterType;
import jp.artan.artansprojectcoremod.utils.BlockStateForPlacementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalQuarterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<QuarterRotationType> QUARTER_ROTATION = ModBlockStateProperties.QUARTER_ROTATION_TYPE;
    public static final EnumProperty<QuarterType> QUARTER_TYPE = ModBlockStateProperties.QUARTER_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0);
    protected static final VoxelShape NORTH_EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);

    public VerticalQuarterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(QUARTER_ROTATION, (Comparable)((Object)QuarterRotationType.R0))).m_61124_(QUARTER_TYPE, (Comparable)((Object)QuarterType.Q1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{QUARTER_ROTATION, QUARTER_TYPE, WATERLOGGED});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return this.getShape(pState);
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return this.getShape(pState);
    }

    public VoxelShape getShape(BlockState blockState) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        QuarterPlacementType quarterPlacementType = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        if (quarterPlacementType != null) {
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.NORTH_WEST)) {
                shapes.add(NORTH_WEST_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.NORTH)) {
                shapes.add(NORTH_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.NORTH_EAST)) {
                shapes.add(NORTH_EAST_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.WEST)) {
                shapes.add(WEST_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.EAST)) {
                shapes.add(EAST_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.SOUTH_WEST)) {
                shapes.add(SOUTH_WEST_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.SOUTH)) {
                shapes.add(SOUTH_SHAPE);
            }
            if (QuarterPlacementType.includeDirection(quarterPlacementType, QuarterDirection.SOUTH_EAST)) {
                shapes.add(SOUTH_EAST_SHAPE);
            }
        }
        if (shapes.isEmpty()) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        VoxelShape shape1 = (VoxelShape)shapes.get(0);
        if (shapes.size() == 1) {
            return shape1;
        }
        shapes.remove(0);
        return Shapes.m_83124_((VoxelShape)shape1, (VoxelShape[])shapes.toArray(new VoxelShape[0]));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        QuarterDirection direction = this.getPlacementDirection(blockPlaceContext);
        QuarterPlacementType clickedPlacementType = QuarterPlacementType.get(direction.getMatrix());
        if (!blockState.m_60713_((Block)this)) {
            FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
            return this.update(clickedPlacementType.getQuarterType(), clickedPlacementType.getQuarterRotationType(), fluidState.m_76152_() == Fluids.f_76193_);
        }
        QuarterPlacementType now = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        if (now == null) {
            return null;
        }
        QuarterPlacementType next = QuarterPlacementType.get(now.getMatrix() | clickedPlacementType.getMatrix());
        if (next == null) {
            return null;
        }
        return this.update(next.getQuarterType(), next.getQuarterRotationType(), (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false && next.getQuarterType() != QuarterType.Q10);
    }

    private QuarterDirection getPlacementDirectionToStandardNorth(BlockPlaceContext blockPlaceContext) {
        BlockStateForPlacementUtils.Point clickPoint = BlockStateForPlacementUtils.getBlockClickPoint(blockPlaceContext);
        Direction facing = blockPlaceContext.m_8125_();
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        QuarterPlacementType now = null;
        if (blockState.m_60713_((Block)this)) {
            now = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        }
        if (blockPlaceContext.m_43719_() == Direction.UP || blockPlaceContext.m_43719_() == Direction.DOWN) {
            if (clickPoint.x() < 0.33) {
                if (clickPoint.y() < 0.33) {
                    return QuarterDirection.SOUTH_EAST;
                }
                if (0.33 <= clickPoint.y() && clickPoint.y() < 0.66) {
                    return QuarterDirection.EAST;
                }
                return QuarterDirection.NORTH_EAST;
            }
            if (0.33 <= clickPoint.x() && clickPoint.x() < 0.66) {
                if (clickPoint.y() < 0.5) {
                    return QuarterDirection.SOUTH;
                }
                return QuarterDirection.NORTH;
            }
            if (clickPoint.y() < 0.33) {
                return QuarterDirection.SOUTH_WEST;
            }
            if (0.33 <= clickPoint.y() && clickPoint.y() < 0.66) {
                return QuarterDirection.WEST;
            }
            return QuarterDirection.NORTH_WEST;
        }
        if (blockPlaceContext.m_43719_() == this.getBlockClickFaceByRight(facing)) {
            if (clickPoint.x() < 0.33) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.NORTH_WEST, facing))) {
                    return QuarterDirection.NORTH_EAST;
                }
                return QuarterDirection.NORTH_WEST;
            }
            if (0.33 <= clickPoint.x() && clickPoint.x() < 0.66) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.WEST, facing))) {
                    return QuarterDirection.EAST;
                }
                return QuarterDirection.WEST;
            }
            if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.SOUTH_WEST, facing))) {
                return QuarterDirection.SOUTH_EAST;
            }
            return QuarterDirection.SOUTH_WEST;
        }
        if (blockPlaceContext.m_43719_() == this.getBlockClickFaceByLeft(facing)) {
            if (clickPoint.x() < 0.33) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.SOUTH_EAST, facing))) {
                    return QuarterDirection.SOUTH_WEST;
                }
                return QuarterDirection.SOUTH_EAST;
            }
            if (0.33 <= clickPoint.x() && clickPoint.x() < 0.66) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.EAST, facing))) {
                    return QuarterDirection.WEST;
                }
                return QuarterDirection.EAST;
            }
            if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.NORTH_EAST, facing))) {
                return QuarterDirection.NORTH_WEST;
            }
            return QuarterDirection.NORTH_EAST;
        }
        if (clickPoint.x() < 0.33) {
            if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.NORTH_EAST, facing))) {
                return QuarterDirection.SOUTH_EAST;
            }
            return QuarterDirection.NORTH_EAST;
        }
        if (0.33 <= clickPoint.x() && clickPoint.x() < 0.66) {
            if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.NORTH, facing))) {
                return QuarterDirection.SOUTH;
            }
            return QuarterDirection.NORTH;
        }
        if (now != null && !QuarterPlacementType.includeMaskDirection(now, this.getRotatedQuarterDirection(QuarterDirection.NORTH_WEST, facing))) {
            return QuarterDirection.SOUTH_WEST;
        }
        return QuarterDirection.NORTH_WEST;
    }

    private QuarterDirection getRotatedQuarterDirection(QuarterDirection defaultQuarterDirection, Direction rotateDirection) {
        return switch (rotateDirection) {
            case Direction.EAST -> {
                switch (defaultQuarterDirection) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield QuarterDirection.EAST;
                    }
                    case NORTH_EAST: {
                        yield QuarterDirection.SOUTH_EAST;
                    }
                    case EAST: {
                        yield QuarterDirection.SOUTH;
                    }
                    case SOUTH_EAST: {
                        yield QuarterDirection.SOUTH_WEST;
                    }
                    case SOUTH: {
                        yield QuarterDirection.WEST;
                    }
                    case SOUTH_WEST: {
                        yield QuarterDirection.NORTH_WEST;
                    }
                    case WEST: {
                        yield QuarterDirection.NORTH;
                    }
                    case NORTH_WEST: 
                }
                yield QuarterDirection.NORTH_EAST;
            }
            case Direction.SOUTH -> {
                switch (defaultQuarterDirection) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield QuarterDirection.SOUTH;
                    }
                    case NORTH_EAST: {
                        yield QuarterDirection.SOUTH_WEST;
                    }
                    case EAST: {
                        yield QuarterDirection.WEST;
                    }
                    case SOUTH_EAST: {
                        yield QuarterDirection.NORTH_WEST;
                    }
                    case SOUTH: {
                        yield QuarterDirection.NORTH;
                    }
                    case SOUTH_WEST: {
                        yield QuarterDirection.NORTH_EAST;
                    }
                    case WEST: {
                        yield QuarterDirection.EAST;
                    }
                    case NORTH_WEST: 
                }
                yield QuarterDirection.SOUTH_EAST;
            }
            case Direction.WEST -> {
                switch (defaultQuarterDirection) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH: {
                        yield QuarterDirection.WEST;
                    }
                    case NORTH_EAST: {
                        yield QuarterDirection.NORTH_WEST;
                    }
                    case EAST: {
                        yield QuarterDirection.NORTH;
                    }
                    case SOUTH_EAST: {
                        yield QuarterDirection.NORTH_EAST;
                    }
                    case SOUTH: {
                        yield QuarterDirection.EAST;
                    }
                    case SOUTH_WEST: {
                        yield QuarterDirection.SOUTH_EAST;
                    }
                    case WEST: {
                        yield QuarterDirection.SOUTH;
                    }
                    case NORTH_WEST: 
                }
                yield QuarterDirection.SOUTH_WEST;
            }
            default -> defaultQuarterDirection;
        };
    }

    private QuarterDirection getPlacementDirection(BlockPlaceContext blockPlaceContext) {
        return this.getRotatedQuarterDirection(this.getPlacementDirectionToStandardNorth(blockPlaceContext), blockPlaceContext.m_8125_());
    }

    private BlockState update(QuarterType quarterType, QuarterRotationType rotationType, boolean waterLogged) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(QUARTER_TYPE, (Comparable)((Object)quarterType))).m_61124_(QUARTER_ROTATION, (Comparable)((Object)rotationType))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged));
    }

    private Direction getBlockClickFaceByRight(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            default -> Direction.EAST;
        };
    }

    private Direction getBlockClickFaceByLeft(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Direction.NORTH;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.WEST -> Direction.SOUTH;
            default -> Direction.WEST;
        };
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        ItemStack itemstack = blockPlaceContext.m_43722_();
        QuarterPlacementType now = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        if (now == null) {
            return true;
        }
        BlockStateForPlacementUtils.Point clickPoint = BlockStateForPlacementUtils.getBlockClickPoint(blockPlaceContext);
        if (clickPoint.z() == 1.0) {
            return false;
        }
        if (itemstack.m_41720_() == this.m_5456_()) {
            QuarterDirection direction = this.getPlacementDirection(blockPlaceContext);
            return QuarterPlacementType.includeMaskDirection(now, direction);
        }
        return false;
    }

    public boolean m_7361_(LevelAccessor p_204509_1_, BlockPos p_204509_2_, BlockState p_204509_3_, FluidState p_204509_4_) {
        return p_204509_3_.m_61143_(QUARTER_TYPE) != QuarterType.Q10 && super.m_7361_(p_204509_1_, p_204509_2_, p_204509_3_, p_204509_4_);
    }

    public boolean m_6044_(BlockGetter p_204510_1_, BlockPos p_204510_2_, BlockState p_204510_3_, Fluid p_204510_4_) {
        return p_204510_3_.m_61143_(QUARTER_TYPE) != QuarterType.Q10 && super.m_6044_(p_204510_1_, p_204510_2_, p_204510_3_, p_204510_4_);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

