/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import jp.artan.artansprojectcoremod.block.properties.ModBlockStateProperties;
import jp.artan.artansprojectcoremod.block.properties.QuarterDirection;
import jp.artan.artansprojectcoremod.block.properties.QuarterPlacementType;
import jp.artan.artansprojectcoremod.block.properties.QuarterRotationType;
import jp.artan.artansprojectcoremod.block.properties.QuarterType;
import jp.artan.artansprojectcoremod.utils.BlockStateForPlacementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.PositionImpl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class QuarterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<QuarterType> QUARTER_TYPE = ModBlockStateProperties.QUARTER_TYPE;
    public static final EnumProperty<QuarterRotationType> QUARTER_ROTATION = ModBlockStateProperties.QUARTER_ROTATION_TYPE;
    public static final EnumProperty<Direction> HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape Z_NORTH_SHAPE = Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_SOUTH_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    protected static final VoxelShape Z_EAST_SHAPE = Block.m_49796_((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape Z_WEST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0);
    protected static final VoxelShape Z_NORTH_EAST_SHAPE = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_SOUTH_EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape Z_SOUTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final ImmutableMap<Integer, VoxelShape> NORTH_QUARTER_SHAPES = ImmutableMap.builder().put((Object)QuarterDirection.NORTH.getMatrix(), (Object)Z_NORTH_SHAPE).put((Object)QuarterDirection.SOUTH.getMatrix(), (Object)Z_SOUTH_SHAPE).put((Object)QuarterDirection.EAST.getMatrix(), (Object)Z_EAST_SHAPE).put((Object)QuarterDirection.WEST.getMatrix(), (Object)Z_WEST_SHAPE).put((Object)QuarterDirection.NORTH_EAST.getMatrix(), (Object)Z_NORTH_EAST_SHAPE).put((Object)QuarterDirection.NORTH_WEST.getMatrix(), (Object)Z_NORTH_WEST_SHAPE).put((Object)QuarterDirection.SOUTH_EAST.getMatrix(), (Object)Z_SOUTH_EAST_SHAPE).put((Object)QuarterDirection.SOUTH_WEST.getMatrix(), (Object)Z_SOUTH_WEST_SHAPE).build();
    protected static final ImmutableMap<Integer, VoxelShape> SOUTH_QUARTER_SHAPES = ImmutableMap.builder().put((Object)QuarterDirection.NORTH.getMatrix(), (Object)Z_NORTH_SHAPE).put((Object)QuarterDirection.SOUTH.getMatrix(), (Object)Z_SOUTH_SHAPE).put((Object)QuarterDirection.EAST.getMatrix(), (Object)Z_WEST_SHAPE).put((Object)QuarterDirection.WEST.getMatrix(), (Object)Z_EAST_SHAPE).put((Object)QuarterDirection.NORTH_EAST.getMatrix(), (Object)Z_NORTH_WEST_SHAPE).put((Object)QuarterDirection.NORTH_WEST.getMatrix(), (Object)Z_NORTH_EAST_SHAPE).put((Object)QuarterDirection.SOUTH_EAST.getMatrix(), (Object)Z_SOUTH_WEST_SHAPE).put((Object)QuarterDirection.SOUTH_WEST.getMatrix(), (Object)Z_SOUTH_EAST_SHAPE).build();
    protected static final VoxelShape X_NORTH_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape X_SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    protected static final VoxelShape X_EAST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape X_WEST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0);
    protected static final VoxelShape X_NORTH_EAST_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape X_NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape X_SOUTH_EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape X_SOUTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final ImmutableMap<Integer, VoxelShape> EAST_QUARTER_SHAPES = ImmutableMap.builder().put((Object)QuarterDirection.NORTH.getMatrix(), (Object)X_NORTH_SHAPE).put((Object)QuarterDirection.SOUTH.getMatrix(), (Object)X_SOUTH_SHAPE).put((Object)QuarterDirection.EAST.getMatrix(), (Object)X_EAST_SHAPE).put((Object)QuarterDirection.WEST.getMatrix(), (Object)X_WEST_SHAPE).put((Object)QuarterDirection.NORTH_EAST.getMatrix(), (Object)X_NORTH_EAST_SHAPE).put((Object)QuarterDirection.NORTH_WEST.getMatrix(), (Object)X_NORTH_WEST_SHAPE).put((Object)QuarterDirection.SOUTH_EAST.getMatrix(), (Object)X_SOUTH_EAST_SHAPE).put((Object)QuarterDirection.SOUTH_WEST.getMatrix(), (Object)X_SOUTH_WEST_SHAPE).build();
    protected static final ImmutableMap<Integer, VoxelShape> WEST_QUARTER_SHAPES = ImmutableMap.builder().put((Object)QuarterDirection.NORTH.getMatrix(), (Object)X_NORTH_SHAPE).put((Object)QuarterDirection.SOUTH.getMatrix(), (Object)X_SOUTH_SHAPE).put((Object)QuarterDirection.EAST.getMatrix(), (Object)X_WEST_SHAPE).put((Object)QuarterDirection.WEST.getMatrix(), (Object)X_EAST_SHAPE).put((Object)QuarterDirection.NORTH_EAST.getMatrix(), (Object)X_NORTH_WEST_SHAPE).put((Object)QuarterDirection.NORTH_WEST.getMatrix(), (Object)X_NORTH_EAST_SHAPE).put((Object)QuarterDirection.SOUTH_EAST.getMatrix(), (Object)X_SOUTH_WEST_SHAPE).put((Object)QuarterDirection.SOUTH_WEST.getMatrix(), (Object)X_SOUTH_EAST_SHAPE).build();
    protected static final ImmutableMap<QuarterPlacementType, QuarterPlacementType> QUARTER_PLACEMENT_TYPE_INVERSION = ImmutableMap.builder().put((Object)QuarterPlacementType.Q1_R0, (Object)QuarterPlacementType.Q1_R1).put((Object)QuarterPlacementType.Q1_R1, (Object)QuarterPlacementType.Q1_R0).put((Object)QuarterPlacementType.Q1_R2, (Object)QuarterPlacementType.Q1_R3).put((Object)QuarterPlacementType.Q1_R3, (Object)QuarterPlacementType.Q1_R2).put((Object)QuarterPlacementType.Q2_R0, (Object)QuarterPlacementType.Q2_R0).put((Object)QuarterPlacementType.Q2_R1, (Object)QuarterPlacementType.Q2_R3).put((Object)QuarterPlacementType.Q2_R2, (Object)QuarterPlacementType.Q2_R2).put((Object)QuarterPlacementType.Q2_R3, (Object)QuarterPlacementType.Q2_R1).put((Object)QuarterPlacementType.Q3_R0, (Object)QuarterPlacementType.Q3_R0).put((Object)QuarterPlacementType.Q3_R1, (Object)QuarterPlacementType.Q3_R3).put((Object)QuarterPlacementType.Q3_R2, (Object)QuarterPlacementType.Q3_R2).put((Object)QuarterPlacementType.Q3_R3, (Object)QuarterPlacementType.Q3_R1).put((Object)QuarterPlacementType.Q4_R0, (Object)QuarterPlacementType.Q5_R3).put((Object)QuarterPlacementType.Q4_R1, (Object)QuarterPlacementType.Q5_R2).put((Object)QuarterPlacementType.Q4_R2, (Object)QuarterPlacementType.Q5_R1).put((Object)QuarterPlacementType.Q4_R3, (Object)QuarterPlacementType.Q5_R0).put((Object)QuarterPlacementType.Q5_R0, (Object)QuarterPlacementType.Q4_R3).put((Object)QuarterPlacementType.Q5_R1, (Object)QuarterPlacementType.Q4_R2).put((Object)QuarterPlacementType.Q5_R2, (Object)QuarterPlacementType.Q4_R1).put((Object)QuarterPlacementType.Q5_R3, (Object)QuarterPlacementType.Q4_R0).put((Object)QuarterPlacementType.Q6_R0, (Object)QuarterPlacementType.Q6_R1).put((Object)QuarterPlacementType.Q6_R1, (Object)QuarterPlacementType.Q6_R0).put((Object)QuarterPlacementType.Q7_R0, (Object)QuarterPlacementType.Q7_R0).put((Object)QuarterPlacementType.Q7_R1, (Object)QuarterPlacementType.Q7_R1).put((Object)QuarterPlacementType.Q8_R0, (Object)QuarterPlacementType.Q8_R3).put((Object)QuarterPlacementType.Q8_R1, (Object)QuarterPlacementType.Q8_R2).put((Object)QuarterPlacementType.Q8_R2, (Object)QuarterPlacementType.Q8_R1).put((Object)QuarterPlacementType.Q8_R3, (Object)QuarterPlacementType.Q8_R0).put((Object)QuarterPlacementType.Q9_R0, (Object)QuarterPlacementType.Q9_R0).put((Object)QuarterPlacementType.Q9_R1, (Object)QuarterPlacementType.Q9_R3).put((Object)QuarterPlacementType.Q9_R2, (Object)QuarterPlacementType.Q9_R2).put((Object)QuarterPlacementType.Q9_R3, (Object)QuarterPlacementType.Q9_R1).put((Object)QuarterPlacementType.Q10_R0, (Object)QuarterPlacementType.Q10_R0).build();

    public QuarterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(QUARTER_TYPE, (Comparable)((Object)QuarterType.Q1))).m_61124_(QUARTER_ROTATION, (Comparable)((Object)QuarterRotationType.R0))).m_61124_(HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{QUARTER_TYPE, QUARTER_ROTATION, HORIZONTAL_FACING, WATERLOGGED});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState);
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.getShape(blockState);
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState);
    }

    public VoxelShape getShape(BlockState blockState) {
        ArrayList shapes = new ArrayList();
        QuarterPlacementType placementType = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        VoxelShape notExistsShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (placementType == null) {
            return notExistsShape;
        }
        if (blockState.m_61143_(HORIZONTAL_FACING) == Direction.NORTH) {
            Arrays.stream(QuarterDirection.values()).forEach(direction -> {
                if (QuarterPlacementType.includeDirection(placementType, direction)) {
                    shapes.add((VoxelShape)NORTH_QUARTER_SHAPES.get((Object)direction.getMatrix()));
                }
            });
        } else if (blockState.m_61143_(HORIZONTAL_FACING) == Direction.SOUTH) {
            Arrays.stream(QuarterDirection.values()).forEach(direction -> {
                if (QuarterPlacementType.includeDirection(placementType, direction)) {
                    shapes.add((VoxelShape)SOUTH_QUARTER_SHAPES.get((Object)direction.getMatrix()));
                }
            });
        } else if (blockState.m_61143_(HORIZONTAL_FACING) == Direction.EAST) {
            Arrays.stream(QuarterDirection.values()).forEach(direction -> {
                if (QuarterPlacementType.includeDirection(placementType, direction)) {
                    shapes.add((VoxelShape)EAST_QUARTER_SHAPES.get((Object)direction.getMatrix()));
                }
            });
        } else {
            Arrays.stream(QuarterDirection.values()).forEach(direction -> {
                if (QuarterPlacementType.includeDirection(placementType, direction)) {
                    shapes.add((VoxelShape)WEST_QUARTER_SHAPES.get((Object)direction.getMatrix()));
                }
            });
        }
        if (shapes.size() == 0) {
            return notExistsShape;
        }
        VoxelShape shape1 = (VoxelShape)shapes.get(0);
        if (shapes.size() == 1) {
            return shape1;
        }
        shapes.remove(0);
        return Shapes.m_83124_((VoxelShape)shape1, (VoxelShape[])shapes.toArray(new VoxelShape[0]));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        QuarterPlacementType next;
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        Direction facing = blockPlaceContext.m_8125_();
        QuarterDirection direction = this.getPlacementDirection(blockPlaceContext);
        QuarterPlacementType clickedPlacementType = QuarterPlacementType.get(direction.getMatrix());
        if (!blockState.m_60713_((Block)this)) {
            FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
            return this.update(clickedPlacementType.getQuarterType(), clickedPlacementType.getQuarterRotationType(), facing, fluidState.m_76152_() == Fluids.f_76193_);
        }
        QuarterPlacementType now = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        if (now == null) {
            return null;
        }
        if (facing != blockState.m_61143_(HORIZONTAL_FACING)) {
            now = (QuarterPlacementType)((Object)QUARTER_PLACEMENT_TYPE_INVERSION.get((Object)now));
        }
        if ((next = QuarterPlacementType.get(now.getMatrix() | clickedPlacementType.getMatrix())) == null) {
            return null;
        }
        return this.update(next.getQuarterType(), next.getQuarterRotationType(), facing, (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false && next.getQuarterType() != QuarterType.Q10);
    }

    private QuarterDirection getPlacementDirection(BlockPlaceContext blockPlaceContext) {
        BlockStateForPlacementUtils.Point clickPoint = BlockStateForPlacementUtils.getBlockClickPoint(blockPlaceContext);
        Direction facing = blockPlaceContext.m_8125_();
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        QuarterPlacementType now = null;
        if (blockState.m_60713_((Block)this)) {
            now = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        }
        if (now != null && facing != blockState.m_61143_(HORIZONTAL_FACING)) {
            now = (QuarterPlacementType)((Object)QUARTER_PLACEMENT_TYPE_INVERSION.get((Object)now));
        }
        if (blockPlaceContext.m_43719_() == Direction.UP) {
            if (clickPoint.x() < 0.33) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.SOUTH_EAST)) {
                    return QuarterDirection.NORTH_EAST;
                }
                return QuarterDirection.SOUTH_EAST;
            }
            if (clickPoint.x() >= 0.33 && clickPoint.x() <= 0.66) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.SOUTH)) {
                    return QuarterDirection.NORTH;
                }
                return QuarterDirection.SOUTH;
            }
            if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.SOUTH_WEST)) {
                return QuarterDirection.NORTH_WEST;
            }
            return QuarterDirection.SOUTH_WEST;
        }
        if (blockPlaceContext.m_43719_() == Direction.DOWN) {
            if (clickPoint.x() < 0.33) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.NORTH_EAST)) {
                    return QuarterDirection.SOUTH_EAST;
                }
                return QuarterDirection.NORTH_EAST;
            }
            if (clickPoint.x() >= 0.33 && clickPoint.x() <= 0.66) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.NORTH)) {
                    return QuarterDirection.SOUTH;
                }
                return QuarterDirection.NORTH;
            }
            if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.NORTH_WEST)) {
                return QuarterDirection.SOUTH_WEST;
            }
            return QuarterDirection.NORTH_WEST;
        }
        if (this.isHorizontal(facing, blockPlaceContext.m_43719_())) {
            if (clickPoint.y() < 0.33) {
                if (clickPoint.x() < 0.33) {
                    return QuarterDirection.SOUTH_EAST;
                }
                if (clickPoint.x() >= 0.33 && clickPoint.x() <= 0.66) {
                    return QuarterDirection.SOUTH;
                }
                return QuarterDirection.SOUTH_WEST;
            }
            if (clickPoint.y() >= 0.33 && clickPoint.y() <= 0.66) {
                if (clickPoint.x() < 0.5) {
                    return QuarterDirection.EAST;
                }
                return QuarterDirection.WEST;
            }
            if (clickPoint.y() > 0.66) {
                if (clickPoint.x() < 0.33) {
                    return QuarterDirection.NORTH_EAST;
                }
                if (clickPoint.x() >= 0.33 && clickPoint.x() <= 0.66) {
                    return QuarterDirection.NORTH;
                }
                return QuarterDirection.NORTH_WEST;
            }
        }
        if (clickPoint.y() < 0.33) {
            if (clickPoint.z() > 0.0 && clickPoint.z() < 1.0) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.SOUTH_EAST)) {
                    return QuarterDirection.SOUTH_WEST;
                }
                return QuarterDirection.SOUTH_EAST;
            }
            if (this.isClickedByRight(facing, blockPlaceContext)) {
                return QuarterDirection.SOUTH_WEST;
            }
            return QuarterDirection.SOUTH_EAST;
        }
        if (clickPoint.y() >= 0.33 && clickPoint.y() <= 0.66) {
            if (clickPoint.z() > 0.0 && clickPoint.z() < 1.0) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.EAST)) {
                    return QuarterDirection.WEST;
                }
                return QuarterDirection.EAST;
            }
            if (this.isClickedByRight(facing, blockPlaceContext)) {
                return QuarterDirection.WEST;
            }
            return QuarterDirection.EAST;
        }
        if (clickPoint.y() > 0.66) {
            if (clickPoint.z() > 0.0 && clickPoint.z() < 1.0) {
                if (now != null && !QuarterPlacementType.includeMaskDirection(now, QuarterDirection.NORTH_EAST)) {
                    return QuarterDirection.NORTH_WEST;
                }
                return QuarterDirection.NORTH_EAST;
            }
            if (this.isClickedByRight(facing, blockPlaceContext)) {
                return QuarterDirection.NORTH_WEST;
            }
            return QuarterDirection.NORTH_EAST;
        }
        return QuarterDirection.NORTH_WEST;
    }

    private BlockState update(QuarterType quarterType, QuarterRotationType rotationType, Direction facing, boolean waterLogged) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(QUARTER_TYPE, (Comparable)((Object)quarterType))).m_61124_(QUARTER_ROTATION, (Comparable)((Object)rotationType))).m_61124_(HORIZONTAL_FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged));
    }

    private boolean isHorizontal(Direction direction1, Direction direction2) {
        if (direction1 == Direction.SOUTH || direction1 == Direction.NORTH) {
            return direction2 == Direction.SOUTH || direction2 == Direction.NORTH;
        }
        return direction2 == Direction.EAST || direction2 == Direction.WEST;
    }

    private boolean isClickedByRight(Direction facing, BlockPlaceContext blockPlaceContext) {
        PositionImpl position = BlockStateForPlacementUtils.getPlayerPosition(blockPlaceContext);
        if (position == null) {
            return true;
        }
        return switch (facing) {
            case Direction.NORTH -> {
                if (position.m_7096_() < 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (position.m_7096_() > 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (position.m_7094_() < 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (position.m_7094_() > 0.0) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        BlockStateForPlacementUtils.Point clickPoint;
        ItemStack itemstack = blockPlaceContext.m_43722_();
        Direction facing = blockPlaceContext.m_8125_();
        QuarterPlacementType now = QuarterPlacementType.get((QuarterType)((Object)blockState.m_61143_(QUARTER_TYPE)), (QuarterRotationType)((Object)blockState.m_61143_(QUARTER_ROTATION)));
        if (now == null) {
            return true;
        }
        if (facing != blockState.m_61143_(HORIZONTAL_FACING)) {
            now = (QuarterPlacementType)((Object)QUARTER_PLACEMENT_TYPE_INVERSION.get((Object)now));
        }
        if ((clickPoint = BlockStateForPlacementUtils.getBlockClickPoint(blockPlaceContext)).z() == 1.0) {
            return false;
        }
        if (itemstack.m_41720_() == this.m_5456_() && this.isHorizontal(facing, (Direction)blockState.m_61143_(HORIZONTAL_FACING))) {
            QuarterDirection direction = this.getPlacementDirection(blockPlaceContext);
            return QuarterPlacementType.includeMaskDirection(now, direction);
        }
        return false;
    }

    public boolean m_7361_(LevelAccessor p_204509_1_, BlockPos p_204509_2_, BlockState p_204509_3_, FluidState p_204509_4_) {
        return p_204509_3_.m_61143_(QUARTER_TYPE) != QuarterType.Q10 && super.m_7361_(p_204509_1_, p_204509_2_, p_204509_3_, p_204509_4_);
    }

    public boolean m_6044_(BlockGetter p_204510_1_, BlockPos p_204510_2_, BlockState p_204510_3_, Fluid p_204510_4_) {
        return p_204510_3_.m_61143_(QUARTER_TYPE) != QuarterType.Q10 && super.m_6044_(p_204510_1_, p_204510_2_, p_204510_3_, p_204510_4_);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }
}

