/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import jp.artan.artansprojectcoremod.block.AbstractHexapodBlock;
import jp.artan.artansprojectcoremod.tags.BlockTagInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractQuarterHexapodBlock
extends AbstractHexapodBlock {
    protected static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    protected static final ImmutableMap<Direction, VoxelShape> HEXAPOD_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)UP_SHAPE).put((Object)Direction.DOWN, (Object)DOWN_SHAPE).put((Object)Direction.EAST, (Object)EAST_SHAPE).put((Object)Direction.NORTH, (Object)NORTH_SHAPE).put((Object)Direction.SOUTH, (Object)SOUTH_SHAPE).put((Object)Direction.WEST, (Object)WEST_SHAPE).build();

    public AbstractQuarterHexapodBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape getShape(BlockState blockState) {
        ArrayList shpes = new ArrayList();
        Arrays.stream(Direction.values()).forEach(direction -> {
            boolean isConnect = (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECTS.get(direction));
            if (isConnect) {
                shpes.add((VoxelShape)HEXAPOD_SHAPES.get(direction));
            }
        });
        return Shapes.m_83124_((VoxelShape)CENTER_SHAPE, (VoxelShape[])shpes.toArray(new VoxelShape[0]));
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AbstractQuarterHexapodBlock.getShape(blockState);
    }

    @Override
    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AbstractQuarterHexapodBlock.getShape(blockState);
    }

    @Override
    protected TagKey<Block> getBlockTag() {
        return BlockTagInit.QUARTER_HEXAPOD.get();
    }
}

