/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.artansprojectcoremod.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import jp.artan.artansprojectcoremod.block.properties.ModBlockStateProperties;
import jp.artan.artansprojectcoremod.entity.AbstractHexapodBlockEntity;
import jp.artan.artansprojectcoremod.tags.BlockTagInit;
import jp.artan.artansprojectcoremod.utils.inject.NonNullBiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHexapodBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty HEXAPOD_CONNECT_NORTH = ModBlockStateProperties.HEXAPOD_CONNECT_NORTH_TYPE;
    public static final BooleanProperty HEXAPOD_CONNECT_SOUTH = ModBlockStateProperties.HEXAPOD_CONNECT_SOUTH_TYPE;
    public static final BooleanProperty HEXAPOD_CONNECT_EAST = ModBlockStateProperties.HEXAPOD_CONNECT_EAST_TYPE;
    public static final BooleanProperty HEXAPOD_CONNECT_WEST = ModBlockStateProperties.HEXAPOD_CONNECT_WEST_TYPE;
    public static final BooleanProperty HEXAPOD_CONNECT_UP = ModBlockStateProperties.HEXAPOD_CONNECT_UP_TYPE;
    public static final BooleanProperty HEXAPOD_CONNECT_DOWN = ModBlockStateProperties.HEXAPOD_CONNECT_DOWN_TYPE;
    public static final ImmutableMap<Direction, BooleanProperty> HEXAPOD_CONNECTS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)HEXAPOD_CONNECT_NORTH).put((Object)Direction.SOUTH, (Object)HEXAPOD_CONNECT_SOUTH).put((Object)Direction.EAST, (Object)HEXAPOD_CONNECT_EAST).put((Object)Direction.WEST, (Object)HEXAPOD_CONNECT_WEST).put((Object)Direction.UP, (Object)HEXAPOD_CONNECT_UP).put((Object)Direction.DOWN, (Object)HEXAPOD_CONNECT_DOWN).build();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    protected static final ImmutableMap<Direction, VoxelShape> HEXAPOD_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)UP_SHAPE).put((Object)Direction.DOWN, (Object)DOWN_SHAPE).put((Object)Direction.EAST, (Object)EAST_SHAPE).put((Object)Direction.NORTH, (Object)NORTH_SHAPE).put((Object)Direction.SOUTH, (Object)SOUTH_SHAPE).put((Object)Direction.WEST, (Object)WEST_SHAPE).build();

    public AbstractHexapodBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HEXAPOD_CONNECT_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEXAPOD_CONNECT_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEXAPOD_CONNECT_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEXAPOD_CONNECT_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEXAPOD_CONNECT_UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEXAPOD_CONNECT_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return super.m_142354_(level, blockState, blockEntityType);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!player.m_21120_(interactionHand).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        Direction direction = blockHitResult.m_82434_();
        AbstractHexapodBlockEntity be = (AbstractHexapodBlockEntity)level.m_7702_(blockPos);
        if (be != null) {
            AbstractHexapodBlockEntity.HexapodConnect hexapodConnect = be.getHexapodConnect();
            AbstractHexapodBlockEntity.HexapodConnectType connectType = hexapodConnect.getConnect(direction);
            BooleanProperty blockConnect = (BooleanProperty)HEXAPOD_CONNECTS.get((Object)direction);
            if (connectType == AbstractHexapodBlockEntity.HexapodConnectType.FORCE_DISCONNECT) {
                BlockPos blockPosNext = blockPos.m_121945_(direction);
                AbstractHexapodBlockEntity beNext = (AbstractHexapodBlockEntity)level.m_7702_(blockPosNext);
                if (beNext instanceof AbstractHexapodBlockEntity) {
                    BlockState blockStateNext = level.m_8055_(blockPosNext);
                    AbstractHexapodBlockEntity.HexapodConnect hexapodConnectNext = beNext.getHexapodConnect();
                    BooleanProperty blockConnectNext = (BooleanProperty)HEXAPOD_CONNECTS.get((Object)direction.m_122424_());
                    if (this.connectsTo(beNext, blockStateNext, blockStateNext.m_60783_((BlockGetter)level, blockPosNext, direction.m_122424_()), direction.m_122424_())) {
                        if (blockStateNext.m_204336_(this.getBlockTag())) {
                            AbstractHexapodBlockEntity.HexapodConnectType connectTypeNext = hexapodConnectNext.getConnect(direction.m_122424_());
                            if (connectTypeNext != AbstractHexapodBlockEntity.HexapodConnectType.FORCE_DISCONNECT) {
                                hexapodConnect.setConnect(direction, AbstractHexapodBlockEntity.HexapodConnectType.CONNECT);
                                hexapodConnectNext.setConnect(direction.m_122424_(), AbstractHexapodBlockEntity.HexapodConnectType.CONNECT);
                                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)blockConnect, (Comparable)Boolean.valueOf(true)));
                                level.m_46597_(blockPosNext, (BlockState)blockStateNext.m_61124_((Property)blockConnectNext, (Comparable)Boolean.valueOf(true)));
                            }
                        } else {
                            hexapodConnect.setConnect(direction, AbstractHexapodBlockEntity.HexapodConnectType.CONNECT);
                            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)blockConnect, (Comparable)Boolean.valueOf(true)));
                        }
                    } else if (blockStateNext.m_204336_(this.getBlockTag())) {
                        hexapodConnect.setConnect(direction, AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT);
                        level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)blockConnect, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                hexapodConnect.setConnect(direction, AbstractHexapodBlockEntity.HexapodConnectType.FORCE_DISCONNECT);
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)blockConnect, (Comparable)Boolean.valueOf(false)));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{HEXAPOD_CONNECT_NORTH, HEXAPOD_CONNECT_SOUTH, HEXAPOD_CONNECT_EAST, HEXAPOD_CONNECT_WEST, HEXAPOD_CONNECT_UP, HEXAPOD_CONNECT_DOWN, WATERLOGGED});
    }

    private static VoxelShape getShape(BlockState blockState) {
        ArrayList shpes = new ArrayList();
        Arrays.stream(Direction.values()).forEach(direction -> {
            boolean isConnect = (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECTS.get(direction));
            if (isConnect) {
                shpes.add((VoxelShape)HEXAPOD_SHAPES.get(direction));
            }
        });
        return Shapes.m_83124_((VoxelShape)CENTER_SHAPE, (VoxelShape[])shpes.toArray(new VoxelShape[0]));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AbstractHexapodBlock.getShape(blockState);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AbstractHexapodBlock.getShape(blockState);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level levelReader = blockPlaceContext.m_43725_();
        BlockPos blockPos = blockPlaceContext.m_8083_();
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        BlockPos blockPosNorth = blockPos.m_122012_();
        BlockPos blockPosSouth = blockPos.m_122019_();
        BlockPos blockPosWest = blockPos.m_122024_();
        BlockPos blockPosEast = blockPos.m_122029_();
        BlockPos blockPosUp = blockPos.m_7494_();
        BlockPos blockPosDown = blockPos.m_7495_();
        BlockState blockStateNorth = levelReader.m_8055_(blockPosNorth);
        BlockState blockStateSouth = levelReader.m_8055_(blockPosSouth);
        BlockState blockStateWest = levelReader.m_8055_(blockPosWest);
        BlockState blockStateEast = levelReader.m_8055_(blockPosEast);
        BlockState blockStateUp = levelReader.m_8055_(blockPosUp);
        BlockState blockStateDown = levelReader.m_8055_(blockPosDown);
        BlockState blockState6 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        AbstractHexapodBlockEntity be = (AbstractHexapodBlockEntity)levelReader.m_7702_(blockPlaceContext.m_8083_());
        boolean blNorth = this.connectsTo(be, blockStateNorth, blockStateNorth.m_60783_((BlockGetter)levelReader, blockPosNorth, Direction.SOUTH), Direction.SOUTH);
        boolean blSouth = this.connectsTo(be, blockStateSouth, blockStateSouth.m_60783_((BlockGetter)levelReader, blockPosSouth, Direction.NORTH), Direction.NORTH);
        boolean blWest = this.connectsTo(be, blockStateWest, blockStateWest.m_60783_((BlockGetter)levelReader, blockPosWest, Direction.EAST), Direction.EAST);
        boolean blEast = this.connectsTo(be, blockStateEast, blockStateEast.m_60783_((BlockGetter)levelReader, blockPosEast, Direction.WEST), Direction.WEST);
        boolean blUp = this.connectsTo(be, blockStateUp, blockStateUp.m_60783_((BlockGetter)levelReader, blockPosUp, Direction.DOWN), Direction.DOWN);
        boolean blDown = this.connectsTo(be, blockStateDown, blockStateDown.m_60783_((BlockGetter)levelReader, blockPosDown, Direction.UP), Direction.UP);
        return this.update(be, blockState6, blNorth, blSouth, blWest, blEast, blUp, blDown);
    }

    private BlockState update(@Nullable AbstractHexapodBlockEntity be, BlockState blockState, boolean blNorth, boolean blSouth, boolean blWest, boolean blEast, boolean blUp, boolean blDown) {
        NonNullBiFunction<AbstractHexapodBlockEntity.HexapodConnectType, Boolean, AbstractHexapodBlockEntity.HexapodConnectType> func = (sideType, bl) -> {
            if (sideType == AbstractHexapodBlockEntity.HexapodConnectType.FORCE_DISCONNECT || sideType == AbstractHexapodBlockEntity.HexapodConnectType.FORCE_CONNECT) {
                return sideType;
            }
            return bl != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT;
        };
        if (be != null) {
            AbstractHexapodBlockEntity.HexapodConnect hexapodConnect = be.getHexapodConnect();
            hexapodConnect.setConnect(Direction.DOWN, func.apply(hexapodConnect.getConnect(Direction.DOWN), blDown)).setConnect(Direction.UP, func.apply(hexapodConnect.getConnect(Direction.UP), blUp)).setConnect(Direction.NORTH, func.apply(hexapodConnect.getConnect(Direction.NORTH), blNorth)).setConnect(Direction.SOUTH, func.apply(hexapodConnect.getConnect(Direction.SOUTH), blSouth)).setConnect(Direction.WEST, func.apply(hexapodConnect.getConnect(Direction.WEST), blWest)).setConnect(Direction.EAST, func.apply(hexapodConnect.getConnect(Direction.EAST), blEast));
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)HEXAPOD_CONNECT_NORTH, (Comparable)Boolean.valueOf(func.apply(hexapodConnect.getConnect(Direction.NORTH), blNorth) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT))).m_61124_((Property)HEXAPOD_CONNECT_SOUTH, (Comparable)Boolean.valueOf(func.apply(hexapodConnect.getConnect(Direction.SOUTH), blSouth) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT))).m_61124_((Property)HEXAPOD_CONNECT_EAST, (Comparable)Boolean.valueOf(func.apply(hexapodConnect.getConnect(Direction.EAST), blEast) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT))).m_61124_((Property)HEXAPOD_CONNECT_WEST, (Comparable)Boolean.valueOf(func.apply(hexapodConnect.getConnect(Direction.WEST), blWest) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT))).m_61124_((Property)HEXAPOD_CONNECT_UP, (Comparable)Boolean.valueOf(func.apply(hexapodConnect.getConnect(Direction.UP), blUp) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT))).m_61124_((Property)HEXAPOD_CONNECT_DOWN, (Comparable)Boolean.valueOf(func.apply(hexapodConnect.getConnect(Direction.DOWN), blDown) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)HEXAPOD_CONNECT_NORTH, (Comparable)Boolean.valueOf(blNorth))).m_61124_((Property)HEXAPOD_CONNECT_SOUTH, (Comparable)Boolean.valueOf(blSouth))).m_61124_((Property)HEXAPOD_CONNECT_EAST, (Comparable)Boolean.valueOf(blEast))).m_61124_((Property)HEXAPOD_CONNECT_WEST, (Comparable)Boolean.valueOf(blWest))).m_61124_((Property)HEXAPOD_CONNECT_UP, (Comparable)Boolean.valueOf(blUp))).m_61124_((Property)HEXAPOD_CONNECT_DOWN, (Comparable)Boolean.valueOf(blDown));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        AbstractHexapodBlockEntity be = (AbstractHexapodBlockEntity)levelAccessor.m_7702_(blockPos);
        AbstractHexapodBlockEntity be2 = null;
        try {
            be2 = (AbstractHexapodBlockEntity)levelAccessor.m_7702_(blockPos2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (be != null) {
            boolean blNorth = direction == Direction.NORTH ? this.connectsTo(be2, blockState2, blockState2.m_60783_((BlockGetter)levelAccessor, blockPos2, direction), direction.m_122424_()) : AbstractHexapodBlock.isConnected(be, Direction.NORTH);
            boolean blSouth = direction == Direction.SOUTH ? this.connectsTo(be2, blockState2, blockState2.m_60783_((BlockGetter)levelAccessor, blockPos2, direction), direction.m_122424_()) : AbstractHexapodBlock.isConnected(be, Direction.SOUTH);
            boolean blWest = direction == Direction.WEST ? this.connectsTo(be2, blockState2, blockState2.m_60783_((BlockGetter)levelAccessor, blockPos2, direction), direction.m_122424_()) : AbstractHexapodBlock.isConnected(be, Direction.WEST);
            boolean blEast = direction == Direction.EAST ? this.connectsTo(be2, blockState2, blockState2.m_60783_((BlockGetter)levelAccessor, blockPos2, direction), direction.m_122424_()) : AbstractHexapodBlock.isConnected(be, Direction.EAST);
            boolean blUp = direction == Direction.UP ? this.connectsTo(be2, blockState2, blockState2.m_60783_((BlockGetter)levelAccessor, blockPos2, direction), direction.m_122424_()) : AbstractHexapodBlock.isConnected(be, Direction.UP);
            boolean blDown = direction == Direction.DOWN ? this.connectsTo(be2, blockState2, blockState2.m_60783_((BlockGetter)levelAccessor, blockPos2, direction), direction.m_122424_()) : AbstractHexapodBlock.isConnected(be, Direction.DOWN);
            return this.update(be, blockState, blNorth, blSouth, blWest, blEast, blUp, blDown);
        }
        return blockState;
    }

    protected boolean connectsTo(@Nullable AbstractHexapodBlockEntity be2, BlockState blockState, boolean bl, Direction direction) {
        boolean isHexPod = blockState.m_204336_(this.getBlockTag());
        if (be2 instanceof AbstractHexapodBlockEntity && isHexPod) {
            return be2.getHexapodConnect().getConnect(direction) != AbstractHexapodBlockEntity.HexapodConnectType.FORCE_DISCONNECT;
        }
        return !AbstractHexapodBlock.m_152463_((BlockState)blockState) && bl;
    }

    private static boolean isConnected(AbstractHexapodBlockEntity be, Direction direction) {
        AbstractHexapodBlockEntity.HexapodConnect hexapodConnect = be.getHexapodConnect();
        return hexapodConnect.getConnect(direction) == AbstractHexapodBlockEntity.HexapodConnectType.CONNECT || hexapodConnect.getConnect(direction) == AbstractHexapodBlockEntity.HexapodConnectType.FORCE_CONNECT;
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    protected TagKey<Block> getBlockTag() {
        return BlockTagInit.HEXAPOD.get();
    }

    @Nullable
    public AbstractHexapodBlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        AbstractHexapodBlockEntity be = this.createBlockEntity(blockPos, blockState);
        be.getHexapodConnect().setConnect(Direction.NORTH, (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECT_NORTH) != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT).setConnect(Direction.SOUTH, (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECT_SOUTH) != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT).setConnect(Direction.EAST, (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECT_EAST) != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT).setConnect(Direction.WEST, (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECT_WEST) != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT).setConnect(Direction.UP, (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECT_UP) != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT).setConnect(Direction.DOWN, (Boolean)blockState.m_61143_((Property)HEXAPOD_CONNECT_DOWN) != false ? AbstractHexapodBlockEntity.HexapodConnectType.CONNECT : AbstractHexapodBlockEntity.HexapodConnectType.DISCONNECT);
        return be;
    }

    public abstract AbstractHexapodBlockEntity createBlockEntity(BlockPos var1, BlockState var2);
}

