/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import xfacthd.framedblocks.common.datagen.builders.book.GuidebookBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.chapter.ChapterBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.chapter.SectionBuilder;

public abstract class GuidebookProvider
implements DataProvider {
    private final PackOutput output;
    private final String modid;
    private final List<GuidebookBuilder> books = new ArrayList<GuidebookBuilder>();

    protected GuidebookProvider(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    protected abstract void addBooks();

    protected final GuidebookBuilder book(String name) {
        GuidebookBuilder builder = new GuidebookBuilder(name);
        this.books.add(builder);
        return builder;
    }

    protected static ChapterBuilder chapter(String id) {
        return new ChapterBuilder(id);
    }

    protected static SectionBuilder section(String id) {
        return new SectionBuilder("section", id);
    }

    protected static SectionBuilder page(String id) {
        return new SectionBuilder("page", id);
    }

    protected static String sectionRef(String chapter, String section) {
        return chapter + ":" + section;
    }

    public final CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        this.addBooks();
        if (!this.books.isEmpty()) {
            Path packPath = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid);
            this.books.forEach(GuidebookBuilder::validate);
            List futures = this.books.stream().map(book -> {
                Path path = packPath.resolve(GuidebookProvider.makeBookPath(book));
                return GuidebookProvider.saveBook(cachedOutput, book, path);
            }).collect(Collectors.toCollection(ArrayList::new));
            futures.add(this.saveBookJson(cachedOutput, packPath));
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private static CompletableFuture<?> saveBook(CachedOutput cachedOutput, GuidebookBuilder book, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
                HashingOutputStream hashOutStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteOutStream);
                book.print((OutputStream)hashOutStream);
                cachedOutput.m_213871_(path, byteOutStream.toByteArray(), hashOutStream.hash());
            }
            catch (IOException e) {
                f_252483_.error("Failed to save file to {}", (Object)path, (Object)e);
            }
        });
    }

    private CompletableFuture<?> saveBookJson(CachedOutput cachedOutput, Path path) {
        JsonArray bookArray = new JsonArray();
        this.books.forEach(book -> bookArray.add(this.modid + ":" + GuidebookProvider.makeBookPath(book)));
        return DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)bookArray, (Path)path.resolve("books.json"));
    }

    private static String makeBookPath(GuidebookBuilder book) {
        return "books/" + book.getName() + ".xml";
    }

    public String m_6055_() {
        return "Guidebooks";
    }
}

