/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.special;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.TestProperties;
import xfacthd.framedblocks.client.util.ClientConfig;

public final class BlockOutlineRenderer {
    private static final Map<IBlockType, OutlineRenderer> OUTLINE_RENDERERS = new HashMap<IBlockType, OutlineRenderer>();
    private static final Set<IBlockType> ERRORED_TYPES = new HashSet<IBlockType>();
    private static boolean locked = false;

    public static void onRenderBlockHighlight(RenderHighlightEvent.Block event) {
        if (!ClientConfig.fancyHitboxes && !TestProperties.ENABLE_OCCLUSION_SHAPE_DEBUG_RENDERER) {
            return;
        }
        BlockHitResult result = event.getTarget();
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(result.m_82425_());
        Block block = state.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        if (TestProperties.ENABLE_OCCLUSION_SHAPE_DEBUG_RENDERER) {
            VertexConsumer builder = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
            VoxelShape shape = state.m_60768_((BlockGetter)Minecraft.m_91087_().f_91073_, result.m_82425_());
            Vec3 offset = Vec3.m_82528_((Vec3i)result.m_82425_()).m_82546_(event.getCamera().m_90583_());
            LevelRenderer.m_109782_((PoseStack)event.getPoseStack(), (VertexConsumer)builder, (VoxelShape)shape, (double)offset.f_82479_, (double)offset.f_82480_, (double)offset.f_82481_, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            event.setCanceled(true);
            return;
        }
        IBlockType type = block2.getBlockType();
        if (type.hasSpecialHitbox()) {
            OutlineRenderer renderer = OUTLINE_RENDERERS.get(type);
            if (renderer == null) {
                if (ERRORED_TYPES.add(type)) {
                    FramedBlocks.LOGGER.error("IBlockType '{}' requests custom outline rendering but no OutlineRender was registered!", (Object)type.getName());
                }
                return;
            }
            PoseStack mstack = event.getPoseStack();
            Vec3 offset = Vec3.m_82528_((Vec3i)result.m_82425_()).m_82546_(event.getCamera().m_90583_());
            VertexConsumer builder = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
            mstack.m_85836_();
            mstack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            mstack.m_85837_(0.5, 0.5, 0.5);
            renderer.rotateMatrix(mstack, state);
            mstack.m_85837_(-0.5, -0.5, -0.5);
            renderer.draw(state, (Level)Minecraft.m_91087_().f_91073_, result.m_82425_(), mstack, builder);
            mstack.m_85849_();
            event.setCanceled(true);
        }
    }

    public static synchronized void registerOutlineRender(IBlockType type, OutlineRenderer render) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"OutlineRenderer registry is locked!");
        if (!type.hasSpecialHitbox()) {
            throw new IllegalArgumentException(String.format("Type %s doesn't return true from IBlockType#hasSpecialHitbox()", type));
        }
        OUTLINE_RENDERERS.put(type, render);
    }

    public static void lockRegistration() {
        locked = true;
    }

    public static boolean hasOutlineRenderer(IBlockType type) {
        return OUTLINE_RENDERERS.containsKey(type);
    }

    private BlockOutlineRenderer() {
    }
}

