/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.helper;

import fuzs.hangglider.capability.GlidingCapability;
import fuzs.hangglider.init.ModRegistry;
import fuzs.hangglider.world.item.GliderItem;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;

public class PlayerGlidingHelper {
    public static boolean isAllowedToGlide(Player player) {
        return !player.m_20096_() && !player.m_20159_() && !player.m_21023_(MobEffects.f_19620_) && !player.m_150110_().f_35935_ && !player.m_20069_() && player.m_20184_().f_82480_ < 0.0;
    }

    public static boolean isValidGlider(ItemStack stack) {
        return stack.m_41720_() instanceof GliderItem && ElytraItem.m_41140_((ItemStack)stack);
    }

    public static ItemStack getGliderInHand(Player player) {
        return PlayerGlidingHelper.getGliderHoldingHand(player).map(arg_0 -> ((Player)player).m_6844_(arg_0)).orElse(ItemStack.f_41583_);
    }

    public static Optional<EquipmentSlot> getGliderHoldingHand(Player player) {
        return Stream.of(EquipmentSlot.values()).filter(slot -> slot.m_20743_() == EquipmentSlot.Type.HAND).filter(slot -> player.m_6844_(slot).m_41720_() instanceof GliderItem).findAny();
    }

    public static boolean isGliderDeployed(Player player) {
        return ModRegistry.GLIDING_CAPABILITY.maybeGet((Object)player).map(GlidingCapability::isGliderDeployed).orElse(false);
    }

    public static void setGliderDeployed(Player player, boolean gliderDeployed) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ModRegistry.GLIDING_CAPABILITY.maybeGet((Object)player).ifPresent(capability -> {
            boolean wasGliderDeployed = capability.isGliderDeployed();
            capability.setGliderDeployed(gliderDeployed);
            if (wasGliderDeployed != capability.isGliderDeployed() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModRegistry.GLIDING_CAPABILITY.syncToRemote(serverPlayer);
            }
        });
    }

    public static boolean isGliding(Player player) {
        return ModRegistry.GLIDING_CAPABILITY.maybeGet((Object)player).map(GlidingCapability::isGliding).orElse(false);
    }

    public static void setGliding(Player player, boolean gliding) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ModRegistry.GLIDING_CAPABILITY.maybeGet((Object)player).ifPresent(capability -> {
            boolean wasGliding = capability.isGliding();
            capability.setGliding(gliding);
            if (wasGliding != capability.isGliding() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModRegistry.GLIDING_CAPABILITY.syncToRemote(serverPlayer);
            }
        });
    }
}

