/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidKey {
    public final Fluid fluid;
    public CompoundTag tag;
    private final int amount;

    public FluidKey(FluidStack fluidStack) {
        this.fluid = fluidStack.getFluid();
        this.tag = fluidStack.getTag();
        this.amount = fluidStack.getAmount();
    }

    public FluidKey copy() {
        return new FluidKey(new FluidStack(this.getFluid(), this.amount, this.tag));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FluidKey)) {
            return false;
        }
        FluidKey fluidKey = (FluidKey)o;
        if (!Objects.equals(this.fluid, fluidKey.fluid)) {
            return false;
        }
        if (this.tag == null && fluidKey.tag != null) {
            return false;
        }
        return this.tag == null || this.tag.equals((Object)fluidKey.tag);
    }

    public int hashCode() {
        int hash = 0;
        hash += Objects.hash(this.fluid);
        if (this.tag != null && !this.tag.m_128456_()) {
            hash += this.tag.hashCode();
        }
        return hash;
    }

    public String toString() {
        return "FluidKey{fluid=" + this.fluid + ", tag=" + this.tag + "}";
    }

    public Fluid getFluid() {
        return this.fluid;
    }
}

