/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ParallelProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return GTCEu.id("parallel");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        BlockEntity blockEntity = level.m_7702_(iProbeHitData.getPos());
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity machineBlockEntity = (MetaMachineBlockEntity)blockEntity;
            int parallel = 0;
            boolean exact = false;
            MetaMachine metaMachine = machineBlockEntity.getMetaMachine();
            if (metaMachine instanceof IParallelHatch) {
                IParallelHatch parallelHatch = (IParallelHatch)((Object)metaMachine);
                parallel = parallelHatch.getCurrentParallel();
            } else {
                metaMachine = machineBlockEntity.getMetaMachine();
                if (metaMachine instanceof IMultiController) {
                    IRecipeLogicMachine rlm;
                    IMultiController controller = (IMultiController)((Object)metaMachine);
                    if (controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isActive() && rlm.getRecipeLogic().getLastRecipe() != null) {
                        parallel = rlm.getRecipeLogic().getLastRecipe().parallels;
                        exact = true;
                    } else {
                        parallel = controller.getParallelHatch().map(IParallelHatch::getCurrentParallel).orElse(0);
                    }
                }
            }
            if (parallel > 0) {
                MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                Object key = "gtceu.multiblock.parallel";
                if (exact) {
                    key = (String)key + ".exact";
                }
                iProbeInfo.text((Component)Component.m_237110_((String)key, (Object[])new Object[]{parallels}));
            }
        }
    }
}

