/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.xaeros;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.integration.map.GenericMapRenderer;
import com.gregtechceu.gtceu.integration.map.xaeros.XaerosMapPlugin;
import com.gregtechceu.gtceu.integration.map.xaeros.minimap.ore.OreVeinElement;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class XaerosRenderer
extends GenericMapRenderer {
    public static final Table<ResourceKey<Level>, String, OreVeinElement> oreElements = HashBasedTable.create();
    public static final Table<ResourceKey<Level>, ChunkPos, ProspectorMode.FluidInfo> fluidElements = HashBasedTable.create();

    @Override
    public boolean addMarker(String name, String id, ResourceKey<Level> dim, ChunkPos pos, ProspectorMode.FluidInfo fluid) {
        fluidElements.put(dim, (Object)pos, (Object)fluid);
        return true;
    }

    @Override
    public boolean addMarker(String name, ResourceKey<Level> dim, GeneratedVeinMetadata vein, String id) {
        oreElements.put(dim, (Object)id, (Object)new OreVeinElement(vein, name));
        return true;
    }

    @Override
    public boolean removeMarker(ResourceKey<Level> dim, String id) {
        OreVeinElement marker = (OreVeinElement)oreElements.remove(dim, (Object)id);
        return marker != null;
    }

    @Override
    public boolean doShowLayer(String name) {
        return XaerosMapPlugin.getOptionValue(name);
    }

    @Override
    public void setLayerActive(String name, boolean active) {
        XaerosMapPlugin.toggleOption(name, active);
    }
}

