/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.ftbchunks;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class FTBChunksOptions {
    private static final Map<String, BooleanValue> layerOptions = new HashMap<String, BooleanValue>();
    private static final SNBTConfig CONFIG = SNBTConfig.create((String)"gtceu");
    private static final SNBTConfig LAYERS = CONFIG.addGroup("journeymap.options.layers");
    private static final BooleanValue ORE_LAYER = LAYERS.addBoolean("ore_veins", false);
    private static final BooleanValue FLUID_LAYER = LAYERS.addBoolean("bedrock_fluids", false);
    private static final BooleanValue HIDE_DEPLETED = LAYERS.addBoolean("hide_depleted", false);

    private FTBChunksOptions() {
    }

    public static boolean showLayer(String name) {
        return (Boolean)layerOptions.get(name).get();
    }

    public static void toggleLayer(String name, boolean active) {
        layerOptions.get(name).set((Object)active);
        FTBChunksOptions.saveConfig();
        FTBChunksAPI.clientApi().getWaypointManager().ifPresent(manager -> manager.getAllWaypoints().forEach(waypoint -> {
            if (waypoint.getName().equals(name)) {
                waypoint.setHidden(!active);
            }
        }));
    }

    public static boolean hideDepleted() {
        return (Boolean)HIDE_DEPLETED.get();
    }

    public static void loadConfig() {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)ConfigUtil.LOCAL_DIR.resolve("gtceu"), (String)"gtceu", (String)"client-config.snbt");
    }

    public static void saveConfig() {
        CONFIG.save(ConfigUtil.LOCAL_DIR.resolve("gtceu").resolve("client-config.snbt"));
    }

    static {
        layerOptions.put(FTBChunksOptions.ORE_LAYER.key, ORE_LAYER);
        layerOptions.put(FTBChunksOptions.FLUID_LAYER.key, FLUID_LAYER);
        layerOptions.put(FTBChunksOptions.HIDE_DEPLETED.key, HIDE_DEPLETED);
        FTBChunksOptions.loadConfig();
    }
}

