/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.latvian.mods.kubejs.client.LangEventJS;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;

public class KJSTieredMachineBuilder
extends BuilderBase<MachineDefinition[]> {
    public volatile int[] tiers = GTMachineUtils.ELECTRIC_TIERS;
    public volatile TieredCreationFunction machine;
    public volatile DefinitionFunction definition = (tier, def) -> def.tier(tier);
    public volatile Int2IntFunction tankScalingFunction = GTMachineUtils.defaultTankSizeFunction;
    public volatile boolean addDefaultTooltips = true;
    public volatile BiFunction<ResourceLocation, GTRecipeType, EditableMachineUI> editableUI;

    public KJSTieredMachineBuilder(ResourceLocation id) {
        super(id);
    }

    public KJSTieredMachineBuilder(ResourceLocation id, TieredCreationFunction machine, BiFunction<ResourceLocation, GTRecipeType, EditableMachineUI> editableUI) {
        super(id);
        this.machine = machine;
        this.editableUI = editableUI;
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        for (int tier : this.tiers) {
            MachineDefinition def = ((MachineDefinition[])this.value)[tier];
            lang.add("gtceu", def.getDescriptionId(), def.getLangValue());
        }
    }

    @Override
    public MachineDefinition[] register() {
        Preconditions.checkNotNull((Object)this.tiers, (Object)"Tiers can't be null!");
        Preconditions.checkArgument((this.tiers.length > 0 ? 1 : 0) != 0, (Object)"tiers must have at least one tier!");
        Preconditions.checkNotNull((Object)this.machine, (Object)"You must set a machine creation function! example: `builder.machine((holder, tier) => new SimpleTieredMachine(holder, tier, t => t * 3200)`");
        Preconditions.checkNotNull((Object)this.definition, (Object)"You must set a definition function! See GTMachines for examples");
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : this.tiers) {
            String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
            MachineBuilder<MachineDefinition> builder = GTRegistration.REGISTRATE.machine(String.format("%s_%s", tierName, this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, tier, this.tankScalingFunction));
            builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(this.id.m_135815_()), GTValues.VLVT[tier])).workableTieredHullRenderer(this.id.m_246208_("block/machines/")).tier(tier);
            this.definition.apply(tier, builder);
            if (builder.recipeTypes() != null && builder.recipeTypes().length > 0) {
                GTRecipeType recipeType = builder.recipeTypes()[0];
                if (this.editableUI != null && builder.editableUI() == null) {
                    builder.editableUI(this.editableUI.apply(this.id, recipeType));
                }
                if (this.tankScalingFunction != null && this.addDefaultTooltips) {
                    builder.tooltips(GTMachineUtils.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, ((Integer)this.tankScalingFunction.apply((Object)tier)).intValue(), true));
                }
            }
            definitions[tier] = builder.register();
        }
        this.value = definitions;
        return definitions;
    }

    public KJSTieredMachineBuilder tiers(int[] tiers) {
        this.tiers = tiers;
        return this;
    }

    public KJSTieredMachineBuilder machine(TieredCreationFunction machine) {
        this.machine = machine;
        return this;
    }

    public KJSTieredMachineBuilder definition(DefinitionFunction definition) {
        this.definition = definition;
        return this;
    }

    public KJSTieredMachineBuilder tankScalingFunction(Int2IntFunction tankScalingFunction) {
        this.tankScalingFunction = tankScalingFunction;
        return this;
    }

    public KJSTieredMachineBuilder addDefaultTooltips(boolean addDefaultTooltips) {
        this.addDefaultTooltips = addDefaultTooltips;
        return this;
    }

    @FunctionalInterface
    public static interface DefinitionFunction {
        public void apply(int var1, MachineBuilder<?> var2);
    }

    @FunctionalInterface
    public static interface TieredCreationFunction {
        public MetaMachine create(IMachineBlockEntity var1, int var2, Int2IntFunction var3);
    }

    @FunctionalInterface
    public static interface CreationFunction<T extends MetaMachine> {
        public T create(IMachineBlockEntity var1);
    }
}

