/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.block;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.SimpleCoilType;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoilBlockBuilder
extends BlockBuilder {
    public transient int temperature = 0;
    public transient int level = 0;
    public transient int energyDiscount = 1;
    public transient int tier = 0;
    public transient @NotNull Supplier<@Nullable Material> material = () -> null;
    public transient ResourceLocation texture = new ResourceLocation("missingno");

    public CoilBlockBuilder(ResourceLocation i) {
        super(i);
    }

    public CoilBlockBuilder coilMaterial(@NotNull Supplier<@Nullable Material> material) {
        this.material = material;
        return this;
    }

    public Block createObject() {
        SimpleCoilType coilType = new SimpleCoilType(this.id.m_135815_(), this.temperature, this.level, this.energyDiscount, this.tier, this.material, this.texture);
        CoilBlock result = new CoilBlock(this.createProperties(), coilType);
        GTCEuAPI.HEATING_COILS.put(coilType, () -> result);
        return result;
    }

    public CoilBlockBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public CoilBlockBuilder level(int level) {
        this.level = level;
        return this;
    }

    public CoilBlockBuilder energyDiscount(int energyDiscount) {
        this.energyDiscount = energyDiscount;
        return this;
    }

    public CoilBlockBuilder tier(int tier) {
        this.tier = tier;
        return this;
    }

    public CoilBlockBuilder texture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }
}

