/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.ResearchStationMachine;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;

public class WorkableBlockProvider
extends CapabilityBlockProvider<IWorkable> {
    public WorkableBlockProvider() {
        super(GTCEu.id("workable_provider"));
    }

    @Override
    @Nullable
    protected IWorkable getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getWorkable(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, IWorkable capability) {
        data.m_128379_("Active", capability.isActive());
        data.m_128405_("Progress", capability.getProgress());
        data.m_128405_("MaxProgress", capability.getMaxProgress());
        if (capability instanceof ResearchStationMachine) {
            ResearchStationMachine rsm = (ResearchStationMachine)capability;
            data.m_128379_("Research", true);
        }
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        if (!capData.m_128471_("Active")) {
            return;
        }
        int currentProgress = capData.m_128451_("Progress");
        int maxProgress = capData.m_128451_("MaxProgress");
        if (capData.m_128471_("Research")) {
            String current = FormattingUtil.formatNumberReadable(currentProgress);
            String max = FormattingUtil.formatNumberReadable(maxProgress);
            MutableComponent text = Component.m_237110_((String)"gtceu.jade.progress_computation", (Object[])new Object[]{current, max});
            tooltip.add(tooltip.getElementHelper().progress(this.getProgress(currentProgress, maxProgress), (Component)text, tooltip.getElementHelper().progressStyle().color(-16749206).textColor(-1), (IBoxStyle)Util.m_137469_((Object)BoxStyle.DEFAULT, style -> {
                style.borderColor = -11184811;
            }), true));
            return;
        }
        MutableComponent text = maxProgress < 20 ? Component.m_237110_((String)"gtceu.jade.progress_tick", (Object[])new Object[]{currentProgress, maxProgress}) : Component.m_237110_((String)"gtceu.jade.progress_sec", (Object[])new Object[]{Math.round((float)currentProgress / 20.0f), Math.round((float)maxProgress / 20.0f)});
        if (maxProgress > 0) {
            int color = capData.m_128471_("WorkingEnabled") ? -11748585 : -4514776;
            tooltip.add(tooltip.getElementHelper().progress(this.getProgress(currentProgress, maxProgress), (Component)text, tooltip.getElementHelper().progressStyle().color(color).textColor(-1), (IBoxStyle)Util.m_137469_((Object)BoxStyle.DEFAULT, style -> {
                style.borderColor = -11184811;
            }), true));
        }
    }
}

