/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeTankMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.FluidStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.FluidTextHelper;

public enum GTFluidStorageProvider implements IServerExtensionProvider<MetaMachineBlockEntity, CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return GTCEu.id("custom_fluid_storage");
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return ClientViewGroup.map(groups, GTFluidStorageProvider::readFluid, null);
    }

    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, MetaMachineBlockEntity mmbe, boolean b) {
        MetaMachine metaMachine = mmbe.getMetaMachine();
        if (metaMachine instanceof QuantumTankMachine) {
            QuantumTankMachine qtm = (QuantumTankMachine)metaMachine;
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("special", true);
            FluidStack stored = qtm.getStored();
            tag.m_128359_("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)stored.getFluid()).toString());
            long amount = qtm.getStoredAmount();
            if (qtm instanceof CreativeTankMachine) {
                CreativeTankMachine ctm = (CreativeTankMachine)qtm;
                amount = (long)Math.ceil(1.0 * (double)ctm.getMBPerCycle() / (double)ctm.getTicksPerCycle());
            }
            tag.m_128356_("amount", amount);
            tag.m_128356_("capacity", qtm.getMaxAmount());
            if (stored.hasTag()) {
                tag.m_128365_("tag", (Tag)stored.getTag());
            }
            return List.of(new ViewGroup(List.of(tag)));
        }
        return FluidStorageProvider.INSTANCE.getGroups(serverPlayer, serverLevel, (Object)mmbe, b);
    }

    private static FluidView readFluid(CompoundTag tag) {
        if (!tag.m_128441_("special")) {
            return FluidView.readDefault((CompoundTag)tag);
        }
        long capacity = tag.m_128454_("capacity");
        if (capacity <= 0L) {
            return null;
        }
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(tag.m_128461_("fluid")));
        CompoundTag nbt = tag.m_128441_("nbt") ? tag.m_128469_("nbt") : null;
        long amount = tag.m_128454_("amount");
        JadeFluidObject fluidObject = JadeFluidObject.of((Fluid)fluid, (long)1000L, (CompoundTag)nbt);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluidObject));
        fluidView.fluidName = fluid.getFluidType().getDescription();
        fluidView.current = FluidTextHelper.getUnicodeMillibuckets((long)amount, (boolean)true);
        fluidView.max = FluidTextHelper.getUnicodeMillibuckets((long)capacity, (boolean)true);
        fluidView.ratio = (float)((double)amount / (double)capacity);
        return fluidView;
    }
}

