/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAESlot;
import com.gregtechceu.gtceu.utils.GTMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExportOnlyAEFluidSlot
extends ExportOnlyAESlot
implements IFluidHandlerModifiable,
IFluidTank {
    public ExportOnlyAEFluidSlot() {
    }

    public ExportOnlyAEFluidSlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        super(config, stock);
    }

    @Override
    public void addStack(GenericStack stack) {
        this.stock = this.stock == null ? stack : GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
        this.onContentsChanged();
    }

    @Override
    public void setStock(@Nullable GenericStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else {
            if (stack.equals((Object)this.stock)) {
                return;
            }
            this.stock = stack;
        }
        this.onContentsChanged();
    }

    public FluidStack getFluid() {
        AEKey aEKey;
        if (this.stock != null && (aEKey = this.stock.what()) instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return fluidKey.toStack(GTMath.saturatedCast(this.stock.amount()));
        }
        return FluidStack.EMPTY;
    }

    public boolean isFluidValid(FluidStack stack) {
        return false;
    }

    public int getFluidAmount() {
        return this.stock != null ? GTMath.saturatedCast(this.stock.amount()) : 0;
    }

    public int getCapacity() {
        return 0;
    }

    public int getTanks() {
        return 0;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
    }

    public int getTankCapacity(int tank) {
        return 0;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getFluid().isFluidEqual(resource)) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        AEKey aEKey;
        if (this.stock == null || !((aEKey = this.stock.what()) instanceof AEFluidKey)) {
            return FluidStack.EMPTY;
        }
        AEFluidKey fluidKey = (AEFluidKey)aEKey;
        int drained = (int)Math.min(this.stock.amount(), (long)maxDrain);
        FluidStack result = fluidKey.toStack(drained);
        if (action.execute()) {
            this.stock = new GenericStack(this.stock.what(), this.stock.amount() - (long)drained);
            if (this.stock.amount() == 0L) {
                this.stock = null;
            }
            this.onContentsChanged();
        }
        return result;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return tank == 0;
    }

    public void onContentsChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    @Override
    public ExportOnlyAEFluidSlot copy() {
        return new ExportOnlyAEFluidSlot(this.config == null ? null : ExportOnlyAESlot.copy(this.config), this.stock == null ? null : ExportOnlyAESlot.copy(this.stock));
    }
}

