/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.integration.ae2.machine.MEInputHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.multiblock.IMEStockingPart;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEFluidList;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEFluidSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAESlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.gregtechceu.gtceu.integration.ae2.utils.AEUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEStockingHatchPartMachine
extends MEInputHatchPartMachine
implements IMEStockingPart {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEStockingHatchPartMachine.class, MEInputHatchPartMachine.MANAGED_FIELD_HOLDER);
    private static final int CONFIG_SIZE = 16;
    @DescSynced
    @Persisted
    private boolean autoPull;
    private Predicate<GenericStack> autoPullTest = $ -> false;

    public MEStockingHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        IMEStockingPart.super.addedToController(controller);
    }

    @Override
    public void removedFromController(IMultiController controller) {
        IMEStockingPart.super.removedFromController(controller);
        super.removedFromController(controller);
    }

    @Override
    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        this.aeFluidHandler = new ExportOnlyAEStockingFluidList(this, 16);
        return this.aeFluidHandler;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void autoIO() {
        super.autoIO();
        if (this.autoPull && this.getOffsetTimer() % 100L == 0L) {
            this.refreshList();
            this.syncME();
        }
    }

    @Override
    protected void syncME() {
        MEStorage networkInv = this.getMainNode().getGrid().getStorageService().getInventory();
        for (ExportOnlyAEFluidSlot slot : this.aeFluidHandler.getInventory()) {
            AEKey key;
            long extracted;
            GenericStack config = slot.getConfig();
            if (config != null && (extracted = networkInv.extract(key = config.what(), Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource)) > 0L) {
                slot.setStock(new GenericStack(key, extracted));
                continue;
            }
            slot.setStock(null);
        }
    }

    @Override
    protected void flushInventory() {
    }

    @Override
    public IConfigurableSlotList getSlotList() {
        return this.aeFluidHandler;
    }

    @Override
    public boolean testConfiguredInOtherPart(@Nullable GenericStack config) {
        if (config == null) {
            return false;
        }
        if (!this.isFormed()) {
            return false;
        }
        for (IMultiController controller : this.getControllers()) {
            for (IMultiPart part : controller.getParts()) {
                MEStockingHatchPartMachine hatch;
                if (!(part instanceof MEStockingHatchPartMachine) || (hatch = (MEStockingHatchPartMachine)part) == this || !hatch.aeFluidHandler.hasStackInConfig(config, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setAutoPull(boolean autoPull) {
        this.autoPull = autoPull;
        if (!this.isRemote()) {
            if (!this.autoPull) {
                this.aeFluidHandler.clearInventory(0);
            } else if (this.updateMEStatus()) {
                this.refreshList();
                this.updateTankSubscription();
            }
        }
    }

    private void refreshList() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            this.aeFluidHandler.clearInventory(0);
            return;
        }
        MEStorage networkStorage = grid.getStorageService().getInventory();
        KeyCounter counter = networkStorage.getAvailableStacks();
        int index = 0;
        for (Object2LongMap.Entry entry : counter) {
            if (index >= 16) break;
            AEKey what = (AEKey)entry.getKey();
            long amount = entry.getLongValue();
            if (amount <= 0L || !(what instanceof AEFluidKey)) continue;
            AEFluidKey fluidKey = (AEFluidKey)what;
            long request = networkStorage.extract(what, amount, Actionable.SIMULATE, this.actionSource);
            if (request == 0L || this.autoPullTest != null && !this.autoPullTest.test(new GenericStack((AEKey)fluidKey, amount))) continue;
            ExportOnlyAEFluidSlot slot = this.aeFluidHandler.getInventory()[index];
            slot.setConfig(new GenericStack(what, 1L));
            slot.setStock(new GenericStack(what, request));
            ++index;
        }
        this.aeFluidHandler.clearInventory(index);
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        IMEStockingPart.super.attachConfigurators(configuratorPanel);
        super.attachConfigurators(configuratorPanel);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            this.setAutoPull(!this.autoPull);
            if (this.autoPull) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.stocking_auto_pull_enabled"));
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.stocking_auto_pull_disabled"));
            }
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    @Override
    protected CompoundTag writeConfigToTag() {
        if (!this.autoPull) {
            CompoundTag tag = super.writeConfigToTag();
            tag.m_128379_("AutoPull", false);
            return tag;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("AutoPull", true);
        tag.m_128344_("GhostCircuit", (byte)IntCircuitBehaviour.getCircuitConfiguration(this.circuitInventory.getStackInSlot(0)));
        return tag;
    }

    @Override
    protected void readConfigFromTag(CompoundTag tag) {
        if (tag.m_128471_("AutoPull")) {
            this.setAutoPull(true);
            this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(tag.m_128445_("GhostCircuit")));
            return;
        }
        this.setAutoPull(false);
        super.readConfigFromTag(tag);
    }

    @Override
    public boolean isAutoPull() {
        return this.autoPull;
    }

    @Override
    public void setAutoPullTest(Predicate<GenericStack> autoPullTest) {
        this.autoPullTest = autoPullTest;
    }

    private class ExportOnlyAEStockingFluidList
    extends ExportOnlyAEFluidList {
        public ExportOnlyAEStockingFluidList(MetaMachine holder, int slots) {
            super(holder, slots, () -> new ExportOnlyAEStockingFluidSlot());
        }

        @Override
        public boolean isAutoPull() {
            return MEStockingHatchPartMachine.this.autoPull;
        }

        @Override
        public boolean isStocking() {
            return true;
        }

        @Override
        public boolean hasStackInConfig(GenericStack stack, boolean checkExternal) {
            boolean inThisHatch = super.hasStackInConfig(stack, false);
            if (inThisHatch) {
                return true;
            }
            if (checkExternal) {
                return MEStockingHatchPartMachine.this.testConfiguredInOtherPart(stack);
            }
            return false;
        }
    }

    private class ExportOnlyAEStockingFluidSlot
    extends ExportOnlyAEFluidSlot {
        public ExportOnlyAEStockingFluidSlot() {
        }

        public ExportOnlyAEStockingFluidSlot(@Nullable GenericStack config, GenericStack stock) {
            super(config, stock);
        }

        @Override
        public ExportOnlyAEFluidSlot copy() {
            return new ExportOnlyAEStockingFluidSlot(this.config == null ? null : ExportOnlyAEStockingFluidSlot.copy(this.config), this.stock == null ? null : ExportOnlyAEStockingFluidSlot.copy(this.stock));
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.stock != null && this.config != null) {
                if (!MEStockingHatchPartMachine.this.isOnline()) {
                    return FluidStack.EMPTY;
                }
                MEStorage aeNetwork = MEStockingHatchPartMachine.this.getMainNode().getGrid().getStorageService().getInventory();
                Actionable actionable = action.simulate() ? Actionable.SIMULATE : Actionable.MODULATE;
                AEKey key = this.config.what();
                long extracted = aeNetwork.extract(key, (long)maxDrain, actionable, MEStockingHatchPartMachine.this.actionSource);
                if (extracted > 0L) {
                    FluidStack resultStack;
                    if (key instanceof AEFluidKey) {
                        AEFluidKey fluidKey = (AEFluidKey)key;
                        v0 = AEUtil.toFluidStack(fluidKey, extracted);
                    } else {
                        v0 = resultStack = FluidStack.EMPTY;
                    }
                    if (action.execute()) {
                        this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - extracted);
                        if (this.stock.amount() == 0L) {
                            this.stock = null;
                        }
                        if (this.onContentsChanged != null) {
                            this.onContentsChanged.run();
                        }
                    }
                    return resultStack;
                }
            }
            return FluidStack.EMPTY;
        }
    }
}

