/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.MEPatternBufferProxyRecipeHandler;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MEPatternBufferProxyPartMachine
extends TieredIOPartMachine
implements IMachineLife,
IDataStickInteractable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEPatternBufferProxyPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    protected MEPatternBufferProxyRecipeHandler<Ingredient> itemProxyHandler = new MEPatternBufferProxyRecipeHandler<Ingredient>(this, IO.IN, ItemRecipeCapability.CAP);
    protected MEPatternBufferProxyRecipeHandler<FluidIngredient> fluidProxyHandler = new MEPatternBufferProxyRecipeHandler<FluidIngredient>(this, IO.IN, FluidRecipeCapability.CAP);
    @Persisted
    @DescSynced
    private BlockPos bufferPos;

    public MEPatternBufferProxyPartMachine(IMachineBlockEntity holder) {
        super(holder, 6, IO.IN);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7654_().m_6937_((Runnable)new TickTask(0, () -> this.setBuffer(this.bufferPos)));
        }
    }

    public boolean setBuffer(@Nullable BlockPos pos) {
        Level level = this.getLevel();
        if (pos == null || level == null) {
            return false;
        }
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), pos);
        if (metaMachine instanceof MEPatternBufferPartMachine) {
            MEPatternBufferPartMachine machine = (MEPatternBufferPartMachine)metaMachine;
            this.bufferPos = pos;
            ArrayList itemHandlers = new ArrayList();
            ArrayList fluidHandlers = new ArrayList();
            for (IRecipeHandlerTrait handler : machine.getRecipeHandlers()) {
                if (handler.isProxy()) continue;
                if (handler.getCapability() == ItemRecipeCapability.CAP) {
                    itemHandlers.add((NotifiableRecipeHandlerTrait)handler);
                    continue;
                }
                fluidHandlers.add((NotifiableRecipeHandlerTrait)handler);
            }
            this.itemProxyHandler.setHandlers(itemHandlers);
            this.fluidProxyHandler.setHandlers(fluidHandlers);
            machine.addProxy(this);
            return true;
        }
        return false;
    }

    @Nullable
    private MEPatternBufferPartMachine getBuffer() {
        Level level = this.getLevel();
        if (level == null || this.bufferPos == null) {
            return null;
        }
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, this.bufferPos);
        if (metaMachine instanceof MEPatternBufferPartMachine) {
            MEPatternBufferPartMachine buffer = (MEPatternBufferPartMachine)metaMachine;
            return buffer;
        }
        this.bufferPos = null;
        return null;
    }

    @Override
    public MetaMachine self() {
        MEPatternBufferPartMachine buffer = this.getBuffer();
        return buffer != null ? buffer.self() : super.self();
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        MEPatternBufferPartMachine buffer = this.getBuffer();
        return buffer != null;
    }

    @Override
    @Nullable
    public ModularUI createUI(Player entityPlayer) {
        GTCEu.LOGGER.warn("'createUI' of the Crafting Buffer Proxy was incorrectly called!");
        return null;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onMachineRemoved() {
        Level level = this.getLevel();
        if (level == null || this.bufferPos == null) {
            return;
        }
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), this.bufferPos);
        if (metaMachine instanceof MEPatternBufferPartMachine) {
            MEPatternBufferPartMachine machine = (MEPatternBufferPartMachine)metaMachine;
            machine.removeProxy(this);
        }
    }

    @Override
    public InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        if (dataStick.m_41782_() && dataStick.m_41784_().m_128425_("pos", 11)) {
            int[] posArray = dataStick.m_41784_().m_128465_("pos");
            BlockPos bufferPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            this.setBuffer(bufferPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public MEPatternBufferProxyRecipeHandler<Ingredient> getItemProxyHandler() {
        return this.itemProxyHandler;
    }

    public MEPatternBufferProxyRecipeHandler<FluidIngredient> getFluidProxyHandler() {
        return this.fluidProxyHandler;
    }

    public BlockPos getBufferPos() {
        return this.bufferPos;
    }
}

