/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GCYMRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GCYMMachines;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCYMRecipes {
    private GCYMRecipes() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        GCYMRecipes.registerManualRecipes(provider);
        GCYMRecipes.registerMachineRecipes(provider);
    }

    private static void registerManualRecipes(Consumer<FinishedRecipe> provider) {
        GCYMRecipes.registerPartsRecipes(provider);
        GCYMRecipes.registerMultiblockControllerRecipes(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("graphene_to_foil", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Graphene).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(TagPrefix.foil, GTMaterials.Graphene, 4).duration((int)GTMaterials.Graphene.getMass()).EUt(24L).save(provider);
    }

    private static void registerMultiblockControllerRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_macerator", GCYMMachines.LARGE_MACERATION_TOWER.asStack(), "PCP", "BXB", "MKM", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.TungstenCarbide), Character.valueOf('B'), GTItems.ELECTRIC_PISTON_IV.asStack(), Character.valueOf('M'), GTItems.ELECTRIC_MOTOR_IV.asStack(), Character.valueOf('X'), GTMachines.MACERATOR[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_arc_smelter", GCYMMachines.LARGE_ARC_SMELTER.asStack(), "KDK", "CXC", "PPP", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.TantalumCarbide), Character.valueOf('X'), GTMachines.ARC_FURNACE[5].asStack(), Character.valueOf('D'), new UnificationEntry(TagPrefix.dust, GTMaterials.Graphite), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_ore_washer", GCYMMachines.LARGE_CHEMICAL_BATH.asStack(), "PGP", "CXC", "MKM", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('G'), GTBlocks.CASING_TEMPERED_GLASS.asStack(), Character.valueOf('P'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('M'), GTItems.CONVEYOR_MODULE_IV.asStack(), Character.valueOf('X'), GTMachines.ORE_WASHER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_sifter", GCYMMachines.LARGE_SIFTING_FUNNEL.asStack(), "PCP", "EXE", "PKP", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.HSLASteel), Character.valueOf('E'), GTItems.ELECTRIC_PISTON_IV.asStack(), Character.valueOf('X'), GTMachines.SIFTER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_engraver", GCYMMachines.LARGE_ENGRAVING_LASER.asStack(), "ICI", "EXE", "PKP", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plateDouble, GTMaterials.TantalumCarbide), Character.valueOf('I'), GTItems.EMITTER_IV.asStack(), Character.valueOf('E'), GTItems.ELECTRIC_PISTON_IV.asStack(), Character.valueOf('X'), GTMachines.LASER_ENGRAVER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_packer", GCYMMachines.LARGE_PACKER.asStack(), "RCR", "PXP", "KPK", Character.valueOf('C'), CustomTags.EV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.HSLASteel), Character.valueOf('R'), GTItems.ROBOT_ARM_HV.asStack(), Character.valueOf('K'), GTItems.CONVEYOR_MODULE_HV.asStack(), Character.valueOf('X'), GTMachines.PACKER[3].asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_mixer", GCYMMachines.LARGE_MIXER.asStack(), "FCF", "RXR", "MKM", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('F'), ChemicalHelper.get(TagPrefix.pipeNormalFluid, GTMaterials.Polybenzimidazole), Character.valueOf('R'), ChemicalHelper.get(TagPrefix.rotor, GTMaterials.Osmiridium), Character.valueOf('M'), GTItems.ELECTRIC_MOTOR_IV.asStack(), Character.valueOf('X'), GTMachines.MIXER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_centrifuge", GCYMMachines.LARGE_CENTRIFUGE.asStack(), "SFS", "CXC", "MKM", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('F'), ChemicalHelper.get(TagPrefix.pipeHugeFluid, GTMaterials.StainlessSteel), Character.valueOf('S'), ChemicalHelper.get(TagPrefix.spring, GTMaterials.MolybdenumDisilicide), Character.valueOf('M'), GTItems.ELECTRIC_MOTOR_IV.asStack(), Character.valueOf('X'), GTMachines.CENTRIFUGE[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_assembler", GCYMMachines.LARGE_ASSEMBLER.asStack(), "RKR", "CXC", "MKM", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('R'), GTItems.ROBOT_ARM_IV.asStack(), Character.valueOf('M'), GTItems.CONVEYOR_MODULE_IV.asStack(), Character.valueOf('X'), GTMachines.ASSEMBLER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_circuit_assembler", GCYMMachines.LARGE_CIRCUIT_ASSEMBLER.asStack(), "RKR", "CXC", "MKM", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('R'), GTItems.ROBOT_ARM_IV.asStack(), Character.valueOf('M'), GTItems.CONVEYOR_MODULE_IV.asStack(), Character.valueOf('X'), GTMachines.CIRCUIT_ASSEMBLER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_electrolyzer", GCYMMachines.LARGE_ELECTROLYZER.asStack(), "PCP", "WXW", "PKP", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.BlackSteel), Character.valueOf('W'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum), Character.valueOf('X'), GTMachines.ELECTROLYZER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_electromagnet", GCYMMachines.LARGE_ELECTROMAGNET.asStack(), "PWP", "CXC", "PKP", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.BlueSteel), Character.valueOf('W'), new UnificationEntry(TagPrefix.wireGtQuadruple, GTMaterials.Osmium), Character.valueOf('X'), GTMachines.ELECTROMAGNETIC_SEPARATOR[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "blast_alloy_smelter", GCYMMachines.BLAST_ALLOY_SMELTER.asStack(), "TCT", "WXW", "TCT", Character.valueOf('C'), CustomTags.EV_CIRCUITS, Character.valueOf('T'), new UnificationEntry(TagPrefix.plate, GTMaterials.TantalumCarbide), Character.valueOf('W'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Aluminium), Character.valueOf('X'), GTMachines.ALLOY_SMELTER[4].asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, true, "mega_blast_furnace", GCYMMachines.MEGA_BLAST_FURNACE.asStack(), "PCP", "FSF", "DWD", Character.valueOf('C'), CustomTags.ZPM_CIRCUITS, Character.valueOf('S'), GTMultiMachines.ELECTRIC_BLAST_FURNACE.asStack(), Character.valueOf('F'), GTItems.FIELD_GENERATOR_ZPM.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.spring, GTMaterials.Naquadah), Character.valueOf('D'), new UnificationEntry(TagPrefix.plateDense, GTMaterials.NaquadahAlloy), Character.valueOf('W'), new UnificationEntry(TagPrefix.wireGtQuadruple, GTMaterials.RutheniumTriniumAmericiumNeutronate));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "mega_vacuum_freezer", GCYMMachines.MEGA_VACUUM_FREEZER.asStack(), "PCP", "FSF", "DWD", Character.valueOf('C'), CustomTags.ZPM_CIRCUITS, Character.valueOf('S'), GTMultiMachines.VACUUM_FREEZER.asStack(), Character.valueOf('F'), GTItems.FIELD_GENERATOR_ZPM.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.pipeNormalFluid, GTMaterials.NiobiumTitanium), Character.valueOf('D'), new UnificationEntry(TagPrefix.plateDense, GTMaterials.RhodiumPlatedPalladium), Character.valueOf('W'), new UnificationEntry(TagPrefix.wireGtQuadruple, GTMaterials.RutheniumTriniumAmericiumNeutronate));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_autoclave", GCYMMachines.LARGE_AUTOCLAVE.asStack(), "PCP", "PAP", "BKB", Character.valueOf('C'), CustomTags.IV_CIRCUITS, Character.valueOf('A'), GTMachines.AUTOCLAVE[5].asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plateDouble, GTMaterials.HSLASteel), Character.valueOf('B'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_material_press", GCYMMachines.LARGE_MATERIAL_PRESS.asStack(), "PKP", "BZG", "FKH", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('B'), GTMachines.BENDER[5].asStack(), Character.valueOf('P'), GTItems.ELECTRIC_PISTON_IV.asStack(), Character.valueOf('G'), GTMachines.COMPRESSOR[5].asStack(), Character.valueOf('F'), GTMachines.FORMING_PRESS[5].asStack(), Character.valueOf('H'), GTMachines.FORGE_HAMMER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_brewer", GCYMMachines.LARGE_BREWER.asStack(), "SZS", "FBH", "EKE", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('S'), new UnificationEntry(TagPrefix.spring, GTMaterials.MolybdenumDisilicide), Character.valueOf('F'), GTMachines.FERMENTER[5].asStack(), Character.valueOf('E'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('B'), GTMachines.BREWERY[5].asStack(), Character.valueOf('H'), GTMachines.FLUID_HEATER[5].asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_cutter", GCYMMachines.LARGE_CUTTER.asStack(), "SMS", "CZL", "EKE", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('L'), GTMachines.LATHE[5].asStack(), Character.valueOf('E'), GTItems.ELECTRIC_MOTOR_IV.asStack(), Character.valueOf('C'), GTMachines.CUTTER[5].asStack(), Character.valueOf('M'), GTItems.CONVEYOR_MODULE_IV.asStack(), Character.valueOf('S'), new UnificationEntry(TagPrefix.toolHeadBuzzSaw, GTMaterials.TungstenCarbide), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_distillery", GCYMMachines.LARGE_DISTILLERY.asStack(), "PZP", "EDE", "PZP", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('D'), GTMultiMachines.DISTILLATION_TOWER.asStack(), Character.valueOf('E'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('P'), ChemicalHelper.get(TagPrefix.pipeLargeFluid, GTMaterials.Iridium));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_extractor", GCYMMachines.LARGE_EXTRACTOR.asStack(), "PTP", "EZC", "BKB", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('B'), GTItems.ELECTRIC_PISTON_IV.asStack(), Character.valueOf('P'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('E'), GTMachines.EXTRACTOR[5].asStack(), Character.valueOf('C'), GTMachines.CANNER[5].asStack(), Character.valueOf('T'), GTBlocks.CASING_TEMPERED_GLASS.asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_extruder", GCYMMachines.LARGE_EXTRUDER.asStack(), "PZP", "SES", "PKP", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('E'), GTMachines.EXTRUDER[5].asStack(), Character.valueOf('P'), GTItems.ELECTRIC_PISTON_IV.asStack(), Character.valueOf('S'), new UnificationEntry(TagPrefix.spring, GTMaterials.MolybdenumDisilicide), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_solidifier", GCYMMachines.LARGE_SOLIDIFIER.asStack(), "PZP", "ESE", "PKP", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('S'), GTMachines.FLUID_SOLIDIFIER[5].asStack(), Character.valueOf('E'), GTItems.ELECTRIC_PUMP_IV.asStack(), Character.valueOf('P'), ChemicalHelper.get(TagPrefix.pipeNormalFluid, GTMaterials.Polyethylene), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, true, "large_wiremill", GCYMMachines.LARGE_WIREMILL.asStack(), "PZP", "SWS", "MKM", Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('W'), GTMachines.WIREMILL[5].asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.HSLASteel), Character.valueOf('S'), new UnificationEntry(TagPrefix.spring, GTMaterials.HSLASteel), Character.valueOf('M'), GTItems.ELECTRIC_MOTOR_IV.asStack(), Character.valueOf('K'), new UnificationEntry(TagPrefix.cableGtSingle, GTMaterials.Platinum));
    }

    private static void registerPartsRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "crushing_wheels", GCYMBlocks.CRUSHING_WHEELS.asStack(2), "TTT", "UCU", "UMU", Character.valueOf('T'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.TungstenCarbide), Character.valueOf('U'), ChemicalHelper.get(TagPrefix.gear, GTMaterials.Ultimet), Character.valueOf('C'), GCYMBlocks.CASING_SECURE_MACERATION.asStack(), Character.valueOf('M'), GTItems.ELECTRIC_MOTOR_IV.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "slicing_blades", GCYMBlocks.SLICING_BLADES.asStack(2), "PPP", "UCU", "UMU", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.TungstenCarbide), Character.valueOf('U'), ChemicalHelper.get(TagPrefix.gear, GTMaterials.Ultimet), Character.valueOf('C'), GCYMBlocks.CASING_SHOCK_PROOF.asStack(), Character.valueOf('M'), GTItems.ELECTRIC_MOTOR_IV.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "electrolytic_cell", GCYMBlocks.ELECTROLYTIC_CELL.asStack(2), "WWW", "WCW", "ZKZ", Character.valueOf('W'), new UnificationEntry(TagPrefix.wireGtDouble, GTMaterials.Platinum), Character.valueOf('Z'), CustomTags.IV_CIRCUITS, Character.valueOf('C'), GCYMBlocks.CASING_NONCONDUCTING.asStack(), Character.valueOf('K'), ChemicalHelper.get(TagPrefix.cableGtSingle, GTMaterials.Tungsten));
        VanillaRecipeHelper.addShapedRecipe(provider, "heat_vent", GCYMBlocks.HEAT_VENT.asStack(2), "PDP", "RLR", "PDP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.TantalumCarbide), Character.valueOf('D'), ChemicalHelper.get(TagPrefix.plateDouble, GTMaterials.MolybdenumDisilicide), Character.valueOf('R'), ChemicalHelper.get(TagPrefix.rotor, GTMaterials.Titanium), Character.valueOf('L'), ChemicalHelper.get(TagPrefix.rodLong, GTMaterials.MolybdenumDisilicide));
        VanillaRecipeHelper.addShapedRecipe(provider, "parallel_hatch_mk1", GCYMMachines.PARALLEL_HATCH[5].asStack(1), "SZE", "ZHZ", "CZC", Character.valueOf('S'), GTItems.SENSOR_IV.asStack(), Character.valueOf('E'), GTItems.EMITTER_IV.asStack(), Character.valueOf('Z'), CustomTags.LuV_CIRCUITS, Character.valueOf('H'), GTMachines.HULL[5].asStack(), Character.valueOf('C'), new UnificationEntry(TagPrefix.cableGtDouble, GTMaterials.Platinum));
        VanillaRecipeHelper.addShapedRecipe(provider, "parallel_hatch_mk2", GCYMMachines.PARALLEL_HATCH[6].asStack(1), "SZE", "ZHZ", "CZC", Character.valueOf('S'), GTItems.SENSOR_LuV.asStack(), Character.valueOf('E'), GTItems.EMITTER_LuV.asStack(), Character.valueOf('Z'), CustomTags.ZPM_CIRCUITS, Character.valueOf('H'), GTMachines.HULL[6].asStack(), Character.valueOf('C'), new UnificationEntry(TagPrefix.cableGtDouble, GTMaterials.NiobiumTitanium));
        VanillaRecipeHelper.addShapedRecipe(provider, "parallel_hatch_mk3", GCYMMachines.PARALLEL_HATCH[7].asStack(1), "SZE", "ZHZ", "CZC", Character.valueOf('S'), GTItems.SENSOR_ZPM.asStack(), Character.valueOf('E'), GTItems.EMITTER_ZPM.asStack(), Character.valueOf('Z'), CustomTags.UV_CIRCUITS, Character.valueOf('H'), GTMachines.HULL[7].asStack(), Character.valueOf('C'), new UnificationEntry(TagPrefix.cableGtDouble, GTMaterials.VanadiumGallium));
        VanillaRecipeHelper.addShapedRecipe(provider, "parallel_hatch_mk4", GCYMMachines.PARALLEL_HATCH[8].asStack(1), "SZE", "ZHZ", "CZC", Character.valueOf('S'), GTItems.SENSOR_UV.asStack(), Character.valueOf('E'), GTItems.EMITTER_UV.asStack(), Character.valueOf('Z'), CustomTags.UHV_CIRCUITS, Character.valueOf('H'), GTMachines.HULL[8].asStack(), Character.valueOf('C'), new UnificationEntry(TagPrefix.cableGtDouble, GTMaterials.YttriumBariumCuprate));
    }

    private static void registerMachineRecipes(Consumer<FinishedRecipe> provider) {
        GCYMRecipes.registerAssemblerRecipes(provider);
        GCYMRecipes.registerMixerRecipes(provider);
        GCYMRecipes.registerBlastAlloyRecipes(provider);
    }

    private static void registerAssemblerRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crushing_wheels", new Object[0]).inputItems(ChemicalHelper.get(TagPrefix.gearSmall, GTMaterials.TungstenCarbide, 2)).inputItems(ChemicalHelper.get(TagPrefix.gear, GTMaterials.Ultimet, 3)).inputItems(GCYMBlocks.CASING_SECURE_MACERATION.asStack()).inputItems(GTItems.ELECTRIC_MOTOR_IV.asStack()).outputItems(GCYMBlocks.CRUSHING_WHEELS.asStack(2)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("slicing_blades", new Object[0]).inputItems(ChemicalHelper.get(TagPrefix.plate, GTMaterials.TungstenCarbide, 2)).inputItems(ChemicalHelper.get(TagPrefix.gear, GTMaterials.Ultimet, 3)).inputItems(GCYMBlocks.CASING_SHOCK_PROOF.asStack()).inputItems(GTItems.ELECTRIC_MOTOR_IV.asStack()).outputItems(GCYMBlocks.SLICING_BLADES.asStack(2)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("electrolytic_cell", new Object[0]).inputItems(ChemicalHelper.get(TagPrefix.wireGtDouble, GTMaterials.Platinum, 4)).inputItems(ChemicalHelper.get(TagPrefix.cableGtSingle, GTMaterials.Tungsten, 1)).inputItems(GCYMBlocks.CASING_NONCONDUCTING.asStack()).inputItems(CustomTags.IV_CIRCUITS).outputItems(GCYMBlocks.ELECTROLYTIC_CELL.asStack(2)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mds_coil_block", new Object[0]).inputItems(ChemicalHelper.get(TagPrefix.ring, GTMaterials.MolybdenumDisilicide, 32)).inputItems(ChemicalHelper.get(TagPrefix.foil, GTMaterials.Graphene, 16)).inputFluids(GTMaterials.HSLASteel.getFluid(144)).outputItems(GCYMBlocks.MOLYBDENUM_DISILICIDE_COIL_BLOCK.asStack(1)).duration(500).EUt(1920L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heat_vent", new Object[0]).inputItems(ChemicalHelper.get(TagPrefix.plate, GTMaterials.TantalumCarbide, 3)).inputItems(ChemicalHelper.get(TagPrefix.plateDouble, GTMaterials.MolybdenumDisilicide, 2)).inputItems(ChemicalHelper.get(TagPrefix.rotor, GTMaterials.Titanium, 1)).inputItems(ChemicalHelper.get(TagPrefix.rodLong, GTMaterials.MolybdenumDisilicide, 1)).outputItems(GCYMBlocks.HEAT_VENT.asStack(2)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hsla_nonconducting", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.HSLASteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.HSLASteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_NONCONDUCTING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_incoloy_vibration_safe", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.IncoloyMA956, 6).inputItems(TagPrefix.frameGt, GTMaterials.IncoloyMA956).circuitMeta(6).outputItems(GCYMBlocks.CASING_VIBRATION_SAFE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).EUt(16L).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_watertight", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.WatertightSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.WatertightSteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_WATERTIGHT.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_secure_maceration", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Zeron100, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GCYMBlocks.CASING_SECURE_MACERATION.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).EUt(16L).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_high_temperature_smelting", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.TitaniumCarbide, 4).inputItems(TagPrefix.plate, GTMaterials.HSLASteel, 2).inputItems(TagPrefix.frameGt, GTMaterials.TungstenCarbide).circuitMeta(6).outputItems(GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_reaction_safe_mixing", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.HastelloyX, 6).inputItems(TagPrefix.frameGt, GTMaterials.MaragingSteel300).circuitMeta(6).outputItems(GCYMBlocks.CASING_REACTION_SAFE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_laser_safe_engraving", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.TitaniumTungstenCarbide, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GCYMBlocks.CASING_LASER_SAFE_ENGRAVING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_large_scale_assembling", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Stellite100, 6).inputItems(TagPrefix.frameGt, GTMaterials.Tungsten).circuitMeta(6).outputItems(GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_shock_proof", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.HastelloyC276, 6).inputItems(TagPrefix.frameGt, GTMaterials.HastelloyC276).circuitMeta(6).outputItems(GCYMBlocks.CASING_SHOCK_PROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_corrosion_proof", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.CobaltBrass, 6).inputItems(TagPrefix.frameGt, GTMaterials.HSLASteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_CORROSION_PROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stress_proof", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.MaragingSteel300, 6).inputItems(TagPrefix.frameGt, GTMaterials.StainlessSteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_STRESS_PROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save(provider);
    }

    private static void registerMixerRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("tantalum_carbide", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Tantalum).inputItems(TagPrefix.dust, GTMaterials.Carbon).outputItems(TagPrefix.dust, GTMaterials.TantalumCarbide, 2).duration(150).EUt(GTValues.VA[4]).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("hsla_steel", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Invar, 2).inputItems(TagPrefix.dust, GTMaterials.Vanadium).inputItems(TagPrefix.dust, GTMaterials.Titanium).inputItems(TagPrefix.dust, GTMaterials.Molybdenum).outputItems(TagPrefix.dust, GTMaterials.HSLASteel, 5).duration(140).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("molybdenum_disilicide", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Molybdenum).inputItems(TagPrefix.dust, GTMaterials.Silicon, 2).outputItems(TagPrefix.dust, GTMaterials.MolybdenumDisilicide, 3).duration(180).EUt(GTValues.VA[4]).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("titanium_carbide", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Titanium).inputItems(TagPrefix.dust, GTMaterials.Carbon).outputItems(TagPrefix.dust, GTMaterials.TitaniumCarbide, 2).duration(160).EUt(GTValues.VA[4]).save(provider);
    }

    private static void registerFormulaic(Consumer<FinishedRecipe> provider) {
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 3, GTMaterials.Tin, 1, GTMaterials.Bronze, 4, 400, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 3, GTMaterials.Zinc, 1, GTMaterials.Brass, 4, 400, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 1, GTMaterials.Nickel, 1, GTMaterials.Cupronickel, 2, 200, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 1, GTMaterials.Redstone, 4, GTMaterials.RedAlloy, 1, 100, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Iron, 1, GTMaterials.Tin, 1, GTMaterials.TinAlloy, 2, 100, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Iron, 2, GTMaterials.Nickel, 1, GTMaterials.Invar, 3, 300, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Lead, 4, GTMaterials.Antimony, 1, GTMaterials.BatteryAlloy, 5, 250, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Gold, 1, GTMaterials.Silver, 1, GTMaterials.Electrum, 2, 200, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Magnesium, 1, GTMaterials.Aluminium, 2, GTMaterials.Magnalium, 3, 150, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Silver, 1, GTMaterials.Electrotine, 4, GTMaterials.BlueAlloy, 1, 100, provider);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Glass, 7, GTMaterials.Boron, 1, GTMaterials.BorosilicateGlass, 8, 200, provider);
        GCYMRecipes.registerTrinaryAlloy(GTMaterials.Brass, 7, GTMaterials.Aluminium, 1, GTMaterials.Cobalt, 1, GTMaterials.CobaltBrass, 9, 900, provider);
        GCYMRecipes.registerTrinaryAlloy(GTMaterials.Tin, 6, GTMaterials.Lead, 3, GTMaterials.Antimony, 1, GTMaterials.SolderingAlloy, 10, 200, provider);
        GCYMRecipes.registerTrinaryAlloy(GTMaterials.Copper, 6, GTMaterials.Tin, 2, GTMaterials.Lead, 1, GTMaterials.Potin, 9, 400, provider);
    }

    private static void registerManual(Consumer<FinishedRecipe> provider) {
        GCYMRecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder("nickel_zinc_ferrite", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Nickel).inputItems(TagPrefix.dust, GTMaterials.Zinc).inputItems(TagPrefix.dust, GTMaterials.Iron, 4).circuitMeta(6).inputFluids(GTMaterials.Oxygen.getFluid(8000)).outputFluids(GTMaterials.NickelZincFerrite.getFluid(864)).duration(1800).EUt(GTValues.VA[2]).blastFurnaceTemp(1500).save(provider);
    }

    private static void registerBinaryAlloy(@NotNull Material input1, int input1Amount, @NotNull Material input2, int input2Amount, @NotNull Material output, int outputAmount, int duration, Consumer<FinishedRecipe> provider) {
        GCYMRecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder(output.getName(), new Object[0]).inputItems(TagPrefix.dust, input1, input1Amount).inputItems(TagPrefix.dust, input2, input2Amount).circuitMeta(input1Amount + input2Amount).outputFluids(output.getFluid(144 * outputAmount)).duration(duration * 3 / 4).EUt(16L).blastFurnaceTemp(output.getFluid().getFluidType().getTemperature()).save(provider);
    }

    private static void registerTrinaryAlloy(@NotNull Material input1, int input1Amount, @NotNull Material input2, int input2Amount, @NotNull Material input3, int input3Amount, @NotNull Material output, int outputAmount, int duration, Consumer<FinishedRecipe> provider) {
        GCYMRecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder(output.getName(), new Object[0]).inputItems(TagPrefix.dust, input1, input1Amount).inputItems(TagPrefix.dust, input2, input2Amount).inputItems(TagPrefix.dust, input3, input3Amount).circuitMeta(input1Amount + input2Amount + input3Amount).outputFluids(output.getFluid(144 * outputAmount)).duration(duration * 3 / 4).EUt(16L).blastFurnaceTemp(output.getFluid().getFluidType().getTemperature()).save(provider);
    }

    private static void registerBlastAlloyRecipes(Consumer<FinishedRecipe> provider) {
        GCYMRecipes.registerFormulaic(provider);
        GCYMRecipes.registerManual(provider);
        TagPrefix.ingot.executeHandler(provider, PropertyKey.ALLOY_BLAST, GCYMRecipes::generateAlloyBlastRecipes);
    }

    public static void generateAlloyBlastRecipes(@Nullable TagPrefix unused, @NotNull Material material, @NotNull AlloyBlastProperty property, @NotNull Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.BLAST)) {
            property.getRecipeProducer().produce(material, material.getProperty(PropertyKey.BLAST), provider);
        }
    }
}

