/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;

public class PolarizingRecipeHandler {
    private static final TagPrefix[] POLARIZING_PREFIXES = new TagPrefix[]{TagPrefix.rod, TagPrefix.rodLong, TagPrefix.plate, TagPrefix.ingot, TagPrefix.plateDense, TagPrefix.plateDouble, TagPrefix.rotor, TagPrefix.bolt, TagPrefix.screw, TagPrefix.wireFine, TagPrefix.foil, TagPrefix.ring, TagPrefix.dust, TagPrefix.nugget, TagPrefix.block, TagPrefix.dustTiny, TagPrefix.dustSmall};

    public static void init(Consumer<FinishedRecipe> provider) {
        for (TagPrefix orePrefix : POLARIZING_PREFIXES) {
            orePrefix.executeHandler(provider, PropertyKey.INGOT, PolarizingRecipeHandler::processPolarizing);
        }
    }

    public static void processPolarizing(TagPrefix polarizingPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        Material magneticMaterial = property.getMagneticMaterial();
        if (magneticMaterial != null && (polarizingPrefix.doGenerateBlock(magneticMaterial) || polarizingPrefix.doGenerateItem(magneticMaterial))) {
            ItemStack magneticStack = ChemicalHelper.get(polarizingPrefix, magneticMaterial);
            GTRecipeTypes.POLARIZER_RECIPES.recipeBuilder("polarize_" + material.getName() + "_" + polarizingPrefix.name, new Object[0]).inputItems(polarizingPrefix, material).outputItems(magneticStack).duration((int)((long)((int)material.getMass()) * polarizingPrefix.getMaterialAmount(material) / 3628800L)).EUt(PolarizingRecipeHandler.getVoltageMultiplier(material)).save(provider);
            VanillaRecipeHelper.addSmeltingRecipe(provider, "demagnetize_" + magneticMaterial.getName() + "_" + polarizingPrefix, ChemicalHelper.getTag(polarizingPrefix, magneticMaterial), ChemicalHelper.get(polarizingPrefix, material));
        }
    }

    private static int getVoltageMultiplier(Material material) {
        if (material == GTMaterials.Steel || material == GTMaterials.Iron) {
            return GTValues.VH[1];
        }
        if (material == GTMaterials.Neodymium) {
            return GTValues.VH[3];
        }
        if (material == GTMaterials.Samarium) {
            return GTValues.VH[5];
        }
        return material.getBlastTemperature() >= 1200 ? GTValues.VA[1] : 2;
    }
}

