/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.ResearchRecipeBuilder;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.recipe.condition.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.condition.EnvironmentalHazardCondition;
import com.gregtechceu.gtceu.common.recipe.condition.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.condition.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ThunderCondition;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GTRecipeBuilder {
    public final Map<RecipeCapability<?>, List<Content>> input = new IdentityHashMap();
    public final Map<RecipeCapability<?>, List<Content>> tickInput = new IdentityHashMap();
    public final Map<RecipeCapability<?>, List<Content>> output = new IdentityHashMap();
    public final Map<RecipeCapability<?>, List<Content>> tickOutput = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> inputChanceLogic = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> outputChanceLogic = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogic = new IdentityHashMap();
    public final Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogic = new IdentityHashMap();
    public final List<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
    @NotNull
    public CompoundTag data = new CompoundTag();
    public ResourceLocation id;
    public GTRecipeType recipeType;
    public int duration = 100;
    public boolean perTick;
    public String slotName;
    public String uiName;
    public int chance = ChanceLogic.getMaxChancedValue();
    public int maxChance = ChanceLogic.getMaxChancedValue();
    public int tierChanceBoost = 0;
    public boolean isFuel = false;
    public GTRecipeCategory recipeCategory;
    public BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onSave;
    private final Collection<ResearchRecipeEntry> researchRecipeEntries = new ArrayList<ResearchRecipeEntry>();
    private boolean generatingRecipes = true;

    public GTRecipeBuilder(ResourceLocation id, GTRecipeType recipeType) {
        this.id = id;
        this.recipeType = recipeType;
        this.recipeCategory = recipeType.getCategory();
    }

    public GTRecipeBuilder(GTRecipe toCopy, GTRecipeType recipeType) {
        this.id = toCopy.id;
        this.recipeType = recipeType;
        toCopy.inputs.forEach((k, v) -> this.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.outputs.forEach((k, v) -> this.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.tickInputs.forEach((k, v) -> this.tickInput.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.tickOutputs.forEach((k, v) -> this.tickOutput.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.inputChanceLogic.putAll(toCopy.inputChanceLogics);
        this.outputChanceLogic.putAll(toCopy.outputChanceLogics);
        this.tickInputChanceLogic.putAll(toCopy.tickInputChanceLogics);
        this.tickOutputChanceLogic.putAll(toCopy.tickOutputChanceLogics);
        this.conditions.addAll(toCopy.conditions);
        this.data = toCopy.data.m_6426_();
        this.duration = toCopy.duration;
        this.isFuel = toCopy.isFuel;
        this.recipeCategory = toCopy.recipeCategory;
    }

    public static GTRecipeBuilder of(ResourceLocation id, GTRecipeType recipeType) {
        return new GTRecipeBuilder(id, recipeType);
    }

    public static GTRecipeBuilder ofRaw() {
        return new GTRecipeBuilder(GTCEu.id("raw"), GTRecipeTypes.DUMMY_RECIPES);
    }

    public GTRecipeBuilder copy(String id) {
        return this.copy(GTCEu.id(id));
    }

    public GTRecipeBuilder copy(ResourceLocation id) {
        GTRecipeBuilder copy = new GTRecipeBuilder(id, this.recipeType);
        this.input.forEach((k, v) -> copy.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.output.forEach((k, v) -> copy.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.tickInput.forEach((k, v) -> copy.tickInput.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.tickOutput.forEach((k, v) -> copy.tickOutput.put((RecipeCapability<?>)k, new ArrayList(v)));
        copy.inputChanceLogic.putAll(this.inputChanceLogic);
        copy.outputChanceLogic.putAll(this.outputChanceLogic);
        copy.tickInputChanceLogic.putAll(this.tickInputChanceLogic);
        copy.tickOutputChanceLogic.putAll(this.tickOutputChanceLogic);
        copy.conditions.addAll(this.conditions);
        copy.data = this.data.m_6426_();
        copy.duration = this.duration;
        copy.chance = this.chance;
        copy.perTick = this.perTick;
        copy.isFuel = this.isFuel;
        copy.recipeCategory = this.recipeCategory;
        copy.uiName = this.uiName;
        copy.slotName = this.slotName;
        copy.onSave = this.onSave;
        return copy;
    }

    public GTRecipeBuilder copyFrom(GTRecipeBuilder builder) {
        return builder.copy(builder.id).onSave(null).recipeType(this.recipeType).category(this.recipeCategory);
    }

    public <T> GTRecipeBuilder input(RecipeCapability<T> capability, T obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickInput : this.input;
        if (t.get(capability) != null && t.get(capability).size() >= this.recipeType.getMaxInputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more inputs than RecipeType can support, id: {}, Max {}{}Inputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxInputs(capability)});
        }
        t.computeIfAbsent(capability, c -> new ArrayList()).add(new Content(capability.of(obj), this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName));
        return this;
    }

    public <T> GTRecipeBuilder input(RecipeCapability<T> capability, T ... obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickInput : this.input;
        if (t.get(capability) != null && t.get(capability).size() + obj.length > this.recipeType.getMaxInputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more inputs than RecipeType can support, id: {}, Max {}{}Inputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxInputs(capability)});
        }
        (this.perTick ? this.tickInput : this.input).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> GTRecipeBuilder output(RecipeCapability<T> capability, T obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickOutput : this.output;
        if (t.get(capability) != null && t.get(capability).size() >= this.recipeType.getMaxOutputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more outputs than RecipeType can support, id: {}, Max {}{}Outputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxOutputs(capability)});
        }
        (this.perTick ? this.tickOutput : this.output).computeIfAbsent(capability, c -> new ArrayList()).add(new Content(capability.of(obj), this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName));
        return this;
    }

    public <T> GTRecipeBuilder output(RecipeCapability<T> capability, T ... obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickOutput : this.output;
        if (t.get(capability) != null && t.get(capability).size() + obj.length > this.recipeType.getMaxOutputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more outputs than RecipeType can support, id: {}, Max {}{}Outputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxOutputs(capability)});
        }
        (this.perTick ? this.tickOutput : this.output).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> GTRecipeBuilder inputs(RecipeCapability<T> capability, Object obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickInput : this.input;
        if (t.get(capability) != null && t.get(capability).size() >= this.recipeType.getMaxInputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more inputs than RecipeType can support, id: {}, Max {}{}Inputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxInputs(capability)});
        }
        (this.perTick ? this.tickInput : this.input).computeIfAbsent(capability, c -> new ArrayList()).add(new Content(capability.of(obj), this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName));
        return this;
    }

    public <T> GTRecipeBuilder inputs(RecipeCapability<T> capability, Object ... obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickInput : this.input;
        if (t.get(capability) != null && t.get(capability).size() + obj.length > this.recipeType.getMaxInputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more inputs than RecipeType can support, id: {}, Max {}{}Inputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxInputs(capability)});
        }
        (this.perTick ? this.tickInput : this.input).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> GTRecipeBuilder outputs(RecipeCapability<T> capability, Object obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickOutput : this.output;
        if (t.get(capability) != null && t.get(capability).size() >= this.recipeType.getMaxOutputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more outputs than RecipeType can support, id: {}, Max {}{}Outputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxOutputs(capability)});
        }
        (this.perTick ? this.tickOutput : this.output).computeIfAbsent(capability, c -> new ArrayList()).add(new Content(capability.of(obj), this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName));
        return this;
    }

    public <T> GTRecipeBuilder outputs(RecipeCapability<T> capability, Object ... obj) {
        Map<RecipeCapability<?>, List<Content>> t;
        Map<RecipeCapability<?>, List<Content>> map = t = this.perTick ? this.tickOutput : this.output;
        if (t.get(capability) != null && t.get(capability).size() + obj.length > this.recipeType.getMaxOutputs(capability)) {
            GTCEu.LOGGER.warn("Trying to add more outputs than RecipeType can support, id: {}, Max {}{}Outputs: {}", new Object[]{this.id, this.perTick ? "Tick " : "", capability.name, this.recipeType.getMaxOutputs(capability)});
        }
        (this.perTick ? this.tickOutput : this.output).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public GTRecipeBuilder addCondition(RecipeCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public GTRecipeBuilder inputEU(long eu) {
        return this.input((RecipeCapability<T>)EURecipeCapability.CAP, (T)eu);
    }

    public GTRecipeBuilder EUt(long eu) {
        if (eu == 0L) {
            GTCEu.LOGGER.error("EUt can't be explicitly set to 0, id: {}", (Object)this.id);
        }
        boolean lastPerTick = this.perTick;
        this.perTick = true;
        if (eu > 0L) {
            this.tickInput.remove(EURecipeCapability.CAP);
            this.inputEU(eu);
        } else if (eu < 0L) {
            this.tickOutput.remove(EURecipeCapability.CAP);
            this.outputEU(-eu);
        }
        this.perTick = lastPerTick;
        return this;
    }

    public GTRecipeBuilder outputEU(long eu) {
        return this.output((RecipeCapability<T>)EURecipeCapability.CAP, (T)eu);
    }

    public GTRecipeBuilder inputCWU(int cwu) {
        return this.input((RecipeCapability<T>)CWURecipeCapability.CAP, (T)cwu);
    }

    public GTRecipeBuilder CWUt(int cwu) {
        if (cwu == 0) {
            GTCEu.LOGGER.error("CWUt can't be explicitly set to 0, id: {}", (Object)this.id);
        }
        boolean lastPerTick = this.perTick;
        this.perTick = true;
        if (cwu > 0) {
            this.tickInput.remove(CWURecipeCapability.CAP);
            this.inputCWU(cwu);
        } else if (cwu < 0) {
            this.tickOutput.remove(CWURecipeCapability.CAP);
            this.outputCWU(cwu);
        }
        this.perTick = lastPerTick;
        return this;
    }

    public GTRecipeBuilder totalCWU(int cwu) {
        this.durationIsTotalCWU(true);
        this.hideDuration(true);
        this.duration(cwu);
        return this;
    }

    public GTRecipeBuilder outputCWU(int cwu) {
        return this.output((RecipeCapability<T>)CWURecipeCapability.CAP, (T)cwu);
    }

    public GTRecipeBuilder inputItems(Object input) {
        Supplier supplier;
        Object t;
        if (input instanceof Item) {
            Item item = (Item)input;
            return this.inputItems(item);
        }
        if (input instanceof Supplier && (t = (supplier = (Supplier)input).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.inputItems(item.m_5456_());
        }
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            return this.inputItems(stack);
        }
        if (input instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)input;
            return this.inputItems(ingredient);
        }
        if (input instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)input;
            return this.inputItems(entry);
        }
        if (input instanceof TagKey) {
            TagKey tag = (TagKey)input;
            return this.inputItems((TagKey<Item>)tag);
        }
        if (input instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)input;
            return this.inputItems(machine);
        }
        GTCEu.LOGGER.error("Input item is not one of: Item, Supplier<Item>, ItemStack, Ingredient, UnificationEntry, TagKey<Item>, MachineDefinition, id: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder inputItems(Object input, int count) {
        Supplier supplier;
        Object t;
        if (input instanceof Item) {
            Item item = (Item)input;
            return this.inputItems(item, count);
        }
        if (input instanceof Supplier && (t = (supplier = (Supplier)input).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.inputItems(item.m_5456_(), count);
        }
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            return this.inputItems(stack.m_255036_(count));
        }
        if (input instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)input;
            return this.inputItems((Object)ingredient, count);
        }
        if (input instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)input;
            return this.inputItems(entry, count);
        }
        if (input instanceof TagKey) {
            TagKey tag = (TagKey)input;
            return this.inputItems((TagKey<Item>)tag, count);
        }
        if (input instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)input;
            return this.inputItems(machine, count);
        }
        GTCEu.LOGGER.error("Input item is not one of: Item, Supplier<Item>, ItemStack, Ingredient, UnificationEntry, TagKey<Item>, MachineDefinition, id: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder inputItems(Ingredient inputs) {
        return this.input((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)inputs);
    }

    public GTRecipeBuilder inputItems(Ingredient ... inputs) {
        return this.input((RecipeCapability)ItemRecipeCapability.CAP, (T[])inputs);
    }

    public GTRecipeBuilder inputItems(ItemStack input) {
        if (input.m_41619_()) {
            GTCEu.LOGGER.error("Input items is empty, id: {}", (Object)this.id);
        }
        return this.input((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)((Object)SizedIngredient.create(input)));
    }

    public GTRecipeBuilder inputItems(ItemStack ... inputs) {
        for (ItemStack itemStack : inputs) {
            if (!itemStack.m_41619_()) continue;
            GTCEu.LOGGER.error("Input item is empty, id: {}", (Object)this.id);
        }
        return this.input((RecipeCapability)ItemRecipeCapability.CAP, (T[])((Ingredient[])Arrays.stream(inputs).map(SizedIngredient::create).toArray(Ingredient[]::new)));
    }

    public GTRecipeBuilder inputItems(TagKey<Item> tag, int amount) {
        if (amount == 0) {
            GTCEu.LOGGER.error("Item Count is 0, id: {}", (Object)this.id);
        }
        return this.inputItems((Ingredient)SizedIngredient.create(tag, amount));
    }

    public GTRecipeBuilder inputItems(TagKey<Item> tag) {
        return this.inputItems(tag, 1);
    }

    public GTRecipeBuilder inputItems(Item input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input, amount));
    }

    public GTRecipeBuilder inputItems(Item input) {
        return this.inputItems((Ingredient)SizedIngredient.create(new ItemStack((ItemLike)input)));
    }

    public GTRecipeBuilder inputItems(Supplier<? extends Item> input) {
        return this.inputItems(input.get());
    }

    public GTRecipeBuilder inputItems(Supplier<? extends Item> input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input.get(), amount));
    }

    public GTRecipeBuilder inputItems(TagPrefix orePrefix, Material material) {
        return this.inputItems(orePrefix, material, 1);
    }

    public GTRecipeBuilder inputItems(UnificationEntry input) {
        if (input.material == null) {
            GTCEu.LOGGER.error("Unification Entry material is null, id: {}, TagPrefix: {}", (Object)this.id, (Object)input.tagPrefix);
        }
        return this.inputItems(input.tagPrefix, input.material, 1);
    }

    public GTRecipeBuilder inputItems(UnificationEntry input, int count) {
        if (input.material == null) {
            GTCEu.LOGGER.error("Unification Entry material is null, id: {}, TagPrefix: {}", (Object)this.id, (Object)input.tagPrefix);
        }
        return this.inputItems(input.tagPrefix, input.material, count);
    }

    public GTRecipeBuilder inputItems(TagPrefix orePrefix, Material material, int count) {
        TagKey<Item> tag = ChemicalHelper.getTag(orePrefix, material);
        if (tag == null) {
            ItemStack item = ChemicalHelper.get(orePrefix, material, count);
            if (item.m_41619_()) {
                GTCEu.LOGGER.error("Tried to set input item stack that doesn't exist, id: {}, TagPrefix: {}, Material: {}, Count: {}", new Object[]{this.id, orePrefix, material, count});
            }
            return this.inputItems(item);
        }
        return this.inputItems(tag, count);
    }

    public GTRecipeBuilder inputItems(MachineDefinition machine) {
        return this.inputItems(machine, 1);
    }

    public GTRecipeBuilder inputItems(MachineDefinition machine, int count) {
        return this.inputItems(machine.asStack(count));
    }

    public GTRecipeBuilder outputItems(Object input) {
        Supplier supplier;
        Object t;
        if (input instanceof Item) {
            Item item = (Item)input;
            return this.outputItems(item);
        }
        if (input instanceof Supplier && (t = (supplier = (Supplier)input).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.outputItems(item.m_5456_());
        }
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            return this.outputItems(stack);
        }
        if (input instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)input;
            return this.outputItems(entry);
        }
        if (input instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)input;
            return this.outputItems(machine);
        }
        GTCEu.LOGGER.error("Output item is not one of: Item, Supplier<Item>, ItemStack, Ingredient, UnificationEntry, TagKey<Item>, MachineDefinition, id: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder outputItems(Object input, int count) {
        Supplier supplier;
        Object t;
        if (input instanceof Item) {
            Item item = (Item)input;
            return this.outputItems(item, count);
        }
        if (input instanceof Supplier && (t = (supplier = (Supplier)input).get()) instanceof ItemLike) {
            ItemLike item = (ItemLike)t;
            return this.outputItems(item.m_5456_(), count);
        }
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            return this.outputItems(stack.m_255036_(count));
        }
        if (input instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)input;
            return this.outputItems(entry, count);
        }
        if (input instanceof MachineDefinition) {
            MachineDefinition machine = (MachineDefinition)input;
            return this.outputItems(machine, count);
        }
        GTCEu.LOGGER.error("Output item is not one of: Item, Supplier<Item>, ItemStack, Ingredient, UnificationEntry, TagKey<Item>, MachineDefinition, id: {}", (Object)this.id);
        return this;
    }

    public GTRecipeBuilder outputItems(Ingredient ... inputs) {
        return this.output((RecipeCapability)ItemRecipeCapability.CAP, (T[])inputs);
    }

    public GTRecipeBuilder outputItems(ItemStack output) {
        if (output.m_41619_()) {
            GTCEu.LOGGER.error("Output items is empty, id: {}", (Object)this.id);
        }
        return this.output((RecipeCapability<T>)ItemRecipeCapability.CAP, (T)((Object)SizedIngredient.create(output)));
    }

    public GTRecipeBuilder outputItems(ItemStack ... outputs) {
        for (ItemStack itemStack : outputs) {
            if (!itemStack.m_41619_()) continue;
            GTCEu.LOGGER.error("Output items is empty, id: {}", (Object)this.id);
        }
        return this.output((RecipeCapability)ItemRecipeCapability.CAP, (T[])((Ingredient[])Arrays.stream(outputs).map(SizedIngredient::create).toArray(Ingredient[]::new)));
    }

    public GTRecipeBuilder outputItems(Item output, int amount) {
        return this.outputItems(new ItemStack((ItemLike)output, amount));
    }

    public GTRecipeBuilder outputItems(Item output) {
        return this.outputItems(new ItemStack((ItemLike)output));
    }

    public GTRecipeBuilder outputItems(Supplier<? extends ItemLike> input) {
        return this.outputItems(new ItemStack((ItemLike)input.get().m_5456_()));
    }

    public GTRecipeBuilder outputItems(Supplier<? extends ItemLike> input, int amount) {
        return this.outputItems(new ItemStack((ItemLike)input.get().m_5456_(), amount));
    }

    public GTRecipeBuilder outputItems(TagPrefix orePrefix, Material material) {
        return this.outputItems(orePrefix, material, 1);
    }

    public GTRecipeBuilder outputItems(TagPrefix orePrefix, Material material, int count) {
        ItemStack item = ChemicalHelper.get(orePrefix, material, count);
        if (item.m_41619_()) {
            GTCEu.LOGGER.error("Tried to set output item stack that doesn't exist, TagPrefix: {}, Material: {}", (Object)orePrefix, (Object)material);
        }
        return this.outputItems(item);
    }

    public GTRecipeBuilder outputItems(UnificationEntry entry) {
        if (entry.material == null) {
            GTCEu.LOGGER.error("Unification Entry material is null, id: {}, TagPrefix: {}", (Object)this.id, (Object)entry.tagPrefix);
        }
        return this.outputItems(entry.tagPrefix, entry.material);
    }

    public GTRecipeBuilder outputItems(UnificationEntry entry, int count) {
        if (entry.material == null) {
            GTCEu.LOGGER.error("Unification Entry material is null, id: {}, TagPrefix: {}", (Object)this.id, (Object)entry.tagPrefix);
        }
        return this.outputItems(entry.tagPrefix, entry.material, count);
    }

    public GTRecipeBuilder outputItems(MachineDefinition machine) {
        return this.outputItems(machine, 1);
    }

    public GTRecipeBuilder outputItems(MachineDefinition machine, int count) {
        return this.outputItems(machine.asStack(count));
    }

    public GTRecipeBuilder outputItemsRanged(ItemStack output, IntProvider intProvider) {
        return this.outputItems((Object)IntProviderIngredient.create(SizedIngredient.create(output), intProvider));
    }

    public GTRecipeBuilder outputItemsRanged(Item input, IntProvider intProvider) {
        return this.outputItemsRanged(new ItemStack((ItemLike)input), intProvider);
    }

    public GTRecipeBuilder outputItemsRanged(Supplier<? extends ItemLike> output, IntProvider intProvider) {
        return this.outputItemsRanged(new ItemStack((ItemLike)output.get().m_5456_()), intProvider);
    }

    public GTRecipeBuilder outputItemsRanged(TagPrefix orePrefix, Material material, IntProvider intProvider) {
        ItemStack item = ChemicalHelper.get(orePrefix, material, 1);
        if (item.m_41619_()) {
            GTCEu.LOGGER.error("Tried to set output ranged item stack that doesn't exist, TagPrefix: {}, Material: {}", (Object)orePrefix, (Object)material);
        }
        return this.outputItemsRanged(item, intProvider);
    }

    public GTRecipeBuilder outputItemsRanged(MachineDefinition machine, IntProvider intProvider) {
        return this.outputItemsRanged(machine.asStack(), intProvider);
    }

    public GTRecipeBuilder notConsumable(ItemStack itemStack) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(itemStack);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Ingredient ingredient) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(ingredient);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Item item) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Supplier<? extends Item> item) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(TagPrefix orePrefix, Material material) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(orePrefix, material);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(TagPrefix orePrefix, Material material, int count) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputItems(orePrefix, material, count);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumableFluid(FluidStack fluid) {
        return this.notConsumableFluid(FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).m_135815_()), fluid.getAmount()));
    }

    public GTRecipeBuilder notConsumableFluid(FluidIngredient ingredient) {
        int lastChance = this.chance;
        this.chance = 0;
        this.inputFluids(ingredient);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder circuitMeta(int configuration) {
        if (configuration < 0 || configuration > 32) {
            GTCEu.LOGGER.error("Circuit configuration must be in the bounds 0 - 32");
        }
        return this.notConsumable((Ingredient)IntCircuitIngredient.circuitInput(configuration));
    }

    public GTRecipeBuilder chancedInput(ItemStack stack, int chance, int tierChanceBoost) {
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.inputItems(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedInput(FluidStack stack, int chance, int tierChanceBoost) {
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.inputFluids(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(ItemStack stack, int chance, int tierChanceBoost) {
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.outputItems(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(FluidStack stack, int chance, int tierChanceBoost) {
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
            return this;
        }
        int lastChance = this.chance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.outputFluids(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(TagPrefix tag, Material mat, int chance, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(tag, mat), chance, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(TagPrefix tag, Material mat, int count, int chance, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(tag, mat, count), chance, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(ItemStack stack, String fraction, int tierChanceBoost) {
        int maxChance;
        int chance;
        if (stack.m_41619_()) {
            return this;
        }
        String[] split = fraction.split("/");
        if (split.length != 2) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        try {
            chance = Integer.parseInt(split[0]);
            maxChance = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
            return this;
        }
        if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Max Chance cannot be less or equal to Chance or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), maxChance, new Throwable()});
            return this;
        }
        int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
        int lastChance = this.chance;
        int lastMaxChance = this.maxChance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance *= scalar;
        this.maxChance = maxChance *= scalar;
        this.tierChanceBoost = tierChanceBoost;
        this.outputItems(stack);
        this.chance = lastChance;
        this.maxChance = lastMaxChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(TagPrefix prefix, Material material, int count, String fraction, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(prefix, material, count), fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(TagPrefix prefix, Material material, String fraction, int tierChanceBoost) {
        return this.chancedOutput(prefix, material, 1, fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(Item item, int count, String fraction, int tierChanceBoost) {
        return this.chancedOutput(new ItemStack((ItemLike)item, count), fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(Item item, String fraction, int tierChanceBoost) {
        return this.chancedOutput(item, 1, fraction, tierChanceBoost);
    }

    public GTRecipeBuilder chancedFluidOutput(FluidStack stack, String fraction, int tierChanceBoost) {
        int maxChance;
        int chance;
        if (stack.isEmpty()) {
            return this;
        }
        String[] split = fraction.split("/");
        if (split.length != 2) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        try {
            chance = Integer.parseInt(split[0]);
            maxChance = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            GTCEu.LOGGER.error("Fraction was not parsed correctly! Expected format is \"1/3\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
            return this;
        }
        if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
            return this;
        }
        if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
            GTCEu.LOGGER.error("Max Chance cannot be less or equal to Chance or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), maxChance, new Throwable()});
            return this;
        }
        int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
        int lastChance = this.chance;
        int lastMaxChance = this.maxChance;
        int lastTierChanceBoost = this.tierChanceBoost;
        this.chance = chance *= scalar;
        this.maxChance = maxChance *= scalar;
        this.tierChanceBoost = tierChanceBoost;
        this.outputFluids(stack);
        this.chance = lastChance;
        this.maxChance = lastMaxChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.outputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder chancedItemOutputLogic(ChanceLogic logic) {
        return this.chancedOutputLogic(ItemRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedFluidOutputLogic(ChanceLogic logic) {
        return this.chancedOutputLogic(FluidRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.inputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder chancedItemInputLogic(ChanceLogic logic) {
        return this.chancedInputLogic(ItemRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedFluidInputLogic(ChanceLogic logic) {
        return this.chancedInputLogic(FluidRecipeCapability.CAP, logic);
    }

    public GTRecipeBuilder chancedTickOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.tickOutputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder chancedTickInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
        this.tickInputChanceLogic.put(cap, logic);
        return this;
    }

    public GTRecipeBuilder inputFluids(FluidStack input) {
        return this.input((RecipeCapability<T>)FluidRecipeCapability.CAP, (T)FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)input.getFluid()).m_135815_()), input.getAmount(), input.getTag()));
    }

    public GTRecipeBuilder inputFluids(FluidStack ... inputs) {
        return this.input((RecipeCapability)FluidRecipeCapability.CAP, (T[])((FluidIngredient[])Arrays.stream(inputs).map(fluid -> FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).m_135815_()), fluid.getAmount(), fluid.getTag())).toArray(FluidIngredient[]::new)));
    }

    public GTRecipeBuilder inputFluids(FluidIngredient ... inputs) {
        return this.input((RecipeCapability)FluidRecipeCapability.CAP, (T[])inputs);
    }

    public GTRecipeBuilder outputFluids(FluidStack output) {
        return this.output((RecipeCapability<T>)FluidRecipeCapability.CAP, (T)FluidIngredient.of(output));
    }

    public GTRecipeBuilder outputFluids(FluidStack ... outputs) {
        return this.output((RecipeCapability)FluidRecipeCapability.CAP, (T[])((FluidIngredient[])Arrays.stream(outputs).map(xva$0 -> FluidIngredient.of(xva$0)).toArray(FluidIngredient[]::new)));
    }

    public GTRecipeBuilder outputFluids(FluidIngredient ... outputs) {
        return this.output((RecipeCapability)FluidRecipeCapability.CAP, (T[])outputs);
    }

    public GTRecipeBuilder addData(String key, Tag data) {
        this.data.m_128365_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, int data) {
        this.data.m_128405_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, long data) {
        this.data.m_128356_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, String data) {
        this.data.m_128359_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, Float data) {
        this.data.m_128350_(key, data.floatValue());
        return this;
    }

    public GTRecipeBuilder addData(String key, boolean data) {
        this.data.m_128379_(key, data);
        return this;
    }

    public GTRecipeBuilder blastFurnaceTemp(int blastTemp) {
        return this.addData("ebf_temp", blastTemp);
    }

    public GTRecipeBuilder explosivesAmount(int explosivesAmount) {
        return this.inputItems(new ItemStack((ItemLike)Blocks.f_50077_, explosivesAmount));
    }

    public GTRecipeBuilder explosivesType(ItemStack explosivesType) {
        return this.inputItems(explosivesType);
    }

    public GTRecipeBuilder solderMultiplier(int multiplier) {
        return this.addData("solder_multiplier", multiplier);
    }

    public GTRecipeBuilder disableDistilleryRecipes(boolean flag) {
        return this.addData("disable_distillery", flag);
    }

    public GTRecipeBuilder fusionStartEU(long eu) {
        return this.addData("eu_to_start", eu);
    }

    public GTRecipeBuilder researchScan(boolean isScan) {
        return this.addData("scan_for_research", isScan);
    }

    public GTRecipeBuilder durationIsTotalCWU(boolean durationIsTotalCWU) {
        return this.addData("duration_is_total_cwu", durationIsTotalCWU);
    }

    public GTRecipeBuilder hideDuration(boolean hideDuration) {
        return this.addData("hide_duration", hideDuration);
    }

    public GTRecipeBuilder cleanroom(CleanroomType cleanroomType) {
        return this.addCondition(new CleanroomCondition(cleanroomType));
    }

    public GTRecipeBuilder dimension(ResourceLocation dimension, boolean reverse) {
        return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
    }

    public GTRecipeBuilder dimension(ResourceLocation dimension) {
        return this.dimension(dimension, false);
    }

    public GTRecipeBuilder biome(ResourceLocation biome, boolean reverse) {
        return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
    }

    public GTRecipeBuilder biome(ResourceLocation biome) {
        return this.biome(biome, false);
    }

    public GTRecipeBuilder rain(float level, boolean reverse) {
        return this.addCondition(new RainingCondition(level).setReverse(reverse));
    }

    public GTRecipeBuilder rain(float level) {
        return this.rain(level, false);
    }

    public GTRecipeBuilder thunder(float level, boolean reverse) {
        return this.addCondition(new ThunderCondition(level).setReverse(reverse));
    }

    public GTRecipeBuilder thunder(float level) {
        return this.thunder(level, false);
    }

    public GTRecipeBuilder posY(int min, int max, boolean reverse) {
        return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
    }

    public GTRecipeBuilder posY(int min, int max) {
        return this.posY(min, max, false);
    }

    public GTRecipeBuilder environmentalHazard(MedicalCondition condition, boolean reverse) {
        return this.addCondition(new EnvironmentalHazardCondition(condition).setReverse(reverse));
    }

    public GTRecipeBuilder environmentalHazard(MedicalCondition condition) {
        return this.environmentalHazard(condition, false);
    }

    private boolean applyResearchProperty(ResearchData.ResearchEntry researchEntry) {
        if (!ConfigHolder.INSTANCE.machines.enableResearch) {
            return false;
        }
        if (researchEntry == null) {
            GTCEu.LOGGER.error("Research Entry cannot be empty.", (Throwable)new IllegalArgumentException());
            return false;
        }
        if (!this.generatingRecipes) {
            GTCEu.LOGGER.error("Cannot generate recipes when using researchWithoutRecipe()", (Throwable)new IllegalArgumentException());
            return false;
        }
        ResearchCondition condition = this.conditions.stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
        if (condition != null) {
            condition.data.add(researchEntry);
        } else {
            condition = new ResearchCondition();
            condition.data.add(researchEntry);
            this.addCondition(condition);
        }
        return true;
    }

    public GTRecipeBuilder researchWithoutRecipe(@NotNull String researchId) {
        return this.researchWithoutRecipe(researchId, ResearchManager.getDefaultScannerItem());
    }

    public GTRecipeBuilder researchWithoutRecipe(@NotNull String researchId, @NotNull ItemStack dataStack) {
        this.applyResearchProperty(new ResearchData.ResearchEntry(researchId, dataStack));
        this.generatingRecipes = false;
        return this;
    }

    public GTRecipeBuilder scannerResearch(UnaryOperator<ResearchRecipeBuilder.ScannerRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.ScannerRecipeBuilder)research.apply(new ResearchRecipeBuilder.ScannerRecipeBuilder())).build();
        if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.researchRecipeEntries.add(entry);
        }
        return this;
    }

    public GTRecipeBuilder scannerResearch(@NotNull ItemStack researchStack) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(researchStack));
    }

    public GTRecipeBuilder stationResearch(UnaryOperator<ResearchRecipeBuilder.StationRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.StationRecipeBuilder)research.apply(new ResearchRecipeBuilder.StationRecipeBuilder())).build();
        if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.researchRecipeEntries.add(entry);
        }
        return this;
    }

    public GTRecipeBuilder category(@NotNull GTRecipeCategory category) {
        this.recipeCategory = category;
        return this;
    }

    public void toJson(JsonObject json) {
        json.addProperty("type", this.recipeType.registryName.toString());
        json.addProperty("duration", (Number)Math.abs(this.duration));
        if (this.data != null && !this.data.m_128456_()) {
            json.add("data", NBTToJsonConverter.getObject((Tag)this.data));
        }
        json.add("inputs", (JsonElement)this.capabilitiesToJson(this.input));
        json.add("outputs", (JsonElement)this.capabilitiesToJson(this.output));
        json.add("tickInputs", (JsonElement)this.capabilitiesToJson(this.tickInput));
        json.add("tickOutputs", (JsonElement)this.capabilitiesToJson(this.tickOutput));
        json.add("inputChanceLogics", (JsonElement)this.chanceLogicsToJson(this.inputChanceLogic));
        json.add("outputChanceLogics", (JsonElement)this.chanceLogicsToJson(this.outputChanceLogic));
        json.add("tickInputChanceLogics", (JsonElement)this.chanceLogicsToJson(this.tickInputChanceLogic));
        json.add("tickOutputChanceLogics", (JsonElement)this.chanceLogicsToJson(this.tickOutputChanceLogic));
        json.addProperty("category", this.recipeCategory.registryKey.toString());
        if (!this.conditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (RecipeCondition condition : this.conditions) {
                JsonObject condJson = condition.serialize();
                condJson.addProperty("type", (String)GTRegistries.RECIPE_CONDITIONS.getKey(condition.getType()));
                array.add((JsonElement)condJson);
            }
            json.add("recipeConditions", (JsonElement)array);
        }
        if (this.isFuel) {
            json.addProperty("isFuel", Boolean.valueOf(true));
        }
    }

    public JsonObject capabilitiesToJson(Map<RecipeCapability<?>, List<Content>> contents) {
        JsonObject jsonObject = new JsonObject();
        contents.forEach((cap, list) -> {
            JsonArray contentsJson = new JsonArray();
            for (Content content : list) {
                contentsJson.add(cap.serializer.toJsonContent(content));
            }
            jsonObject.add((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap), (JsonElement)contentsJson);
        });
        return jsonObject;
    }

    public JsonObject chanceLogicsToJson(Map<RecipeCapability<?>, ChanceLogic> chanceLogics) {
        JsonObject jsonObject = new JsonObject();
        chanceLogics.forEach((cap, logic) -> {
            String capId = (String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap);
            String logicId = (String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic);
            jsonObject.addProperty(capId, logicId);
        });
        return jsonObject;
    }

    public FinishedRecipe build() {
        return new FinishedRecipe(){

            public void m_7917_(JsonObject pJson) {
                GTRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation m_6445_() {
                return new ResourceLocation(GTRecipeBuilder.this.id.m_135827_(), GTRecipeBuilder.this.recipeType.registryName.m_135815_() + "/" + GTRecipeBuilder.this.id.m_135815_());
            }

            public RecipeSerializer<?> m_6637_() {
                return GTRecipeSerializer.SERIALIZER;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        };
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        if (this.onSave != null) {
            this.onSave.accept(this, consumer);
        }
        ResearchCondition condition = this.conditions.stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
        if (condition != null) {
            for (ResearchData.ResearchEntry entry : condition.data) {
                this.recipeType.addDataStickEntry(entry.getResearchId(), this.buildRawRecipe());
            }
        }
        if (this.recipeType != null) {
            if (this.recipeCategory == null) {
                GTCEu.LOGGER.error("Recipes must have a category", (Throwable)new IllegalArgumentException());
            } else if (this.recipeCategory != GTRecipeCategory.DEFAULT && this.recipeCategory.getRecipeType() != this.recipeType) {
                GTCEu.LOGGER.error("Cannot apply Category with incompatible RecipeType", (Throwable)new IllegalArgumentException());
            }
        }
        consumer.accept(this.build());
    }

    public GTRecipe buildRawRecipe() {
        GTRecipe recipe = new GTRecipe(this.recipeType, this.id.m_246208_(this.recipeType.registryName.m_135815_() + "/"), this.input, this.output, this.tickInput, this.tickOutput, this.inputChanceLogic, this.outputChanceLogic, this.tickInputChanceLogic, this.tickOutputChanceLogic, this.conditions, List.of(), this.data, this.duration, this.isFuel, this.recipeCategory);
        return recipe;
    }

    public long EUt() {
        if (!this.tickInput.containsKey(EURecipeCapability.CAP)) {
            return 0L;
        }
        if (this.tickInput.get(EURecipeCapability.CAP).isEmpty()) {
            return 0L;
        }
        return (Long)EURecipeCapability.CAP.of(this.tickInput.get((Object)EURecipeCapability.CAP).get((int)0).content);
    }

    public int getSolderMultiplier() {
        if (this.data.m_128441_("solderMultiplier")) {
            return Math.max(1, this.data.m_128451_("solderMultiplier"));
        }
        return Math.max(1, this.data.m_128451_("solder_multiplier"));
    }

    public GTRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public GTRecipeBuilder recipeType(GTRecipeType recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    public GTRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public GTRecipeBuilder perTick(boolean perTick) {
        this.perTick = perTick;
        return this;
    }

    public GTRecipeBuilder slotName(String slotName) {
        this.slotName = slotName;
        return this;
    }

    public GTRecipeBuilder uiName(String uiName) {
        this.uiName = uiName;
        return this;
    }

    public GTRecipeBuilder chance(int chance) {
        this.chance = chance;
        return this;
    }

    public GTRecipeBuilder maxChance(int maxChance) {
        this.maxChance = maxChance;
        return this;
    }

    public GTRecipeBuilder tierChanceBoost(int tierChanceBoost) {
        this.tierChanceBoost = tierChanceBoost;
        return this;
    }

    public GTRecipeBuilder isFuel(boolean isFuel) {
        this.isFuel = isFuel;
        return this;
    }

    public GTRecipeBuilder onSave(BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onSave) {
        this.onSave = onSave;
        return this;
    }

    public Collection<ResearchRecipeEntry> researchRecipeEntries() {
        return this.researchRecipeEntries;
    }

    public record ResearchRecipeEntry(@NotNull String researchId, @NotNull ItemStack researchStack, @NotNull ItemStack dataStack, int duration, int EUt, int CWUt) {
    }
}

