/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.xaeroworldmap;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.ButtonState;
import com.gregtechceu.gtceu.integration.map.xaeros.worldmap.gui.GuiTexturedButtonWithSize;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.map.MapProcessor;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.ScreenBase;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class GuiMapMixin
extends ScreenBase
implements IRightClickableElement {
    @Shadow
    public abstract <T extends GuiEventListener & Renderable> T addButton(T var1);

    protected GuiMapMixin(Screen parent, Screen escape, MapProcessor mapProcessor, Entity player) {
        super(parent, escape, (Component)Component.m_237115_((String)"gui.xaero_world_map_screen"));
    }

    @Inject(method={"init"}, at={@At(value="TAIL")}, remap=true)
    private void gtceu$injectInitGui(CallbackInfo ci) {
        int startY;
        int startX;
        int xOffset;
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.xaerosMapIntegration) {
            return;
        }
        int yOffset = switch (ConfigHolder.INSTANCE.compat.minimap.direction) {
            case ConfigHolder.CompatibilityConfigs.MinimapCompatConfig.Direction.VERTICAL -> {
                xOffset = 0;
                yield 1;
            }
            case ConfigHolder.CompatibilityConfigs.MinimapCompatConfig.Direction.HORIZONTAL -> {
                xOffset = 1;
                yield 0;
            }
            default -> throw new IllegalStateException("Unexpected value: " + ConfigHolder.INSTANCE.compat.minimap.direction);
        };
        switch (ConfigHolder.INSTANCE.compat.minimap.buttonAnchor) {
            case TOP_LEFT: {
                startX = ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = ConfigHolder.INSTANCE.compat.minimap.yOffset;
                break;
            }
            case TOP_CENTER: {
                startX = this.f_96543_ / 2 + ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = ConfigHolder.INSTANCE.compat.minimap.yOffset;
                break;
            }
            case TOP_RIGHT: {
                startX = this.f_96543_ - 20 - ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = ConfigHolder.INSTANCE.compat.minimap.yOffset;
                xOffset = -xOffset;
                break;
            }
            case RIGHT_CENTER: {
                startX = this.f_96543_ - 20 - ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = this.f_96544_ / 2 + ConfigHolder.INSTANCE.compat.minimap.yOffset;
                xOffset = -xOffset;
                yOffset = -yOffset;
                break;
            }
            case BOTTOM_RIGHT: {
                startX = this.f_96543_ - 20 - ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = this.f_96544_ - 20 - ConfigHolder.INSTANCE.compat.minimap.yOffset;
                xOffset = -xOffset;
                yOffset = -yOffset;
                break;
            }
            case BOTTOM_CENTER: {
                startX = this.f_96543_ / 2 + ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = this.f_96544_ - 20 - ConfigHolder.INSTANCE.compat.minimap.yOffset;
                yOffset = -yOffset;
                break;
            }
            case BOTTOM_LEFT: {
                startX = ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = this.f_96544_ - 20 - ConfigHolder.INSTANCE.compat.minimap.yOffset;
                yOffset = -yOffset;
                break;
            }
            case LEFT_CENTER: {
                startX = ConfigHolder.INSTANCE.compat.minimap.xOffset;
                startY = this.f_96544_ / 2 + ConfigHolder.INSTANCE.compat.minimap.yOffset;
                yOffset = -yOffset;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + ConfigHolder.INSTANCE.compat.minimap.buttonAnchor);
            }
        }
        if (ConfigHolder.INSTANCE.compat.minimap.buttonAnchor.isCentered()) {
            int totalButtonSize = ButtonState.buttonAmount() * 10;
            if (ConfigHolder.INSTANCE.compat.minimap.buttonAnchor.usualDirection().equals((Object)ConfigHolder.INSTANCE.compat.minimap.direction)) {
                startX -= xOffset * totalButtonSize;
                startY -= yOffset * totalButtonSize;
                if (xOffset < 0) {
                    startX -= 20;
                }
                if (yOffset < 0) {
                    startY -= 20;
                }
            } else {
                startX -= Math.abs(yOffset) * 10;
                startY -= Math.abs(xOffset) * 10;
            }
        }
        int offset = 0;
        for (ButtonState.Button button : ButtonState.getAllButtons()) {
            GuiTexturedButtonWithSize mapButton = new GuiTexturedButtonWithSize(startX + 20 * xOffset * offset, startY + 20 * yOffset * offset, 20, 20, 0, ButtonState.isEnabled(button) ? 16 : 0, 16, 16, 16, 32, GTCEu.id("textures/gui/widget/button_" + button.name + ".png"), guiButton -> {
                ButtonState.toggleButton(button);
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }, () -> new CursorBox("gtceu.button." + button.name));
            this.addButton(mapButton);
            ++offset;
        }
    }
}

