/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.worldgen.feature;

import com.gregtechceu.gtceu.common.worldgen.feature.configurations.StoneBlobConfiguration;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class StoneBlobFeature
extends Feature<StoneBlobConfiguration> {
    public StoneBlobFeature() {
        super(StoneBlobConfiguration.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<StoneBlobConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        StoneBlobConfiguration config = (StoneBlobConfiguration)context.m_159778_();
        int placedAmount = 0;
        int size = config.size().m_214085_(random);
        int radius = Mth.m_14167_((float)((float)size / 2.0f));
        int x0 = blockpos.m_123341_() - radius;
        int y0 = blockpos.m_123342_() - radius;
        int z0 = blockpos.m_123343_() - radius;
        int width = size + 1;
        int length = size + 1;
        int height = size + 1;
        if (blockpos.m_123342_() >= level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, blockpos.m_123341_(), blockpos.m_123343_())) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            for (int x = 0; x < width; ++x) {
                float dx = (float)x * 2.0f / (float)width - 1.0f;
                if (dx * dx > 1.0f) continue;
                for (int y = 0; y < height; ++y) {
                    float dy = (float)y * 2.0f / (float)height - 1.0f;
                    if (dx * dx + dy * dy > 1.0f || level.m_151562_(y0 + y)) continue;
                    for (int z = 0; z < length; ++z) {
                        LevelChunkSection levelchunksection;
                        float dz = (float)z * 2.0f / (float)length - 1.0f;
                        if (dx * dx + dy * dy + dz * dz > 1.0f) continue;
                        int currentX = x0 + x;
                        int currentY = y0 + y;
                        int currentZ = z0 + z;
                        mutablePos.m_122178_(currentX, currentY, currentZ);
                        if (!level.m_180807_((BlockPos)mutablePos) || (levelchunksection = bulkSectionAccess.m_156104_((BlockPos)mutablePos)) == null) continue;
                        int sectionX = SectionPos.m_123207_((int)currentX);
                        int sectionY = SectionPos.m_123207_((int)currentY);
                        int sectionZ = SectionPos.m_123207_((int)currentZ);
                        BlockState blockstate = levelchunksection.m_62982_(sectionX, sectionY, sectionZ);
                        if (!this.canPlaceOre(blockstate, arg_0 -> ((BulkSectionAccess)bulkSectionAccess).m_156110_(arg_0), random, config.state(), mutablePos) || config.state().f_161033_.m_60795_()) continue;
                        levelchunksection.m_62991_(sectionX, sectionY, sectionZ, config.state().f_161033_, false);
                        ++placedAmount;
                    }
                }
            }
        }
        return placedAmount > 0;
    }

    public boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, RandomSource random, OreConfiguration.TargetBlockState targetState, BlockPos.MutableBlockPos mutablePos) {
        if (!targetState.f_161032_.m_213865_(state, random)) {
            return false;
        }
        return !StoneBlobFeature.m_159750_(adjacentStateAccessor, (BlockPos)mutablePos);
    }
}

