/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.optical;

import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.IOpticalDataAccessHatch;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.blockentity.OpticalPipeBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalPipeNet;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalRoutePath;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpticalNetHandler
implements IDataAccessHatch,
IOpticalComputationProvider {
    private final OpticalPipeBlockEntity pipe;
    private final Level world;
    private final Direction facing;
    private OpticalPipeNet net;

    public OpticalNetHandler(OpticalPipeNet net, @NotNull OpticalPipeBlockEntity pipe, @Nullable Direction facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.m_58904_();
    }

    public void updateNetwork(OpticalPipeNet net) {
        this.net = net;
    }

    public OpticalPipeNet getNet() {
        return this.net;
    }

    @Override
    public boolean isRecipeAvailable(@NotNull GTRecipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        boolean isAvailable = this.traverseRecipeAvailable(recipe, seen);
        if (isAvailable) {
            this.setPipesActive();
        }
        return isAvailable;
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        int provided = this.traverseRequestCWUt(cwut, simulate, seen);
        if (provided > 0) {
            this.setPipesActive();
        }
        return provided;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        return this.traverseMaxCWUt(seen);
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        return this.traverseCanBridge(seen);
    }

    private void setPipesActive() {
        for (BlockPos pos : this.net.getAllNodes().keySet()) {
            BlockEntity blockEntity = this.world.m_7702_(pos);
            if (!(blockEntity instanceof OpticalPipeBlockEntity)) continue;
            OpticalPipeBlockEntity opticalPipe = (OpticalPipeBlockEntity)blockEntity;
            opticalPipe.setActive(true, 100);
        }
    }

    private boolean isNetInvalidForTraversal() {
        return this.net == null || this.pipe == null || this.pipe.isInValid();
    }

    private boolean traverseRecipeAvailable(@NotNull GTRecipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        if (this.isNetInvalidForTraversal()) {
            return false;
        }
        OpticalRoutePath inv = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (inv == null) {
            return false;
        }
        IOpticalDataAccessHatch hatch = inv.getDataHatch();
        if (hatch == null || seen.contains(hatch)) {
            return false;
        }
        if (hatch.isTransmitter()) {
            return hatch.isRecipeAvailable(recipe, seen);
        }
        return false;
    }

    private int traverseRequestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        IOpticalComputationProvider provider = this.getComputationProvider(seen);
        if (provider == null) {
            return 0;
        }
        return provider.requestCWUt(cwut, simulate, seen);
    }

    private int traverseMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        IOpticalComputationProvider provider = this.getComputationProvider(seen);
        if (provider == null) {
            return 0;
        }
        return provider.getMaxCWUt(seen);
    }

    private boolean traverseCanBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        IOpticalComputationProvider provider = this.getComputationProvider(seen);
        if (provider == null) {
            return true;
        }
        return provider.canBridge(seen);
    }

    @Nullable
    private IOpticalComputationProvider getComputationProvider(@NotNull Collection<IOpticalComputationProvider> seen) {
        if (this.isNetInvalidForTraversal()) {
            return null;
        }
        OpticalRoutePath inv = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (inv == null) {
            return null;
        }
        IOpticalComputationProvider hatch = inv.getComputationHatch();
        if (hatch == null || seen.contains(hatch)) {
            return null;
        }
        return hatch;
    }
}

