/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.gregtechceu.gtceu.common.cover.data.DistributionMode;
import com.gregtechceu.gtceu.common.cover.data.FilterMode;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemRoutePath;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemNetHandler
implements IItemHandlerModifiable {
    private ItemPipeNet net;
    private ItemPipeBlockEntity pipe;
    private final Level world;
    private final Direction facing;
    private final Map<FacingPos, Integer> simulatedTransfersGlobalRoundRobin = new HashMap<FacingPos, Integer>();
    private int simulatedTransfers = 0;
    private final ItemStackHandler testHandler = new ItemStackHandler(1);

    public ItemNetHandler(ItemPipeNet net, ItemPipeBlockEntity pipe, Direction facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.getPipeLevel();
    }

    private long getLevelTime() {
        return this.net.getLevel().m_46467_();
    }

    public void updateNetwork(ItemPipeNet net) {
        this.net = net;
    }

    public void updatePipe(ItemPipeBlockEntity pipe) {
        this.pipe = pipe;
    }

    private void copyTransferred() {
        this.simulatedTransfers = this.pipe.getTransferredItems();
        this.simulatedTransfersGlobalRoundRobin.clear();
        this.simulatedTransfersGlobalRoundRobin.putAll((Map<FacingPos, Integer>)this.pipe.getTransferred());
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        if (this.net == null || this.pipe == null || this.pipe.isInValid() || this.pipe.isBlocked(this.facing)) {
            return stack;
        }
        this.copyTransferred();
        CoverBehavior pipeCover = this.pipe.getCoverContainer().getCoverAtSide(this.facing);
        CoverBehavior tileCover = this.getCoverOnNeighbour(this.pipe.getPipePos(), this.facing);
        boolean pipeConveyor = pipeCover instanceof ConveyorCover;
        boolean tileConveyor = tileCover instanceof ConveyorCover;
        if (pipeConveyor && tileConveyor) {
            return stack;
        }
        if (tileCover != null && !ItemNetHandler.checkImportCover(tileCover, false, stack)) {
            return stack;
        }
        if (!pipeConveyor && !tileConveyor) {
            return this.insertFirst(stack, simulate);
        }
        ConveyorCover conveyor = (ConveyorCover)(pipeConveyor ? pipeCover : tileCover);
        if (conveyor.getIo() == (pipeConveyor ? IO.IN : IO.OUT)) {
            boolean roundRobinGlobal;
            boolean bl = roundRobinGlobal = conveyor.getDistributionMode() == DistributionMode.ROUND_ROBIN_GLOBAL;
            if (roundRobinGlobal || conveyor.getDistributionMode() == DistributionMode.ROUND_ROBIN_PRIO) {
                return this.insertRoundRobin(stack, simulate, roundRobinGlobal);
            }
        }
        return this.insertFirst(stack, simulate);
    }

    public static boolean checkImportCover(CoverBehavior cover, boolean onPipe, ItemStack stack) {
        if (cover == null) {
            return true;
        }
        if (cover instanceof ItemFilterCover) {
            ItemFilterCover filter = (ItemFilterCover)cover;
            return filter.getFilterMode() != FilterMode.FILTER_BOTH && (filter.getFilterMode() != FilterMode.FILTER_INSERT || !onPipe) && (filter.getFilterMode() != FilterMode.FILTER_EXTRACT || onPipe) || filter.getItemFilter().test(stack);
        }
        return true;
    }

    public ItemStack insertFirst(ItemStack stack, boolean simulate) {
        for (ItemRoutePath inv : this.net.getNetData(this.pipe.getPipePos(), this.facing)) {
            stack = this.insert(inv, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public ItemStack insertRoundRobin(ItemStack stack, boolean simulate, boolean global) {
        List<ItemRoutePath> routePaths = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (routePaths.isEmpty()) {
            return stack;
        }
        if (routePaths.size() == 1) {
            return this.insert(routePaths.get(0), stack, simulate);
        }
        ArrayList<ItemRoutePath> routePathsCopy = new ArrayList<ItemRoutePath>(routePaths);
        if (global) {
            stack = this.insertToHandlersEnhanced(routePathsCopy, stack, routePaths.size(), simulate);
        } else if (!(stack = this.insertToHandlers(routePathsCopy, stack, simulate)).m_41619_() && !routePathsCopy.isEmpty()) {
            stack = this.insertToHandlers(routePathsCopy, stack, simulate);
        }
        return stack;
    }

    private ItemStack insertToHandlers(List<ItemRoutePath> copy, ItemStack stack, boolean simulate) {
        int m;
        ListIterator<ItemRoutePath> routePathIterator = copy.listIterator();
        int inserted = 0;
        int count = stack.m_41613_();
        int c = count / copy.size();
        int n = m = c == 0 ? count % copy.size() : 0;
        while (routePathIterator.hasNext()) {
            ItemRoutePath routePath = (ItemRoutePath)routePathIterator.next();
            int amount = c;
            if (m > 0) {
                ++amount;
                --m;
            }
            if ((amount = Math.min(amount, stack.m_41613_() - inserted)) == 0) break;
            ItemStack toInsert = stack.m_41777_();
            toInsert.m_41764_(amount);
            int r = this.insert(routePath, toInsert, simulate).m_41613_();
            if (r < amount) {
                inserted += amount - r;
            }
            if (r == 1 && c == 0 && amount == 1) {
                ++m;
            }
            if (r <= 0) continue;
            routePathIterator.remove();
        }
        ItemStack remainder = stack.m_41777_();
        remainder.m_41764_(count - inserted);
        return remainder;
    }

    private ItemStack insertToHandlersEnhanced(List<ItemRoutePath> copy, ItemStack stack, int dest, boolean simulate) {
        ArrayList<EnhancedRoundRobinData> transferred = new ArrayList<EnhancedRoundRobinData>();
        IntArrayList steps = new IntArrayList();
        int min = Integer.MAX_VALUE;
        for (ItemRoutePath inv : copy) {
            ItemStack simStack = stack.m_41777_();
            int ins = stack.m_41613_() - this.insert(inv, simStack, true, true).m_41613_();
            if (ins <= 0) continue;
            int didTransfer = this.didTransferTo(inv, simulate);
            EnhancedRoundRobinData data2 = new EnhancedRoundRobinData(inv, ins, didTransfer);
            transferred.add(data2);
            min = Math.min(min, didTransfer);
            if (steps.contains(didTransfer)) continue;
            steps.add(didTransfer);
        }
        if (transferred.isEmpty() || steps.isEmpty()) {
            return stack;
        }
        if (!simulate && min < Integer.MAX_VALUE) {
            this.decrementBy(min);
        }
        transferred.sort(Comparator.comparingInt(data -> data.transferred));
        steps.sort(Integer::compare);
        if (((EnhancedRoundRobinData)transferred.get((int)0)).transferred != steps.getInt(0)) {
            return stack;
        }
        int amount = stack.m_41613_();
        int c = amount / transferred.size();
        int m = amount % transferred.size();
        ArrayList transferredCopy = new ArrayList(transferred);
        int nextStep = steps.removeInt(0);
        block1: while (amount > 0 && !transferredCopy.isEmpty()) {
            Iterator iterator = transferredCopy.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                EnhancedRoundRobinData enhancedRoundRobinData = (EnhancedRoundRobinData)iterator.next();
                if (nextStep >= 0 && enhancedRoundRobinData.transferred >= nextStep) break;
                int toInsert = nextStep <= 0 ? (amount <= m ? 1 : Math.min(c, amount)) : Math.min(amount, nextStep - enhancedRoundRobinData.transferred);
                if (enhancedRoundRobinData.toTransfer + toInsert >= enhancedRoundRobinData.maxInsertable) {
                    enhancedRoundRobinData.toTransfer = enhancedRoundRobinData.maxInsertable;
                    iterator.remove();
                } else {
                    enhancedRoundRobinData.toTransfer += toInsert;
                }
                enhancedRoundRobinData.transferred += toInsert;
                if ((amount -= toInsert) == 0) break block1;
                ++i;
            }
            for (EnhancedRoundRobinData data4 : transferredCopy) {
                if (data4.transferred >= nextStep) continue;
                continue block1;
            }
            if (steps.isEmpty()) {
                if (nextStep < 0) continue;
                c = amount / transferredCopy.size();
                m = amount % transferredCopy.size();
                nextStep = -1;
                continue;
            }
            nextStep = steps.removeInt(0);
        }
        int inserted = 0;
        for (EnhancedRoundRobinData enhancedRoundRobinData : transferred) {
            ItemStack toInsert = stack.m_41777_();
            toInsert.m_41764_(enhancedRoundRobinData.toTransfer);
            int ins = enhancedRoundRobinData.toTransfer - this.insert(enhancedRoundRobinData.routePath, toInsert, simulate).m_41613_();
            inserted += ins;
            this.transferTo(enhancedRoundRobinData.routePath, simulate, ins);
        }
        ItemStack remainder = stack.m_41777_();
        remainder.m_41774_(inserted);
        return remainder;
    }

    public ItemStack insert(ItemRoutePath handler, ItemStack stack, boolean simulate) {
        return this.insert(handler, stack, simulate, false);
    }

    public ItemStack insert(ItemRoutePath routePath, ItemStack stack, boolean simulate, boolean ignoreLimit) {
        RobotArmCover robotArm;
        int allowed;
        int n = allowed = ignoreLimit ? stack.m_41613_() : this.checkTransferable(routePath.getProperties().getTransferRate(), stack.m_41613_(), simulate);
        if (allowed == 0 || !routePath.matchesFilters(stack)) {
            return stack;
        }
        CoverBehavior pipeCover = routePath.getTargetPipe().getCoverContainer().getCoverAtSide(routePath.getTargetFacing());
        CoverBehavior tileCover = this.getCoverOnNeighbour(routePath.getTargetPipe().getPipePos(), routePath.getTargetFacing());
        if (pipeCover != null) {
            this.testHandler.setStackInSlot(0, stack.m_41777_());
            IItemHandlerModifiable itemHandler = pipeCover.getItemHandlerCap((IItemHandlerModifiable)this.testHandler);
            if (itemHandler == null || itemHandler != this.testHandler && (allowed = itemHandler.extractItem(0, allowed, true).m_41613_()) <= 0) {
                this.testHandler.setStackInSlot(0, ItemStack.f_41583_);
                return stack;
            }
            this.testHandler.setStackInSlot(0, ItemStack.f_41583_);
        }
        IItemHandler neighbourHandler = routePath.getHandler((Level)this.net.getLevel());
        if (pipeCover instanceof RobotArmCover && (robotArm = (RobotArmCover)pipeCover).getIo() == IO.OUT) {
            return this.insertOverRobotArm(neighbourHandler, robotArm, stack, simulate, allowed, ignoreLimit);
        }
        if (tileCover instanceof RobotArmCover && (robotArm = (RobotArmCover)tileCover).getIo() == IO.IN) {
            return this.insertOverRobotArm(neighbourHandler, robotArm, stack, simulate, allowed, ignoreLimit);
        }
        return this.insert(neighbourHandler, stack, simulate, allowed, ignoreLimit);
    }

    private ItemStack insert(IItemHandler handler, ItemStack stack, boolean simulate, int allowed, boolean ignoreLimit) {
        if (stack.m_41613_() == allowed) {
            ItemStack re = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
            if (!ignoreLimit) {
                this.transfer(simulate, stack.m_41613_() - re.m_41613_());
            }
            return re;
        }
        ItemStack toInsert = stack.m_41777_();
        toInsert.m_41764_(Math.min(allowed, stack.m_41613_()));
        int r = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)toInsert, (boolean)simulate).m_41613_();
        if (!ignoreLimit) {
            this.transfer(simulate, toInsert.m_41613_() - r);
        }
        ItemStack remainder = stack.m_41777_();
        remainder.m_41764_(r + (stack.m_41613_() - toInsert.m_41613_()));
        return remainder;
    }

    public CoverBehavior getCoverOnNeighbour(BlockPos pos, Direction handlerFacing) {
        BlockEntity tile = this.pipe.m_58904_().m_7702_(pos.m_121945_(handlerFacing));
        if (tile != null) {
            ICoverable coverable = GTCapabilityHelper.getCoverable(this.pipe.m_58904_(), pos.m_121945_(handlerFacing), handlerFacing.m_122424_());
            if (coverable == null) {
                return null;
            }
            return coverable.getCoverAtSide(handlerFacing.m_122424_());
        }
        return null;
    }

    public ItemStack insertOverRobotArm(IItemHandler handler, RobotArmCover arm, ItemStack stack, boolean simulate, int allowed, boolean ignoreLimit) {
        boolean isStackSpecific = false;
        int rate = arm.getFilterHandler().getFilter().testItemCount(stack);
        switch (arm.getTransferMode()) {
            case TRANSFER_ANY: {
                return this.insert(handler, stack, simulate, allowed, ignoreLimit);
            }
            case KEEP_EXACT: {
                int count = rate - ItemNetHandler.countStack(handler, stack, arm, isStackSpecific);
                if (count <= 0) {
                    return stack;
                }
                count = Math.min(allowed, Math.min(stack.m_41613_(), count));
                return this.insert(handler, stack, simulate, count, ignoreLimit);
            }
            case TRANSFER_EXACT: {
                int max = allowed + arm.getBuffer();
                int count = Math.min(max, Math.min(rate, stack.m_41613_()));
                if (count < rate) {
                    arm.buffer(allowed);
                    return stack;
                }
                arm.clearBuffer();
                if (this.insert(handler, stack, true, count, ignoreLimit).m_41613_() != stack.m_41613_() - count) {
                    return stack;
                }
                return this.insert(handler, stack, simulate, count, ignoreLimit);
            }
        }
        return stack;
    }

    public static int countStack(IItemHandler handler, ItemStack stack, RobotArmCover arm, boolean isStackSpecific) {
        if (arm == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.m_41619_() || !(isStackSpecific ? ItemStackHashStrategy.comparingAllButCount().equals(stack, slot) : arm.getFilterHandler().getFilter().test(slot))) continue;
            count += slot.m_41613_();
        }
        return count;
    }

    private int checkTransferable(float rate, int amount, boolean simulate) {
        int max = (int)((double)(rate * 64.0f) + 0.5);
        if (simulate) {
            return Math.max(0, Math.min(max - this.simulatedTransfers, amount));
        }
        return Math.max(0, Math.min(max - this.pipe.getTransferredItems(), amount));
    }

    private void transfer(boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfers += amount;
        } else {
            this.pipe.addTransferredItems(amount);
        }
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    private void transferTo(ItemRoutePath handler, boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfersGlobalRoundRobin.merge(handler.toFacingPos(), amount, Integer::sum);
        } else {
            this.pipe.getTransferred().merge((Object)handler.toFacingPos(), amount, Integer::sum);
        }
    }

    private boolean contains(ItemRoutePath handler, boolean simulate) {
        return simulate ? this.simulatedTransfersGlobalRoundRobin.containsKey(handler.toFacingPos()) : this.pipe.getTransferred().containsKey((Object)handler.toFacingPos());
    }

    private int didTransferTo(ItemRoutePath handler, boolean simulate) {
        if (simulate) {
            return this.simulatedTransfersGlobalRoundRobin.getOrDefault(handler.toFacingPos(), 0);
        }
        return this.pipe.getTransferred().getOrDefault((Object)handler.toFacingPos(), 0);
    }

    private void resetTransferred(boolean simulated) {
        if (simulated) {
            this.simulatedTransfersGlobalRoundRobin.clear();
        } else {
            this.pipe.resetTransferred();
        }
    }

    private void decrementBy(int amount) {
        for (Map.Entry entry : this.pipe.getTransferred().entrySet()) {
            entry.setValue((Integer)entry.getValue() - amount);
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    public ItemPipeNet getNet() {
        return this.net;
    }

    public Direction getFacing() {
        return this.facing;
    }

    private static class EnhancedRoundRobinData {
        private final ItemRoutePath routePath;
        private final int maxInsertable;
        private int transferred;
        private int toTransfer = 0;

        private EnhancedRoundRobinData(ItemRoutePath routePath, int maxInsertable, int transferred) {
            this.maxInsertable = maxInsertable;
            this.transferred = transferred;
            this.routePath = routePath;
        }
    }
}

