/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.steam;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;

public class SteamSolarBoiler
extends SteamBoilerMachine {
    public SteamSolarBoiler(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
    }

    @Override
    public Direction getFrontFacing() {
        return Direction.UP;
    }

    @Override
    protected long getBaseSteamOutput() {
        return this.isHighPressure ? (long)ConfigHolder.INSTANCE.machines.smallBoilers.hpSolarBoilerBaseOutput : (long)ConfigHolder.INSTANCE.machines.smallBoilers.solarBoilerBaseOutput;
    }

    @Override
    protected void updateSteamSubscription() {
        if (this.temperatureSubs == null) {
            this.temperatureSubs = this.subscribeServerTick(this.temperatureSubs, this::updateCurrentTemperature);
        }
    }

    @Override
    protected void updateCurrentTemperature() {
        if (GTUtil.canSeeSunClearly(this.getLevel(), this.getPos())) {
            this.recipeLogic.setStatus(RecipeLogic.Status.WORKING);
        } else {
            this.recipeLogic.setStatus(RecipeLogic.Status.IDLE);
        }
        super.updateCurrentTemperature();
    }

    @Override
    protected int getCooldownInterval() {
        return this.isHighPressure ? 50 : 45;
    }

    @Override
    protected int getCoolDownRate() {
        return 3;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return super.createUI(entityPlayer).widget((Widget)new ProgressWidget(() -> GTUtil.canSeeSunClearly(this.getLevel(), this.getPos()) ? 1.0 : 0.0, 114, 44, 20, 20).setProgressTexture((IGuiTexture)GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(this.isHighPressure).getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(this.isHighPressure).getSubTexture(0.0, 0.5, 1.0, 0.5)));
    }

    @Override
    protected void randomDisplayTick(RandomSource random, float x, float y, float z) {
    }
}

