/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class FTBOwner
implements IMachineOwner {
    private Team team;
    private UUID playerUUID;

    public FTBOwner() {
    }

    public FTBOwner(Team team, UUID player) {
        this.team = team;
        this.playerUUID = player;
    }

    @Override
    public void save(CompoundTag tag) {
        if (this.team != null) {
            tag.m_128362_("teamUUID", this.team.getTeamId());
        }
        tag.m_128362_("playerUUID", this.playerUUID);
    }

    @Override
    public void load(CompoundTag tag) {
        try {
            this.team = tag.m_128441_("teamUUID") ? (Team)FTBTeamsAPIImpl.INSTANCE.getManager().getTeamByID(tag.m_128342_("teamUUID")).orElse(null) : null;
        }
        catch (NullPointerException e) {
            this.team = null;
        }
        this.playerUUID = tag.m_128342_("playerUUID");
    }

    @Override
    public boolean isPlayerInTeam(Player player) {
        if (player.m_20148_().equals(this.playerUUID)) {
            return true;
        }
        return FTBTeamsAPIImpl.INSTANCE.getManager().arePlayersInSameTeam(player.m_20148_(), this.playerUUID);
    }

    @Override
    public boolean isPlayerFriendly(Player player) {
        return this.team.getRankForPlayer(player.m_20148_()).isAllyOrBetter();
    }

    @Override
    public void displayInfo(List<Component> compList) {
        boolean isOnline;
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.machine_ownership", (Object[])new Object[]{this.type().getName()}));
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.team_name", (Object[])new Object[]{this.team.getName()}));
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerUUID);
        String[] playerName = new String[1];
        if (serverPlayer != null) {
            playerName[0] = serverPlayer.m_5446_().getString();
            isOnline = true;
        } else {
            GameProfileCache cache = ServerLifecycleHooks.getCurrentServer().m_129927_();
            if (cache != null) {
                cache.m_11002_(this.playerUUID).ifPresent(value -> {
                    playerName[0] = value.getName();
                });
            }
            isOnline = false;
        }
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.player_name", (Object[])new Object[]{playerName[0], isOnline}));
    }

    @Override
    public IMachineOwner.MachineOwnerType type() {
        return IMachineOwner.MachineOwnerType.FTB;
    }

    public Team getTeam() {
        return this.team;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

