/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamParallelMultiblockMachine
extends WorkableMultiblockMachine
implements IDisplayUIMachine {
    public int maxParallels;
    public static final double CONVERSION_RATE = 2.0;

    public SteamParallelMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, new Object[0]);
        Object object;
        this.maxParallels = ConfigHolder.INSTANCE.machines.steamMultiParallelAmount;
        if (args.length > 0 && (object = args[0]) instanceof Integer) {
            Integer i = (Integer)object;
            this.maxParallels = i;
        }
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        List handlers = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)FluidRecipeCapability.CAP);
        if (handlers == null) {
            return;
        }
        Iterator itr = handlers.iterator();
        while (itr.hasNext()) {
            NotifiableFluidTank tank;
            IRecipeHandler handler = (IRecipeHandler)itr.next();
            if (!(handler instanceof NotifiableFluidTank) || !(tank = (NotifiableFluidTank)handler).isFluidValid(0, GTMaterials.Steam.getFluid(1))) continue;
            itr.remove();
            if (!this.capabilitiesProxy.contains((Object)IO.IN, (Object)EURecipeCapability.CAP)) {
                this.capabilitiesProxy.put((Object)IO.IN, (Object)EURecipeCapability.CAP, new ArrayList());
            }
            ((List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP)).add(new SteamEnergyRecipeHandler(tank, this.getConversionRate()));
            return;
        }
    }

    public double getConversionRate() {
        return 2.0;
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        int parallelAmount;
        if (!(machine instanceof SteamParallelMultiblockMachine)) {
            return RecipeModifier.nullWrongType(SteamParallelMultiblockMachine.class, machine);
        }
        SteamParallelMultiblockMachine steamMachine = (SteamParallelMultiblockMachine)machine;
        if (RecipeHelper.getRecipeEUtTier(recipe) > 1) {
            return ModifierFunction.NULL;
        }
        long eut = RecipeHelper.getInputEUt(recipe);
        double eutMultiplier = (double)eut * 0.8888 * (double)(parallelAmount = ParallelLogic.getParallelAmount(machine, recipe, steamMachine.maxParallels)) <= 32.0 ? 0.8888 * (double)parallelAmount : 32.0 / (double)eut;
        return ModifierFunction.builder().inputModifier(ContentModifier.multiplier(parallelAmount)).outputModifier(ContentModifier.multiplier(parallelAmount)).durationMultiplier(1.5).eutMultiplier(eutMultiplier).parallels(parallelAmount).build();
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        IDisplayUIMachine.super.addDisplayText(textList);
        if (this.isFormed()) {
            SteamEnergyRecipeHandler steamHandler;
            Object e;
            List handlers = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP);
            if (handlers != null && handlers.size() > 0 && (e = handlers.get(0)) instanceof SteamEnergyRecipeHandler && (steamHandler = (SteamEnergyRecipeHandler)e).getCapacity() > 0L) {
                long steamStored = steamHandler.getStored();
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.steam.steam_stored", (Object[])new Object[]{steamStored, steamHandler.getCapacity()}));
            }
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                if (this.maxParallels > 1) {
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.parallel", (Object[])new Object[]{this.maxParallels}));
                }
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                double maxInSec = (float)this.recipeLogic.getDuration() / 20.0f;
                double currentInSec = (float)this.recipeLogic.getProgress() / 20.0f;
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)currentInSec)), String.format("%.2f", Float.valueOf((float)maxInSec)), currentProgress}));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.steam.low_steam").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
    }

    @Override
    public IGuiTexture getScreenTexture() {
        return GuiTextures.DISPLAY_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks);
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        DraggableScrollableWidgetGroup screen = new DraggableScrollableWidgetGroup(7, 4, 162, 121).setBackground(this.getScreenTexture());
        screen.addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_()));
        screen.addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick));
        return new ModularUI(176, 216, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks)}).widget((Widget)screen).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks), 7, 134, true));
    }
}

