/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MetaMachineConfigCopyBehaviour
implements IInteractionItem,
IAddInformation {
    public static final String CONFIG_DATA = "config_data";
    public static final String ORIGINAL_FRONT = "front";
    public static final String ITEM_CONFIG = "item";
    public static final String FLUID_CONFIG = "fluid";
    public static final String DIRECTION = "direction";
    public static final String AUTO = "auto";
    public static final String INPUT_FROM_OUTPUT_SIDE = "in_from_out";
    public static final String MUFFLED = "muffled";

    public static int directionToInt(@Nullable Direction direction) {
        return direction == null ? 0 : direction.ordinal() + 1;
    }

    public static Direction intToDirection(int ordinal) {
        return ordinal <= 0 || ordinal > Direction.values().length ? null : Direction.values()[ordinal - 1];
    }

    public static Component relativeDirectionComponent(Direction origFront, Direction origDirection) {
        int i;
        if (origFront == origDirection) {
            return Component.m_237115_((String)"gtceu.direction.tooltip.front").m_130940_(ChatFormatting.YELLOW);
        }
        if (Direction.UP == origDirection) {
            return Component.m_237115_((String)"gtceu.direction.tooltip.up").m_130940_(ChatFormatting.YELLOW);
        }
        if (Direction.DOWN == origDirection) {
            return Component.m_237115_((String)"gtceu.direction.tooltip.down").m_130940_(ChatFormatting.YELLOW);
        }
        Direction face = origFront;
        for (i = 0; i < 3 && (face = face.m_122427_()) != origDirection; ++i) {
        }
        return switch (i) {
            case 0 -> Component.m_237115_((String)"gtceu.direction.tooltip.right").m_130940_(ChatFormatting.YELLOW);
            case 1 -> Component.m_237115_((String)"gtceu.direction.tooltip.back").m_130940_(ChatFormatting.YELLOW);
            case 2 -> Component.m_237115_((String)"gtceu.direction.tooltip.left").m_130940_(ChatFormatting.YELLOW);
            default -> Component.m_237113_((String)"");
        };
    }

    public static Direction getRelativeDirection(Direction originalFront, Direction currentFacing, Direction face) {
        int i;
        if (currentFacing == null || originalFront == null || currentFacing == originalFront || face == Direction.UP || face == Direction.DOWN) {
            return face;
        }
        Direction newFace = originalFront;
        for (i = 0; i < 4 && newFace != currentFacing; newFace = newFace.m_122427_(), ++i) {
        }
        newFace = face;
        for (int j = 0; j < i; ++j) {
            newFace = newFace.m_122427_();
        }
        return newFace;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            stack.m_41751_(null);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
            if (!IMachineOwner.canOpenOwnerMachine(context.m_43723_(), blockEntity2)) {
                return InteractionResult.FAIL;
            }
            MetaMachine machine = blockEntity2.getMetaMachine();
            if (context.m_7078_()) {
                return MetaMachineConfigCopyBehaviour.handleCopy(stack, machine);
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_(CONFIG_DATA)) {
                return MetaMachineConfigCopyBehaviour.handlePaste(stack, machine);
            }
        } else if (context.m_7078_() && context.m_43725_().m_8055_(context.m_8083_()).m_60795_()) {
            stack.m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult handleCopy(ItemStack stack, MetaMachine machine) {
        IAutoOutputFluid autoOutputFluid;
        IAutoOutputItem autoOutputItem;
        CompoundTag configData = new CompoundTag();
        configData.m_128405_(ORIGINAL_FRONT, MetaMachineConfigCopyBehaviour.directionToInt(machine.getFrontFacing()));
        if (machine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems() != null) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_(DIRECTION, MetaMachineConfigCopyBehaviour.directionToInt(autoOutputItem.getOutputFacingItems()));
            itemTag.m_128379_(AUTO, autoOutputItem.isAutoOutputItems());
            itemTag.m_128379_(INPUT_FROM_OUTPUT_SIDE, autoOutputItem.isAllowInputFromOutputSideItems());
            configData.m_128365_(ITEM_CONFIG, (Tag)itemTag);
        }
        if (machine instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids() != null) {
            CompoundTag fluidTag = new CompoundTag();
            fluidTag.m_128405_(DIRECTION, MetaMachineConfigCopyBehaviour.directionToInt(autoOutputFluid.getOutputFacingFluids()));
            fluidTag.m_128379_(AUTO, autoOutputFluid.isAutoOutputFluids());
            fluidTag.m_128379_(INPUT_FROM_OUTPUT_SIDE, autoOutputFluid.isAllowInputFromOutputSideFluids());
            configData.m_128365_(FLUID_CONFIG, (Tag)fluidTag);
        }
        if (machine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)machine);
            configData.m_128379_(MUFFLED, mufflableMachine.isMuffled());
        }
        if (!configData.m_128456_()) {
            stack.m_41784_().m_128365_(CONFIG_DATA, (Tag)configData);
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult handlePaste(ItemStack stack, MetaMachine machine) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(CONFIG_DATA)) {
            return InteractionResult.PASS;
        }
        CompoundTag root = stack.m_41784_();
        CompoundTag configData = root.m_128469_(CONFIG_DATA);
        Direction originalFront = MetaMachineConfigCopyBehaviour.intToDirection(configData.m_128451_(ORIGINAL_FRONT));
        if (configData.m_128441_(ITEM_CONFIG) && machine instanceof IAutoOutputItem) {
            IAutoOutputItem autoOutputItem = (IAutoOutputItem)((Object)machine);
            CompoundTag itemData = configData.m_128469_(ITEM_CONFIG);
            autoOutputItem.setOutputFacingItems(MetaMachineConfigCopyBehaviour.getRelativeDirection(originalFront, machine.getFrontFacing(), MetaMachineConfigCopyBehaviour.intToDirection(itemData.m_128451_(DIRECTION))));
            autoOutputItem.setAutoOutputItems(itemData.m_128471_(AUTO));
            autoOutputItem.setAllowInputFromOutputSideItems(itemData.m_128471_(INPUT_FROM_OUTPUT_SIDE));
        }
        if (configData.m_128441_(FLUID_CONFIG) && machine instanceof IAutoOutputFluid) {
            IAutoOutputFluid autoOutputFluid = (IAutoOutputFluid)((Object)machine);
            CompoundTag fluidData = configData.m_128469_(FLUID_CONFIG);
            autoOutputFluid.setOutputFacingFluids(MetaMachineConfigCopyBehaviour.getRelativeDirection(originalFront, machine.getFrontFacing(), MetaMachineConfigCopyBehaviour.intToDirection(fluidData.m_128451_(DIRECTION))));
            autoOutputFluid.setAutoOutputFluids(fluidData.m_128471_(AUTO));
            autoOutputFluid.setAllowInputFromOutputSideFluids(fluidData.m_128471_(INPUT_FROM_OUTPUT_SIDE));
        }
        if (configData.m_128441_(MUFFLED) && machine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)machine);
            mufflableMachine.setMuffled(configData.m_128471_(MUFFLED));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.meta.machine.config.copy.tooltip"));
        tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.meta.machine.config.paste.tooltip"));
        if (!stack.m_41782_()) {
            return;
        }
        if (Screen.m_96638_()) {
            tooltipComponents.add((Component)Component.m_237113_((String)""));
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(CONFIG_DATA)) {
                CompoundTag data = tag.m_128469_(CONFIG_DATA);
                MutableComponent enabledComponent = Component.m_237115_((String)"cover.voiding.label.enabled").m_130940_(ChatFormatting.GREEN);
                MutableComponent disabledComponent = Component.m_237115_((String)"cover.voiding.label.disabled").m_130940_(ChatFormatting.RED);
                if (data.m_128441_(ORIGINAL_FRONT)) {
                    Direction origFront = MetaMachineConfigCopyBehaviour.intToDirection(data.m_128451_(ORIGINAL_FRONT));
                    if (data.m_128441_(ITEM_CONFIG)) {
                        CompoundTag itemData = data.m_128469_(ITEM_CONFIG);
                        MutableComponent itemComponent = Component.m_237115_((String)"recipe.capability.item.name").m_130940_(ChatFormatting.GOLD);
                        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.output.direction.tooltip", (Object[])new Object[]{itemComponent, MetaMachineConfigCopyBehaviour.relativeDirectionComponent(origFront, MetaMachineConfigCopyBehaviour.intToDirection(itemData.m_128451_(DIRECTION)))}));
                        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.item_auto_output.tooltip", (Object[])new Object[]{itemComponent, itemData.m_128471_(AUTO) ? enabledComponent : disabledComponent}));
                        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.allow.input.from.output.tooltip", (Object[])new Object[]{itemComponent, itemData.m_128471_(INPUT_FROM_OUTPUT_SIDE) ? enabledComponent : disabledComponent}));
                    }
                    if (data.m_128441_(FLUID_CONFIG)) {
                        CompoundTag fluidData = data.m_128469_(FLUID_CONFIG);
                        MutableComponent fluidComponent = Component.m_237115_((String)"recipe.capability.fluid.name").m_130940_(ChatFormatting.BLUE);
                        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.output.direction.tooltip", (Object[])new Object[]{fluidComponent, MetaMachineConfigCopyBehaviour.relativeDirectionComponent(origFront, MetaMachineConfigCopyBehaviour.intToDirection(fluidData.m_128451_(DIRECTION)))}));
                        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.item_auto_output.tooltip", (Object[])new Object[]{fluidComponent, fluidData.m_128471_(AUTO) ? enabledComponent : disabledComponent}));
                        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.allow.input.from.output.tooltip", (Object[])new Object[]{fluidComponent, fluidData.m_128471_(INPUT_FROM_OUTPUT_SIDE) ? enabledComponent : disabledComponent}));
                    }
                }
                if (data.m_128441_(MUFFLED)) {
                    tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.muffled.tooltip", (Object[])new Object[]{data.m_128471_(MUFFLED) ? enabledComponent : disabledComponent}));
                }
            }
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.toggle.advanced.info.tooltip"));
        }
    }
}

