/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoeGroundBehavior
implements IToolBehavior {
    public static final HoeGroundBehavior INSTANCE = HoeGroundBehavior.create();

    protected HoeGroundBehavior() {
    }

    protected static HoeGroundBehavior create() {
        return new HoeGroundBehavior();
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Object blocks;
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (this.isBlockTillable(stack, world, player, pos, context)) {
            if (aoeDefinition == AoESymmetrical.none()) {
                blocks = ImmutableSet.of((Object)pos);
            } else {
                HitResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
                if (rayTraceResult == null) {
                    return InteractionResult.PASS;
                }
                if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
                    return InteractionResult.PASS;
                }
                if (!(rayTraceResult instanceof BlockHitResult)) {
                    return InteractionResult.PASS;
                }
                BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
                if (blockHitResult.m_82434_() == null) {
                    return InteractionResult.PASS;
                }
                blocks = HoeGroundBehavior.getTillableBlocks(stack, aoeDefinition, world, player, (HitResult)blockHitResult);
                if (this.isBlockTillable(stack, world, player, blockHitResult.m_82425_(), context)) {
                    blocks.add(blockHitResult.m_82425_());
                }
            }
        } else {
            return InteractionResult.PASS;
        }
        boolean tilled = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            BlockState state = world.m_8055_(blockPos);
            tilled |= this.tillGround(new UseOnContext(player, hand, context.m_43718_().m_82430_(blockPos)), state);
            if (!player.m_7500_()) {
                ToolHelper.damageItem(context.m_43722_(), (LivingEntity)context.m_43723_());
            }
            if (!stack.m_41619_()) continue;
            break;
        }
        if (tilled) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11955_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Set<BlockPos> getTillableBlocks(ItemStack stack, AoESymmetrical aoeDefinition, Level world, Player player, HitResult rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, INSTANCE::isBlockTillable);
    }

    protected boolean isBlockTillable(ItemStack stack, Level world, Player player, BlockPos pos, UseOnContext context) {
        if (world.m_8055_(pos.m_7494_()).m_60795_()) {
            BlockState state = world.m_8055_(pos);
            BlockState newState = state.getToolModifiedState(context, ToolActions.HOE_TILL, false);
            return newState != null && newState != state;
        }
        return false;
    }

    protected boolean tillGround(UseOnContext context, BlockState state) {
        BlockState newState = state.getToolModifiedState(context, ToolActions.HOE_TILL, false);
        if (newState != null && newState != state) {
            context.m_43725_().m_220407_(GameEvent.f_157792_, context.m_8083_(), GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)state));
            return context.m_43725_().m_7731_(context.m_8083_(), newState, 11);
        }
        return false;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.ground_tilling"));
    }
}

