/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.armor.IStepAssist;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class NanoMuscleSuite
extends ArmorLogicSuite
implements IStepAssist {
    @OnlyIn(value=Dist.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public NanoMuscleSuite(ArmorItem.Type slot, int energyPerUse, long maxCapacity, int tier) {
        super(energyPerUse, maxCapacity, tier, slot);
        if (GTCEu.isClientSide() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, ItemStack itemStack) {
        int nightVisionTimer;
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        CompoundTag data = itemStack.m_41784_();
        int toggleTimer = data.m_128441_("toggleTimer") ? data.m_128445_("toggleTimer") : 0;
        int n = nightVisionTimer = data.m_128441_("nightVisionTimer") ? data.m_128451_("nightVisionTimer") : 400;
        if (this.type == ArmorItem.Type.HELMET) {
            boolean nightVision;
            boolean bl = nightVision = data.m_128441_("nightVision") && data.m_128471_("nightVision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                nightVision = !nightVision;
                toggleTimer = 5;
                if (item.getCharge() < 4L) {
                    nightVision = false;
                    player.m_5661_((Component)Component.m_237115_((String)"metaarmor.nms.nightvision.error"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)("metaarmor.nms.nightvision." + (nightVision ? "enabled" : "disabled"))), true);
                }
            }
            if (nightVision) {
                player.m_21195_(MobEffects.f_19610_);
                if (nightVisionTimer <= 220) {
                    nightVisionTimer = 400;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0, true, false));
                    item.discharge(4L, this.tier, true, false, false);
                }
            } else {
                player.m_21195_(MobEffects.f_19611_);
            }
            data.m_128379_("nightVision", nightVision);
        }
        if (nightVisionTimer > 0) {
            --nightVisionTimer;
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128405_("nightVisionTimer", nightVisionTimer);
        data.m_128344_("toggleTimer", (byte)toggleTimer);
    }

    public static void disableNightVision(@NotNull Level world, Player player, boolean sendMsg) {
        if (!world.f_46443_) {
            player.m_21195_(MobEffects.f_19611_);
            if (sendMsg) {
                player.m_5661_((Component)Component.m_237115_((String)"metaarmor.nms.nightvision.disabled"), true);
            }
        }
    }

    public boolean handleUnblockableDamage(LivingEntity entity, @NotNull ItemStack armor, DamageSource source, double damage, ArmorItem.Type equipmentSlot) {
        return source.m_276093_(DamageTypes.f_268671_);
    }

    @Override
    public void damageArmor(LivingEntity entity, ItemStack itemStack, DamageSource source, int damage, EquipmentSlot equipmentSlot) {
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item != null) {
            item.discharge((long)this.energyPerUse / 10L * (long)damage, item.getTier(), true, false, false);
        }
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ItemStack currentChest = Minecraft.m_91087_().f_91074_.m_150109_().m_36052_(ArmorItem.Type.CHESTPLATE.m_266308_().m_20749_());
        ItemStack advancedChest = GTItems.NANO_CHESTPLATE_ADVANCED.asStack();
        String armorTexture = "nano_muscule_suite";
        if (advancedChest.m_150930_(currentChest.m_41720_())) {
            armorTexture = "advanced_nano_muscle_suite";
        }
        return slot != EquipmentSlot.LEGS ? GTCEu.id(String.format("textures/armor/%s_1.png", armorTexture)) : GTCEu.id(String.format("textures/armor/%s_2.png", armorTexture));
    }

    @Override
    public double getDamageAbsorption() {
        return 1.0;
    }

    @Override
    public float getHeatResistance() {
        return 0.75f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        NanoMuscleSuite.addCapacityHUD(item, this.HUD);
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        if (this.type == ArmorItem.Type.HELMET) {
            CompoundTag nbtData = itemStack.m_41784_();
            boolean nv = nbtData.m_128471_("nightVision");
            if (nv) {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.enabled"));
            } else {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.disabled"));
            }
        } else if (this.type == ArmorItem.Type.BOOTS) {
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.stepassist"));
            lines.add((Component)Component.m_237115_((String)"metaarmor.tooltip.falldamage"));
        }
    }
}

