/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.capability.LocalizedHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.prospecting.SPacketProspectBedrockFluid;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.networking.IPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class PortableScannerBehavior
implements IInteractionItem,
IAddInformation {
    private int debugLevel = 0;

    public PortableScannerBehavior(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (!level.m_5776_() && !level.m_46859_(pos) && player != null) {
            ArrayList<Component> list = new ArrayList<Component>();
            int energyCost = this.addScannerInfo(player, level, pos, this.getMode(stack), list);
            if (player.m_7500_()) {
                energyCost = 0;
            }
            if (energyCost > 0 && !this.drainEnergy(stack, energyCost, true)) {
                player.m_213846_((Component)Component.m_237115_((String)"behavior.prospector.not_enough_energy"));
                return InteractionResult.CONSUME;
            }
            this.drainEnergy(stack, energyCost, false);
            for (Component line : list) {
                player.m_213846_(line);
            }
            GTSoundEntries.PORTABLE_SCANNER.play(level, null, player.m_20182_(), 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.m_21120_(usedHand);
        if (player.m_6047_()) {
            if (!level.f_46443_) {
                this.setNextMode(heldItem);
                DisplayMode mode = this.getMode(heldItem);
                player.m_213846_((Component)Component.m_237110_((String)"behavior.portable_scanner.mode.caption", (Object[])new Object[]{Component.m_237115_((String)mode.getLangKey())}));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    protected boolean drainEnergy(@Nonnull ItemStack stack, int amount, boolean simulate) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= (long)amount;
    }

    protected void setNextMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Mode", (tag.m_128451_("Mode") + 1) % DisplayMode.values().length);
    }

    @Nonnull
    protected DisplayMode getMode(ItemStack stack) {
        if (stack == ItemStack.f_41583_) {
            return DisplayMode.SHOW_ALL;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return DisplayMode.SHOW_ALL;
        }
        return DisplayMode.values()[tag.m_128451_("Mode") % DisplayMode.values().length];
    }

    public int addScannerInfo(Player player, Level level, BlockPos pos, DisplayMode mode, List<Component> list) {
        IDataInfoProvider dataInfoProvider;
        List<Component> debugInfo;
        BlockEntity tileEntity = level.m_7702_(pos);
        int energyCost = 0;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_BLOCK_INFO) {
            list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.position", (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(pos.m_123341_())).m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)FormattingUtil.formatNumbers(pos.m_123342_())).m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)FormattingUtil.formatNumbers(pos.m_123343_())).m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)level.m_46472_().m_135782_().toString()).m_130940_(ChatFormatting.AQUA)}));
            list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.block_hardness", (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(block.m_155943_())).m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)FormattingUtil.formatNumbers(block.m_7325_())).m_130940_(ChatFormatting.YELLOW)}));
            if (this.debugLevel > 2) {
                state.m_61147_().forEach(property -> list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.state", (Object[])new Object[]{Component.m_237115_((String)property.m_61708_()), Component.m_237115_((String)state.m_61143_(property).toString()).m_130940_(ChatFormatting.AQUA)})));
            }
        }
        if (tileEntity instanceof IMachineBlockEntity) {
            Optional energyCap;
            IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)tileEntity;
            MetaMachine machine = machineBlockEntity.getMetaMachine();
            list.add((Component)Component.m_237115_((String)state.m_60734_().m_7705_()).m_130940_(ChatFormatting.BLUE));
            if (mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_MACHINE_INFO) {
                Optional fluidCap;
                MultiblockMachineDefinition multi;
                MachineDefinition machineDefinition;
                if (machineBlockEntity.getOwner() != null) {
                    machineBlockEntity.getOwner().displayInfo(list);
                }
                if ((machineDefinition = machine.getDefinition()) instanceof MultiblockMachineDefinition && (multi = (MultiblockMachineDefinition)machineDefinition).isAllowExtendedFacing()) {
                    list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                    list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.machine_front_facing", (Object[])new Object[]{machine.getFrontFacing().m_7912_()}));
                    list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.machine_upwards_facing", (Object[])new Object[]{((Direction)machineBlockEntity.self().m_58900_().m_61143_((Property)IMachineBlock.UPWARDS_FACING_PROPERTY)).m_7912_()}));
                }
                if ((fluidCap = tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).resolve()).isPresent()) {
                    list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                    IFluidHandler fluidHandler = (IFluidHandler)fluidCap.get();
                    boolean allTanksEmpty = true;
                    for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                        FluidStack fluidStack = fluidHandler.getFluidInTank(i);
                        if (fluidStack.getFluid() == null || fluidStack.isEmpty()) continue;
                        energyCost += 500;
                        allTanksEmpty = false;
                        list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.tank", (Object[])new Object[]{i, Component.m_237115_((String)FormattingUtil.formatNumbers(fluidStack.getAmount())).m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)FormattingUtil.formatNumbers(fluidHandler.getTankCapacity(i))).m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)fluidStack.getTranslationKey()).m_130940_(ChatFormatting.GOLD)}));
                    }
                    if (allTanksEmpty) {
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.tanks_empty"));
                    }
                }
                if (machine instanceof IMufflableMachine) {
                    IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)machine);
                    energyCost += 500;
                    if (mufflableMachine.isMuffled()) {
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.muffled").m_130940_(ChatFormatting.GREEN));
                    }
                }
            }
            if ((mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_ELECTRICAL_INFO) && (energyCap = tileEntity.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER).resolve()).isPresent()) {
                IEnergyContainer energyContainer = (IEnergyContainer)energyCap.get();
                if (energyContainer.getInputVoltage() > 0L) {
                    list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                    list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.energy_container_in", (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(energyContainer.getInputVoltage())).m_130940_(ChatFormatting.RED), Component.m_237115_((String)GTValues.VN[GTUtil.getTierByVoltage(energyContainer.getInputVoltage())]).m_130940_(ChatFormatting.RED), Component.m_237115_((String)FormattingUtil.formatNumbers(energyContainer.getInputAmperage())).m_130940_(ChatFormatting.RED)}));
                }
                if (energyContainer.getOutputVoltage() > 0L) {
                    list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                    list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.energy_container_out", (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(energyContainer.getOutputVoltage())).m_130940_(ChatFormatting.RED), Component.m_237115_((String)GTValues.VN[GTUtil.getTierByVoltage(energyContainer.getOutputVoltage())]).m_130940_(ChatFormatting.RED), Component.m_237115_((String)FormattingUtil.formatNumbers(energyContainer.getOutputAmperage())).m_130940_(ChatFormatting.RED)}));
                }
                list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.energy_container_storage", (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(energyContainer.getEnergyStored())).m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)FormattingUtil.formatNumbers(energyContainer.getEnergyCapacity())).m_130940_(ChatFormatting.YELLOW)}));
            }
            if (mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_RECIPE_INFO) {
                Optional recipeLogicCap;
                if (machine instanceof IWorkable) {
                    IWorkable workableMachine = (IWorkable)((Object)machine);
                    energyCost += 400;
                    if (!workableMachine.isWorkingEnabled()) {
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.machine_disabled").m_130940_(ChatFormatting.RED));
                    }
                    if (workableMachine.getMaxProgress() > 0) {
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.machine_progress", (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(workableMachine.getProgress())).m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)FormattingUtil.formatNumbers(workableMachine.getMaxProgress())).m_130940_(ChatFormatting.YELLOW)}));
                    }
                }
                if ((recipeLogicCap = tileEntity.getCapability(GTCapability.CAPABILITY_RECIPE_LOGIC).resolve()).isPresent()) {
                    RecipeLogic recipeLogic = (RecipeLogic)recipeLogicCap.get();
                    GTRecipe recipe = recipeLogic.getLastRecipe();
                    if (recipeLogic.getStatus().equals((Object)RecipeLogic.Status.WAITING)) {
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.m_237115_((String)"gtceu.multiblock.waiting"));
                        list.addAll(recipeLogic.getFancyTooltip());
                    } else if (recipe != null) {
                        list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                        long EUt = RecipeHelper.getInputEUt(recipe);
                        boolean isInput = true;
                        if (EUt == 0L) {
                            isInput = false;
                            EUt = RecipeHelper.getOutputEUt(recipe);
                        }
                        list.add((Component)Component.m_237110_((String)(isInput ? "behavior.portable_scanner.workable_consumption" : "behavior.portable_scanner.workable_production"), (Object[])new Object[]{Component.m_237115_((String)FormattingUtil.formatNumbers(EUt)).m_130940_(ChatFormatting.RED), Component.m_237115_((String)FormattingUtil.formatNumbers(1)).m_130940_(ChatFormatting.RED)}));
                    }
                }
            }
            IDataInfoProvider provider = null;
            if (tileEntity instanceof IDataInfoProvider) {
                provider = (IDataInfoProvider)tileEntity;
            } else if (machine instanceof IDataInfoProvider) {
                provider = (IDataInfoProvider)((Object)machine);
            }
            if (provider != null) {
                list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                list.addAll(provider.getDataInfo(mode));
            }
        } else if (tileEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)tileEntity;
            list.add((Component)pipe.getPipeBlock().m_49954_().m_130940_(ChatFormatting.BLUE));
            if (tileEntity instanceof IDataInfoProvider) {
                IDataInfoProvider dataInfoProvider2 = (IDataInfoProvider)tileEntity;
                list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
                list.addAll(dataInfoProvider2.getDataInfo(mode));
            }
            if (tileEntity instanceof FluidPipeBlockEntity) {
                energyCost += 500;
            }
        } else if (tileEntity instanceof IDataInfoProvider) {
            IDataInfoProvider dataInfoProvider3 = (IDataInfoProvider)tileEntity;
            list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
            list.addAll(dataInfoProvider3.getDataInfo(mode));
        } else {
            list.add((Component)Component.m_237115_((String)state.m_60734_().m_7705_()).m_130940_(ChatFormatting.BLUE));
        }
        if ((mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_ENVIRONMENTAL_INFO) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.divider"));
            BedrockFluidVeinSavedData veinData = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
            int chunkX = pos.m_123341_() >> 4;
            int chunkZ = pos.m_123343_() >> 4;
            Fluid fluid = veinData.getFluidInChunk(chunkX, chunkZ);
            if (fluid != null) {
                FluidStack stack = new FluidStack(fluid, veinData.getOperationsRemaining(chunkX, chunkZ));
                double fluidPercent = (double)stack.getAmount() * 100.0 / 100000.0;
                ProspectorMode.FluidInfo fluidInfo = ProspectorMode.FluidInfo.fromVeinWorldEntry(veinData.getFluidVeinWorldEntry(chunkX, chunkZ));
                SPacketProspectBedrockFluid packet = new SPacketProspectBedrockFluid((ResourceKey<Level>)level.m_46472_(), pos, fluidInfo);
                GTNetwork.NETWORK.sendToPlayer((IPacket)packet, (ServerPlayer)player);
                if (player.m_7500_()) {
                    list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.bedrock_fluid.amount", (Object[])new Object[]{Component.m_237115_((String)stack.getTranslationKey()).m_130940_(ChatFormatting.GOLD), Component.m_237115_((String)String.valueOf(veinData.getFluidYield(chunkX, chunkZ))).m_130940_(ChatFormatting.GOLD), Component.m_237115_((String)String.valueOf(fluidPercent)).m_130940_(ChatFormatting.YELLOW)}));
                } else {
                    list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.bedrock_fluid.amount_unknown", (Object[])new Object[]{Component.m_237115_((String)String.valueOf(fluidPercent)).m_130940_(ChatFormatting.YELLOW)}));
                }
            } else {
                list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.bedrock_fluid.nothing"));
            }
            EnvironmentalHazardSavedData environmental = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
            EnvironmentalHazardSavedData.HazardZone environmentHazardZone = environmental.getZoneByContainedPos(pos);
            if (environmentHazardZone != null) {
                list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.environmental_hazard", (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + environmentHazardZone.condition().name)), Component.m_237113_((String)FormattingUtil.formatNumbers(environmentHazardZone.strength()))}));
            } else {
                list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.environmental_hazard.nothing"));
            }
            LocalizedHazardSavedData local = LocalizedHazardSavedData.getOrCreate(serverLevel);
            LocalizedHazardSavedData.HazardZone localHazardZone = local.getZoneByContainedPos(pos);
            if (localHazardZone != null) {
                list.add((Component)Component.m_237110_((String)"behavior.portable_scanner.local_hazard", (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + localHazardZone.condition().name)), Component.m_237113_((String)FormattingUtil.formatNumbers(localHazardZone.strength()))}));
            } else {
                list.add((Component)Component.m_237115_((String)"behavior.portable_scanner.local_hazard.nothing"));
            }
        }
        if (tileEntity instanceof IDataInfoProvider && (debugInfo = (dataInfoProvider = (IDataInfoProvider)tileEntity).getDebugInfo(player, this.debugLevel, mode)) != null) {
            list.addAll(debugInfo);
        }
        return energyCost;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.behavior.mode_switch.tooltip"));
        tooltipComponents.add((Component)Component.m_237110_((String)"behavior.portable_scanner.mode.caption", (Object[])new Object[]{Component.m_237115_((String)this.getMode(stack).getLangKey()).m_130940_(ChatFormatting.AQUA)}));
    }

    public static enum DisplayMode {
        SHOW_ALL("behavior.portable_scanner.mode.show_all_info"),
        SHOW_BLOCK_INFO("behavior.portable_scanner.mode.show_block_info"),
        SHOW_MACHINE_INFO("behavior.portable_scanner.mode.show_machine_info"),
        SHOW_ELECTRICAL_INFO("behavior.portable_scanner.mode.show_electrical_info"),
        SHOW_RECIPE_INFO("behavior.portable_scanner.mode.show_recipe_info"),
        SHOW_ENVIRONMENTAL_INFO("behavior.portable_scanner.mode.show_environmental_info");

        private final String langKey;

        private DisplayMode(String langKey) {
            this.langKey = langKey;
        }

        public String getLangKey() {
            return this.langKey;
        }
    }
}

