/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class DataItemBehavior
implements IInteractionItem,
IAddInformation,
IDataItem {
    private final boolean requireDataBank;

    public DataItemBehavior() {
        this.requireDataBank = false;
    }

    public DataItemBehavior(boolean requireDataBank) {
        this.requireDataBank = requireDataBank;
    }

    @Override
    public boolean requireDataBank() {
        return this.requireDataBank;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Pair<GTRecipeType, String> researchData = ResearchManager.readResearchId(stack);
        if (researchData == null) {
            if (stack.m_41784_().m_128425_("pos", 11) && stack.m_41782_()) {
                int[] posArray = stack.m_41784_().m_128465_("pos");
                tooltipComponents.add((Component)Component.m_237110_((String)"gtceu.tooltip.proxy_bind", (Object[])new Object[]{Component.m_237113_((String)("" + posArray[0])).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237113_((String)("" + posArray[1])).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237113_((String)("" + posArray[2])).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
            }
        } else {
            Collection<GTRecipe> recipes = ((GTRecipeType)researchData.getFirst()).getDataStickEntry((String)researchData.getSecond());
            if (recipes != null && !recipes.isEmpty()) {
                tooltipComponents.add((Component)Component.m_237115_((String)"behavior.data_item.assemblyline.title"));
                ObjectOpenHashSet added = new ObjectOpenHashSet();
                block0: for (GTRecipe recipe : recipes) {
                    ItemStack output = ((Ingredient)ItemRecipeCapability.CAP.of(recipe.getOutputContents(ItemRecipeCapability.CAP).get((int)0).content)).m_43908_()[0];
                    for (ItemStack item : added) {
                        if (!output.m_150930_(item.m_41720_())) continue;
                        continue block0;
                    }
                    if (!added.add(output)) continue;
                    tooltipComponents.add((Component)Component.m_237110_((String)"behavior.data_item.assemblyline.data", (Object[])new Object[]{output.m_41611_()}));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (!(blockEntity instanceof MetaMachineBlockEntity)) return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
        if (!IMachineOwner.canOpenOwnerMachine(context.m_43723_(), blockEntity2)) {
            return InteractionResult.FAIL;
        }
        MetaMachine machine = blockEntity2.getMetaMachine();
        if (!(machine instanceof IDataStickInteractable)) return InteractionResult.PASS;
        IDataStickInteractable interactable = (IDataStickInteractable)((Object)machine);
        if (!context.m_7078_()) return interactable.onDataStickUse(context.m_43723_(), itemStack);
        if (ResearchManager.readResearchId(itemStack) != null) return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        return interactable.onDataStickShiftUse(context.m_43723_(), itemStack);
    }
}

