/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.math.IntMath;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.DiodeRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.MaintenanceHatchPartRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.MinerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.PumpHatchPartRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.QuantumChestRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.QuantumTankRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.RotorHolderMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SteamMinerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorldAcceleratorRenderer;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GCYMMachines;
import com.gregtechceu.gtceu.common.data.machines.GTAEMachines;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.common.data.machines.GTResearchMachines;
import com.gregtechceu.gtceu.common.machine.electric.AirScrubberMachine;
import com.gregtechceu.gtceu.common.machine.electric.BlockBreakerMachine;
import com.gregtechceu.gtceu.common.machine.electric.FisherMachine;
import com.gregtechceu.gtceu.common.machine.electric.HullMachine;
import com.gregtechceu.gtceu.common.machine.electric.ItemCollectorMachine;
import com.gregtechceu.gtceu.common.machine.electric.MinerMachine;
import com.gregtechceu.gtceu.common.machine.electric.PumpMachine;
import com.gregtechceu.gtceu.common.machine.electric.RockCrusherMachine;
import com.gregtechceu.gtceu.common.machine.electric.WorldAcceleratorMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.AutoMaintenanceHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.CleaningMaintenanceHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.CokeOvenHatch;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DiodePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DualHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.MaintenanceHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.MufflerPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.PumpHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ReservoirHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.RotorHolderPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamItemBusPartMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamLiquidBoilerMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamMinerMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamSolarBoiler;
import com.gregtechceu.gtceu.common.machine.steam.SteamSolidBoilerMachine;
import com.gregtechceu.gtceu.common.machine.storage.BufferMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeComputationProviderMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeEnergyContainerMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeTankMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidEndpointMachine;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemEndpointMachine;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryInfo;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModLoader;

public class GTMachines {
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_SOLID_BOILER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_LIQUID_BOILER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_SOLAR_BOILER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_EXTRACTOR;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_MACERATOR;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_COMPRESSOR;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_HAMMER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_FURNACE;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_ALLOY_SMELTER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_ROCK_CRUSHER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_MINER;
    public static final MachineDefinition[] HULL;
    public static final MachineDefinition[] ELECTRIC_FURNACE;
    public static final MachineDefinition[] ALLOY_SMELTER;
    public static final MachineDefinition[] ARC_FURNACE;
    public static final MachineDefinition[] ASSEMBLER;
    public static final MachineDefinition[] AUTOCLAVE;
    public static final MachineDefinition[] BENDER;
    public static final MachineDefinition[] BREWERY;
    public static final MachineDefinition[] CANNER;
    public static final MachineDefinition[] CENTRIFUGE;
    public static final MachineDefinition[] CHEMICAL_BATH;
    public static final MachineDefinition[] CHEMICAL_REACTOR;
    public static final MachineDefinition[] COMPRESSOR;
    public static final MachineDefinition[] CUTTER;
    public static final MachineDefinition[] DISTILLERY;
    public static final MachineDefinition[] ELECTROLYZER;
    public static final MachineDefinition[] ELECTROMAGNETIC_SEPARATOR;
    public static final MachineDefinition[] EXTRACTOR;
    public static final MachineDefinition[] EXTRUDER;
    public static final MachineDefinition[] FERMENTER;
    public static final MachineDefinition[] FLUID_HEATER;
    public static final MachineDefinition[] FLUID_SOLIDIFIER;
    public static final MachineDefinition[] FORGE_HAMMER;
    public static final MachineDefinition[] FORMING_PRESS;
    public static final MachineDefinition[] LATHE;
    public static final MachineDefinition[] SCANNER;
    public static final MachineDefinition[] MIXER;
    public static final MachineDefinition[] ORE_WASHER;
    public static final MachineDefinition[] PACKER;
    public static final MachineDefinition[] POLARIZER;
    public static final MachineDefinition[] LASER_ENGRAVER;
    public static final MachineDefinition[] SIFTER;
    public static final MachineDefinition[] THERMAL_CENTRIFUGE;
    public static final MachineDefinition[] WIREMILL;
    public static final MachineDefinition[] CIRCUIT_ASSEMBLER;
    public static final MachineDefinition[] MACERATOR;
    public static final MachineDefinition[] GAS_COLLECTOR;
    public static final MachineDefinition[] ROCK_CRUSHER;
    public static final MachineDefinition[] AIR_SCRUBBER;
    public static final MachineDefinition[] COMBUSTION;
    public static final MachineDefinition[] STEAM_TURBINE;
    public static final MachineDefinition[] GAS_TURBINE;
    public static final MachineDefinition[] TRANSFORMER;
    public static final MachineDefinition[] HI_AMP_TRANSFORMER_2A;
    public static final MachineDefinition[] HI_AMP_TRANSFORMER_4A;
    public static final MachineDefinition[] POWER_TRANSFORMER;
    public static final MachineDefinition[] ENERGY_CONVERTER_1A;
    public static final MachineDefinition[] ENERGY_CONVERTER_4A;
    public static final MachineDefinition[] ENERGY_CONVERTER_8A;
    public static final MachineDefinition[] ENERGY_CONVERTER_16A;
    public static final MachineDefinition LONG_DIST_ITEM_ENDPOINT;
    public static final MachineDefinition LONG_DIST_FLUID_ENDPOINT;
    public static final MachineDefinition[] BATTERY_BUFFER_4;
    public static final MachineDefinition[] BATTERY_BUFFER_8;
    public static final MachineDefinition[] BATTERY_BUFFER_16;
    public static final MachineDefinition[] CHARGER_4;
    public static final MachineDefinition[] PUMP;
    public static final MachineDefinition[] FISHER;
    public static final MachineDefinition[] BLOCK_BREAKER;
    public static final MachineDefinition[] MINER;
    public static final MachineDefinition[] WORLD_ACCELERATOR;
    public static final MachineDefinition[] ITEM_COLLECTOR;
    public static final MachineDefinition[] BUFFER;
    public static final BiConsumer<ItemStack, List<Component>> CREATIVE_TOOLTIPS;
    public static final MachineDefinition CREATIVE_ENERGY;
    public static final MachineDefinition CREATIVE_COMPUTATION_PROVIDER;
    public static final MachineDefinition CREATIVE_FLUID;
    public static final MachineDefinition CREATIVE_ITEM;
    public static BiConsumer<ItemStack, List<Component>> CHEST_TOOLTIPS;
    public static final MachineDefinition[] SUPER_CHEST;
    public static final MachineDefinition[] QUANTUM_CHEST;
    public static final MachineDefinition[] SUPER_TANK;
    public static final MachineDefinition[] QUANTUM_TANK;
    public static MachineDefinition WOODEN_CRATE;
    public static MachineDefinition BRONZE_CRATE;
    public static MachineDefinition STEEL_CRATE;
    public static MachineDefinition ALUMINIUM_CRATE;
    public static MachineDefinition STAINLESS_STEEL_CRATE;
    public static MachineDefinition TITANIUM_CRATE;
    public static MachineDefinition TUNGSTENSTEEL_CRATE;
    public static MachineDefinition WOODEN_DRUM;
    public static MachineDefinition BRONZE_DRUM;
    public static MachineDefinition STEEL_DRUM;
    public static MachineDefinition ALUMINIUM_DRUM;
    public static MachineDefinition STAINLESS_STEEL_DRUM;
    public static MachineDefinition GOLD_DRUM;
    public static MachineDefinition TITANIUM_DRUM;
    public static MachineDefinition TUNGSTENSTEEL_DRUM;
    public static final MachineDefinition[] ITEM_IMPORT_BUS;
    public static final MachineDefinition[] ITEM_EXPORT_BUS;
    public static final MachineDefinition[] FLUID_IMPORT_HATCH;
    public static final MachineDefinition[] FLUID_IMPORT_HATCH_4X;
    public static final MachineDefinition[] FLUID_IMPORT_HATCH_9X;
    public static final MachineDefinition[] FLUID_EXPORT_HATCH;
    public static final MachineDefinition[] FLUID_EXPORT_HATCH_4X;
    public static final MachineDefinition[] FLUID_EXPORT_HATCH_9X;
    public static final MachineDefinition[] ENERGY_INPUT_HATCH;
    public static final MachineDefinition[] ENERGY_OUTPUT_HATCH;
    public static final MachineDefinition[] ENERGY_INPUT_HATCH_4A;
    public static final MachineDefinition[] ENERGY_OUTPUT_HATCH_4A;
    public static final MachineDefinition[] ENERGY_INPUT_HATCH_16A;
    public static final MachineDefinition[] ENERGY_OUTPUT_HATCH_16A;
    public static final MachineDefinition[] SUBSTATION_ENERGY_INPUT_HATCH;
    public static final MachineDefinition[] SUBSTATION_ENERGY_OUTPUT_HATCH;
    public static final MachineDefinition[] MUFFLER_HATCH;
    public static final MachineDefinition STEAM_IMPORT_BUS;
    public static final MachineDefinition STEAM_EXPORT_BUS;
    public static final MachineDefinition STEAM_HATCH;
    public static final MachineDefinition COKE_OVEN_HATCH;
    public static final MachineDefinition PUMP_HATCH;
    public static final MachineDefinition MAINTENANCE_HATCH;
    public static final MachineDefinition CONFIGURABLE_MAINTENANCE_HATCH;
    public static final MachineDefinition CLEANING_MAINTENANCE_HATCH;
    public static final MachineDefinition AUTO_MAINTENANCE_HATCH;
    public static final MachineDefinition[] ITEM_PASSTHROUGH_HATCH;
    public static final MachineDefinition[] FLUID_PASSTHROUGH_HATCH;
    public static final MachineDefinition RESERVOIR_HATCH;
    public static final MachineDefinition[] DUAL_IMPORT_HATCH;
    public static final MachineDefinition[] DUAL_EXPORT_HATCH;
    public static final MachineDefinition[] DIODE;
    public static final MachineDefinition[] ROTOR_HOLDER;
    public static final MachineDefinition[] LASER_INPUT_HATCH_256;
    public static final MachineDefinition[] LASER_OUTPUT_HATCH_256;
    public static final MachineDefinition[] LASER_INPUT_HATCH_1024;
    public static final MachineDefinition[] LASER_OUTPUT_HATCH_1024;
    public static final MachineDefinition[] LASER_INPUT_HATCH_4096;
    public static final MachineDefinition[] LASER_OUTPUT_HATCH_4096;

    public static void init() {
        GTMultiMachines.init();
        GCYMMachines.init();
        GTResearchMachines.init();
        if (GTCEu.Mods.isAE2Loaded()) {
            GTAEMachines.init();
        }
        if (GTCEu.Mods.isKubeJSLoaded()) {
            GTRegistryInfo.registerFor(GTRegistries.MACHINES.getRegistryName());
        }
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.MACHINES, MachineDefinition.class));
        GTRegistries.MACHINES.freeze();
    }

    public static MachineDefinition get(String name) {
        return (MachineDefinition)GTRegistries.MACHINES.get(GTCEu.id(name));
    }

    static {
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MACHINE);
        GTRegistries.MACHINES.unfreeze();
        STEAM_SOLID_BOILER = GTMachineUtils.registerSteamMachines("steam_solid_boiler", (x$0, x$1) -> new SteamSolidBoilerMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.ALL).recipeType(GTRecipeTypes.STEAM_BOILER_RECIPES).recipeModifier(SteamBoilerMachine::recipeModifier).workableSteamHullRenderer((boolean)pressure, GTCEu.id("block/generators/boiler/coal")).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{(pressure != false ? ConfigHolder.INSTANCE.machines.smallBoilers.hpSolidBoilerBaseOutput : ConfigHolder.INSTANCE.machines.smallBoilers.solidBoilerBaseOutput) * 1000 / 20000})}).register());
        STEAM_LIQUID_BOILER = GTMachineUtils.registerSteamMachines("steam_liquid_boiler", (x$0, x$1) -> new SteamLiquidBoilerMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.ALL).recipeType(GTRecipeTypes.STEAM_BOILER_RECIPES).recipeModifier(SteamBoilerMachine::recipeModifier).workableSteamHullRenderer((boolean)pressure, GTCEu.id("block/generators/boiler/lava")).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{(pressure != false ? ConfigHolder.INSTANCE.machines.smallBoilers.hpLiquidBoilerBaseOutput : ConfigHolder.INSTANCE.machines.smallBoilers.liquidBoilerBaseOutput) * 1000 / 20000})}).register());
        STEAM_SOLAR_BOILER = GTMachineUtils.registerSteamMachines("steam_solar_boiler", (x$0, x$1) -> new SteamSolarBoiler((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.STEAM_BOILER_RECIPES).recipeModifier(SteamBoilerMachine::recipeModifier).workableSteamHullRenderer((boolean)pressure, GTCEu.id("block/generators/boiler/solar")).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{(pressure != false ? ConfigHolder.INSTANCE.machines.smallBoilers.hpSolarBoilerBaseOutput : ConfigHolder.INSTANCE.machines.smallBoilers.solarBoilerBaseOutput) * 1000 / 20000})}).register());
        STEAM_EXTRACTOR = GTMachineUtils.registerSimpleSteamMachines("extractor", GTRecipeTypes.EXTRACTOR_RECIPES);
        STEAM_MACERATOR = GTMachineUtils.registerSteamMachines("steam_macerator", (x$0, x$1) -> new SimpleSteamMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.MACERATOR_RECIPES).recipeModifier(SimpleSteamMachine::recipeModifier).addOutputLimit(ItemRecipeCapability.CAP, 1).renderer(() -> new WorkableSteamMachineRenderer((boolean)pressure, GTCEu.id("block/machines/macerator"))).register());
        STEAM_COMPRESSOR = GTMachineUtils.registerSimpleSteamMachines("compressor", GTRecipeTypes.COMPRESSOR_RECIPES);
        STEAM_HAMMER = GTMachineUtils.registerSimpleSteamMachines("forge_hammer", GTRecipeTypes.FORGE_HAMMER_RECIPES);
        STEAM_FURNACE = GTMachineUtils.registerSimpleSteamMachines("furnace", GTRecipeTypes.FURNACE_RECIPES);
        STEAM_ALLOY_SMELTER = GTMachineUtils.registerSimpleSteamMachines("alloy_smelter", GTRecipeTypes.ALLOY_SMELTER_RECIPES);
        STEAM_ROCK_CRUSHER = GTMachineUtils.registerSimpleSteamMachines("rock_crusher", GTRecipeTypes.ROCK_BREAKER_RECIPES);
        STEAM_MINER = GTMachineUtils.registerSteamMachines("steam_miner", (holder, isHP) -> isHP != false ? new SteamMinerMachine((IMachineBlockEntity)holder, true, 240, 6, 0, 32) : new SteamMinerMachine((IMachineBlockEntity)holder, false, 320, 4, 0, 16), (isHP, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.DUMMY_RECIPES).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.uses_per_tick_steam", (Object[])new Object[]{isHP != false ? 32 : 16}).m_130946_(ChatFormatting.GRAY + ", ").m_7220_((Component)Component.m_237110_((String)"gtceu.machine.miner.per_block", (Object[])new Object[]{isHP != false ? 12 : 14}))}).tooltipBuilder((item, tooltip) -> {
            int maxArea = IMiner.getWorkingArea(isHP != false ? 6 : 4);
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{maxArea, maxArea}));
        }).renderer(() -> new SteamMinerRenderer((boolean)isHP, isHP != false ? GTCEu.id("block/machines/high_pressure_steam_miner") : GTCEu.id("block/machines/steam_miner"))).register());
        HULL = GTMachineUtils.registerTieredMachines("machine_hull", HullMachine::new, (tier, builder) -> builder.rotationState(RotationState.ALL).overlayTieredHullRenderer("hull").abilities(PartAbility.PASSTHROUGH_HATCH).langValue("%s \u00a7fMachine Hull".formatted(GTValues.VNF[tier])).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.hull.tooltip")}).register(), GTMachineUtils.ALL_TIERS);
        ELECTRIC_FURNACE = GTMachineUtils.registerSimpleMachines("electric_furnace", GTRecipeTypes.FURNACE_RECIPES);
        ALLOY_SMELTER = GTMachineUtils.registerSimpleMachines("alloy_smelter", GTRecipeTypes.ALLOY_SMELTER_RECIPES);
        ARC_FURNACE = GTMachineUtils.registerSimpleMachines("arc_furnace", GTRecipeTypes.ARC_FURNACE_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        ASSEMBLER = GTMachineUtils.registerSimpleMachines("assembler", GTRecipeTypes.ASSEMBLER_RECIPES, GTMachineUtils.hvCappedTankSizeFunction, true);
        AUTOCLAVE = GTMachineUtils.registerSimpleMachines("autoclave", GTRecipeTypes.AUTOCLAVE_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        BENDER = GTMachineUtils.registerSimpleMachines("bender", GTRecipeTypes.BENDER_RECIPES);
        BREWERY = GTMachineUtils.registerSimpleMachines("brewery", GTRecipeTypes.BREWING_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        CANNER = GTMachineUtils.registerSimpleMachines("canner", GTRecipeTypes.CANNER_RECIPES);
        CENTRIFUGE = GTMachineUtils.registerSimpleMachines("centrifuge", GTRecipeTypes.CENTRIFUGE_RECIPES, GTMachineUtils.largeTankSizeFunction);
        CHEMICAL_BATH = GTMachineUtils.registerSimpleMachines("chemical_bath", GTRecipeTypes.CHEMICAL_BATH_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        CHEMICAL_REACTOR = GTMachineUtils.registerSimpleMachines("chemical_reactor", GTRecipeTypes.CHEMICAL_RECIPES, tier -> 16000, true);
        COMPRESSOR = GTMachineUtils.registerSimpleMachines("compressor", GTRecipeTypes.COMPRESSOR_RECIPES);
        CUTTER = GTMachineUtils.registerSimpleMachines("cutter", GTRecipeTypes.CUTTER_RECIPES);
        DISTILLERY = GTMachineUtils.registerSimpleMachines("distillery", GTRecipeTypes.DISTILLERY_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        ELECTROLYZER = GTMachineUtils.registerSimpleMachines("electrolyzer", GTRecipeTypes.ELECTROLYZER_RECIPES, GTMachineUtils.largeTankSizeFunction);
        ELECTROMAGNETIC_SEPARATOR = GTMachineUtils.registerSimpleMachines("electromagnetic_separator", GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES);
        EXTRACTOR = GTMachineUtils.registerSimpleMachines("extractor", GTRecipeTypes.EXTRACTOR_RECIPES);
        EXTRUDER = GTMachineUtils.registerSimpleMachines("extruder", GTRecipeTypes.EXTRUDER_RECIPES);
        FERMENTER = GTMachineUtils.registerSimpleMachines("fermenter", GTRecipeTypes.FERMENTING_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        FLUID_HEATER = GTMachineUtils.registerSimpleMachines("fluid_heater", GTRecipeTypes.FLUID_HEATER_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        FLUID_SOLIDIFIER = GTMachineUtils.registerSimpleMachines("fluid_solidifier", GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        FORGE_HAMMER = GTMachineUtils.registerSimpleMachines("forge_hammer", GTRecipeTypes.FORGE_HAMMER_RECIPES);
        FORMING_PRESS = GTMachineUtils.registerSimpleMachines("forming_press", GTRecipeTypes.FORMING_PRESS_RECIPES);
        LATHE = GTMachineUtils.registerSimpleMachines("lathe", GTRecipeTypes.LATHE_RECIPES);
        SCANNER = GTMachineUtils.registerSimpleMachines("scanner", GTRecipeTypes.SCANNER_RECIPES);
        MIXER = GTMachineUtils.registerSimpleMachines("mixer", GTRecipeTypes.MIXER_RECIPES, GTMachineUtils.hvCappedTankSizeFunction);
        ORE_WASHER = GTMachineUtils.registerSimpleMachines("ore_washer", GTRecipeTypes.ORE_WASHER_RECIPES);
        PACKER = GTMachineUtils.registerSimpleMachines("packer", GTRecipeTypes.PACKER_RECIPES);
        POLARIZER = GTMachineUtils.registerSimpleMachines("polarizer", GTRecipeTypes.POLARIZER_RECIPES);
        LASER_ENGRAVER = GTMachineUtils.registerSimpleMachines("laser_engraver", GTRecipeTypes.LASER_ENGRAVER_RECIPES, GTMachineUtils.defaultTankSizeFunction, true);
        SIFTER = GTMachineUtils.registerSimpleMachines("sifter", GTRecipeTypes.SIFTER_RECIPES);
        THERMAL_CENTRIFUGE = GTMachineUtils.registerSimpleMachines("thermal_centrifuge", GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES);
        WIREMILL = GTMachineUtils.registerSimpleMachines("wiremill", GTRecipeTypes.WIREMILL_RECIPES);
        CIRCUIT_ASSEMBLER = GTMachineUtils.registerSimpleMachines("circuit_assembler", GTRecipeTypes.CIRCUIT_ASSEMBLER_RECIPES, GTMachineUtils.hvCappedTankSizeFunction, true);
        MACERATOR = GTMachineUtils.registerTieredMachines("macerator", (holder, tier) -> new SimpleTieredMachine((IMachineBlockEntity)holder, (int)tier, GTMachineUtils.defaultTankSizeFunction, new Object[0]), (tier, builder) -> {
            MachineBuilder machineBuilder = builder.langValue("%s Macerator %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("macerator"), GTRecipeTypes.MACERATOR_RECIPES)).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.MACERATOR_RECIPES);
            return machineBuilder.addOutputLimit(ItemRecipeCapability.CAP, switch (tier) {
                case 1, 2 -> 1;
                case 3 -> 3;
                default -> 4;
            }).recipeModifier(GTRecipeModifiers.OC_NON_PERFECT).workableTieredHullRenderer(GTCEu.id("block/machines/macerator")).tooltips(GTMachineUtils.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, GTRecipeTypes.MACERATOR_RECIPES, ((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), true)).register();
        }, GTMachineUtils.ELECTRIC_TIERS);
        GAS_COLLECTOR = GTMachineUtils.registerSimpleMachines("gas_collector", GTRecipeTypes.GAS_COLLECTOR_RECIPES, GTMachineUtils.largeTankSizeFunction, true);
        ROCK_CRUSHER = GTMachineUtils.registerTieredMachines("rock_crusher", (x$0, x$1) -> new RockCrusherMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Rock Crusher %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("rock_crusher"), GTRecipeTypes.ROCK_BREAKER_RECIPES)).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.ROCK_BREAKER_RECIPES).recipeModifier(GTRecipeModifiers.OC_NON_PERFECT).workableTieredHullRenderer(GTCEu.id("block/machines/rock_crusher")).tooltips(GTMachineUtils.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, GTRecipeTypes.ROCK_BREAKER_RECIPES, ((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), true)).tooltips(GTMachineUtils.explosion()).register(), GTMachineUtils.ELECTRIC_TIERS);
        AIR_SCRUBBER = GTMachineUtils.registerTieredMachines("air_scrubber", (x$0, x$1) -> new AirScrubberMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Air Scrubber %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("air_scrubber"), GTRecipeTypes.AIR_SCRUBBER_RECIPES)).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.AIR_SCRUBBER_RECIPES).recipeModifier(GTRecipeModifiers.OC_NON_PERFECT).workableTieredHullRenderer(GTCEu.id("block/machines/air_scrubber")).tooltips(GTMachineUtils.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, GTRecipeTypes.AIR_SCRUBBER_RECIPES, ((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), true)).tooltips(GTMachineUtils.explosion()).register(), GTMachineUtils.LOW_TIERS);
        COMBUSTION = GTMachineUtils.registerSimpleGenerator("combustion", GTRecipeTypes.COMBUSTION_GENERATOR_FUELS, GTMachineUtils.genericGeneratorTankSizeFunction, 0.1f, 1, 2, 3);
        STEAM_TURBINE = GTMachineUtils.registerSimpleGenerator("steam_turbine", GTRecipeTypes.STEAM_TURBINE_FUELS, GTMachineUtils.steamGeneratorTankSizeFunction, 0.0f, 1, 2, 3);
        GAS_TURBINE = GTMachineUtils.registerSimpleGenerator("gas_turbine", GTRecipeTypes.GAS_TURBINE_FUELS, GTMachineUtils.genericGeneratorTankSizeFunction, 0.1f, 1, 2, 3);
        TRANSFORMER = GTMachineUtils.registerTransformerMachines("", 1);
        HI_AMP_TRANSFORMER_2A = GTMachineUtils.registerTransformerMachines("Hi-Amp (2x) ", 2);
        HI_AMP_TRANSFORMER_4A = GTMachineUtils.registerTransformerMachines("Hi-Amp (4x) ", 4);
        POWER_TRANSFORMER = GTMachineUtils.registerTransformerMachines("Power ", 16);
        ENERGY_CONVERTER_1A = GTMachineUtils.registerConverter(1);
        ENERGY_CONVERTER_4A = GTMachineUtils.registerConverter(4);
        ENERGY_CONVERTER_8A = GTMachineUtils.registerConverter(8);
        ENERGY_CONVERTER_16A = GTMachineUtils.registerConverter(16);
        LONG_DIST_ITEM_ENDPOINT = GTRegistration.REGISTRATE.machine("long_distance_item_pipeline_endpoint", LDItemEndpointMachine::new).langValue("Long Distance Item Pipeline Endpoint").rotationState(RotationState.ALL).tier(1).tieredHullRenderer(GTCEu.id("block/machine/ld_item_endpoint_machine")).tooltips((Component[])LangHandler.getMultiLang("gtceu.machine.endpoint.tooltip").toArray(Component[]::new)).tooltipBuilder((stack, tooltip) -> {
            if (ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance > 0) {
                tooltip.add(Component.m_237110_((String)"gtceu.machine.endpoint.tooltip.min_length", (Object[])new Object[]{ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance}));
            }
        }).register();
        LONG_DIST_FLUID_ENDPOINT = GTRegistration.REGISTRATE.machine("long_distance_fluid_pipeline_endpoint", LDFluidEndpointMachine::new).langValue("Long Distance Fluid Pipeline Endpoint").rotationState(RotationState.ALL).tier(1).tieredHullRenderer(GTCEu.id("block/machine/ld_fluid_endpoint_machine")).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.endpoint.tooltip.0"), Component.m_237115_((String)"gtceu.machine.endpoint.tooltip.1"), Component.m_237115_((String)"gtceu.machine.endpoint.tooltip.2")}).tooltipBuilder((stack, tooltip) -> {
            if (ConfigHolder.INSTANCE.machines.ldFluidPipeMinDistance > 0) {
                tooltip.add(Component.m_237110_((String)"gtceu.machine.endpoint.tooltip.min_length", (Object[])new Object[]{ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance}));
            }
        }).register();
        BATTERY_BUFFER_4 = GTMachineUtils.registerBatteryBuffer(4);
        BATTERY_BUFFER_8 = GTMachineUtils.registerBatteryBuffer(8);
        BATTERY_BUFFER_16 = GTMachineUtils.registerBatteryBuffer(16);
        CHARGER_4 = GTMachineUtils.registerCharger(4);
        PUMP = GTMachineUtils.registerTieredMachines("pump", (x$0, x$1) -> new PumpMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).tieredHullRenderer(GTCEu.id("block/machine/pump_machine")).langValue("%s Pump %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.pump.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier] * 64L)}), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(16000 * Math.max(1, tier))}), Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{PumpMachine.getMaxPumpRadius(tier) * 2, PumpMachine.getMaxPumpRadius(tier) * 2})}).register(), 1, 2, 3, 4);
        FISHER = GTMachineUtils.registerTieredMachines("fisher", (x$0, x$1) -> new FisherMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).editableUI(FisherMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("fisher"), (tier + 1) * (tier + 1))).tieredHullRenderer(GTCEu.id("block/machine/fisher_machine")).langValue("%s Fisher %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.fisher.tooltip"), Component.m_237110_((String)"gtceu.machine.fisher.speed", (Object[])new Object[]{FisherMachine.calcMaxProgress(tier)}), Component.m_237110_((String)"gtceu.machine.fisher.requirement", (Object[])new Object[]{5, 5}), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier] * 64L)})}).register(), 1, 2, 3, 4, 5, 6);
        BLOCK_BREAKER = GTMachineUtils.registerTieredMachines("block_breaker", (x$0, x$1) -> new BlockBreakerMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).editableUI(BlockBreakerMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("block_breaker"), (tier + 1) * (tier + 1))).tieredHullRenderer(GTCEu.id("block/machine/block_breaker_machine")).langValue("%s Block Breaker %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.block_breaker.tooltip"), Component.m_237110_((String)"gtceu.machine.block_breaker.speed_bonus", (Object[])new Object[]{(int)(BlockBreakerMachine.getEfficiencyMultiplier(tier) * 100.0f)}), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier] * 64L)})}).register(), 1, 2, 3, 4);
        MINER = GTMachineUtils.registerTieredMachines("miner", (holder, tier) -> new MinerMachine((IMachineBlockEntity)holder, (int)tier, 320 / (tier * 2), tier * 8, (int)tier, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).langValue("%s Miner %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(GTRecipeTypes.DUMMY_RECIPES).editableUI(MinerMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("miner"), (tier + 1) * (tier + 1))).renderer(() -> new MinerRenderer((int)tier, GTCEu.id("block/machines/miner"))).tooltipBuilder((stack, tooltip) -> {
            int maxArea = IMiner.getWorkingArea(tier * 8);
            long energyPerTick = GTValues.V[tier - 1];
            int tickSpeed = 320 / (tier * 2);
            tooltip.add(Component.m_237110_((String)"gtceu.machine.miner.tooltip", (Object[])new Object[]{maxArea, maxArea}));
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.uses_per_tick", (Object[])new Object[]{energyPerTick}).m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237110_((String)"gtceu.machine.miner.per_block", (Object[])new Object[]{tickSpeed / 20})));
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}));
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier] * 64L)}));
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.working_area_max", (Object[])new Object[]{maxArea, maxArea}));
        }).register(), 1, 2, 3);
        WORLD_ACCELERATOR = GTMachineUtils.registerTieredMachines("world_accelerator", (x$0, x$1) -> new WorldAcceleratorMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NONE).langValue("%s World Accelerator %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(GTRecipeTypes.DUMMY_RECIPES).renderer(() -> new WorldAcceleratorRenderer((int)tier, GTCEu.id("block/machines/world_accelerator_te"), GTCEu.id("block/machines/world_accelerator"))).tooltipBuilder((stack, tooltip) -> {
            int randTickWorkingArea = 3 + (tier - 1) * 2;
            tooltip.add(Component.m_237115_((String)"gtceu.machine.world_accelerator.description"));
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}));
            tooltip.add(Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier] * 64L)}));
            tooltip.add(Component.m_237115_((String)"gtceu.machine.world_accelerator.working_area"));
            tooltip.add(Component.m_237115_((String)"gtceu.machine.world_accelerator.working_area_tile"));
            tooltip.add(Component.m_237110_((String)"gtceu.machine.world_accelerator.working_area_random", (Object[])new Object[]{randTickWorkingArea, randTickWorkingArea}));
        }).register(), 1, 2, 3, 4, 5, 6, 7, 8);
        ITEM_COLLECTOR = GTMachineUtils.registerTieredMachines("item_collector", (x$0, x$1) -> new ItemCollectorMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NONE).langValue("%s Item Collector %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(GTRecipeTypes.DUMMY_RECIPES).editableUI(ItemCollectorMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("item_collector"), ItemCollectorMachine.getINVENTORY_SIZES()[tier])).renderer(() -> new WorkableTieredHullMachineRenderer((int)tier, GTCEu.id("block/machines/item_collector"))).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_collector.tooltip"), Component.m_237110_((String)"gtceu.machine.item_collector.gui.collect_range", (Object[])new Object[]{IntMath.pow((int)2, (int)(tier + 2)), IntMath.pow((int)2, (int)(tier + 2))}), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier] * 64L)})}).register(), 1, 2, 3, 4);
        BUFFER = GTMachineUtils.registerTieredMachines("buffer", (x$0, x$1) -> new BufferMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Buffer %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.NONE).tieredHullRenderer(GTCEu.id("block/machine/buffer")).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.buffer.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{BufferMachine.getInventorySize(tier)}), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{BufferMachine.getTankSize(tier), 64000})}).register(), 1, 2, 3);
        CREATIVE_TOOLTIPS = (stack, list) -> list.add(Component.m_237115_((String)"gtceu.creative_tooltip.1").m_7220_((Component)Component.m_237115_((String)"gtceu.creative_tooltip.2").m_130938_(TooltipHelper.RAINBOW_HSL_SLOW)).m_7220_((Component)Component.m_237115_((String)"gtceu.creative_tooltip.3")));
        CREATIVE_ENERGY = GTRegistration.REGISTRATE.machine("creative_energy", CreativeEnergyContainerMachine::new).rotationState(RotationState.NONE).tooltipBuilder(CREATIVE_TOOLTIPS).register();
        CREATIVE_COMPUTATION_PROVIDER = GTRegistration.REGISTRATE.machine("creative_computation_provider", CreativeComputationProviderMachine::new).rotationState(RotationState.NONE).tooltipBuilder(CREATIVE_TOOLTIPS).register();
        CREATIVE_FLUID = GTRegistration.REGISTRATE.machine("creative_tank", CreativeTankMachine::new).rotationState(RotationState.ALL).tooltipBuilder((stack, list) -> {
            CREATIVE_TOOLTIPS.accept((ItemStack)stack, (List<Component>)list);
            if (stack.m_41782_()) {
                FluidStack f = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41698_("stored"));
                int perCycle = stack.m_41784_().m_128451_("mBPerCycle");
                list.add(1, Component.m_237110_((String)"gtceu.universal.tooltip.fluid_stored", (Object[])new Object[]{f.getDisplayName(), FormattingUtil.formatNumbers(perCycle)}));
            }
        }).renderer(() -> new QuantumTankRenderer(14, GTCEu.id("block/machine/creative_tank"))).hasTESR(true).register();
        CREATIVE_ITEM = GTRegistration.REGISTRATE.machine("creative_chest", CreativeChestMachine::new).rotationState(RotationState.ALL).tooltipBuilder((stack, list) -> {
            CREATIVE_TOOLTIPS.accept((ItemStack)stack, (List<Component>)list);
            if (stack.m_41782_()) {
                ItemStack i = ItemStack.m_41712_((CompoundTag)stack.m_41698_("stored"));
                int perCycle = stack.m_41784_().m_128451_("itemsPerCycle");
                list.add(1, Component.m_237110_((String)"gtceu.universal.tooltip.item_stored", (Object[])new Object[]{i.m_41786_(), FormattingUtil.formatNumbers(perCycle)}));
            }
        }).renderer(() -> new QuantumChestRenderer(14, GTCEu.id("block/machine/creative_chest"))).hasTESR(true).register();
        CHEST_TOOLTIPS = (stack, list) -> {
            if (stack.m_41782_()) {
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack.m_41698_("stored"));
                long storedAmount = stack.m_41784_().m_128454_("storedAmount");
                list.add(1, Component.m_237110_((String)"gtceu.universal.tooltip.item_stored", (Object[])new Object[]{itemStack.m_41786_(), FormattingUtil.formatNumbers(storedAmount)}));
            }
        };
        SUPER_CHEST = GTMachineUtils.registerTieredMachines("super_chest", (holder, tier) -> new QuantumChestMachine((IMachineBlockEntity)holder, (int)tier, 4000000L * (long)Math.pow(2.0, tier - 1), new Object[0]), (tier, builder) -> builder.langValue("Super Chest " + GTValues.LVT[tier]).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).rotationState(RotationState.ALL).renderer(() -> new QuantumChestRenderer((int)tier)).hasTESR(true).tooltipBuilder(CHEST_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_chest.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_total", (Object[])new Object[]{FormattingUtil.formatNumbers(4000000L * (long)Math.pow(2.0, tier - 1))})}).register(), GTMachineUtils.LOW_TIERS);
        QUANTUM_CHEST = GTMachineUtils.registerTieredMachines("quantum_chest", (holder, tier) -> new QuantumChestMachine((IMachineBlockEntity)holder, (int)tier, tier == 14 ? Long.MAX_VALUE : 4000000L * (long)Math.pow(2.0, tier - 1), new Object[0]), (tier, builder) -> builder.langValue("Quantum Chest " + GTValues.LVT[tier]).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).rotationState(RotationState.ALL).renderer(() -> new QuantumChestRenderer((int)tier)).hasTESR(true).tooltipBuilder(CHEST_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_chest.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_total", (Object[])new Object[]{FormattingUtil.formatNumbers(4000000L * (long)Math.pow(2.0, tier - 1))})}).register(), GTMachineUtils.HIGH_TIERS);
        SUPER_TANK = GTMachineUtils.registerTieredMachines("super_tank", (holder, tier) -> new QuantumTankMachine((IMachineBlockEntity)holder, (int)tier, 4000000L * (long)Math.pow(2.0, tier - 1), new Object[0]), (tier, builder) -> builder.langValue("Super Tank " + GTValues.LVT[tier]).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).rotationState(RotationState.ALL).renderer(() -> new QuantumTankRenderer((int)tier)).hasTESR(true).tooltipBuilder(GTMachineUtils.TANK_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(4000000L * (long)Math.pow(2.0, tier - 1))})}).register(), GTMachineUtils.LOW_TIERS);
        QUANTUM_TANK = GTMachineUtils.registerTieredMachines("quantum_tank", (holder, tier) -> new QuantumTankMachine((IMachineBlockEntity)holder, (int)tier, 4000000L * (long)Math.pow(2.0, tier - 1), new Object[0]), (tier, builder) -> builder.langValue("Quantum Tank " + GTValues.LVT[tier]).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).rotationState(RotationState.ALL).renderer(() -> new QuantumTankRenderer((int)tier)).hasTESR(true).tooltipBuilder(GTMachineUtils.TANK_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(4000000L * (long)Math.pow(2.0, tier - 1))})}).register(), GTMachineUtils.HIGH_TIERS);
        WOODEN_CRATE = GTMachineUtils.registerCrate(GTMaterials.Wood, 27, "Wooden Crate");
        BRONZE_CRATE = GTMachineUtils.registerCrate(GTMaterials.Bronze, 54, "Bronze Crate");
        STEEL_CRATE = GTMachineUtils.registerCrate(GTMaterials.Steel, 72, "Steel Crate");
        ALUMINIUM_CRATE = GTMachineUtils.registerCrate(GTMaterials.Aluminium, 90, "Aluminium Crate");
        STAINLESS_STEEL_CRATE = GTMachineUtils.registerCrate(GTMaterials.StainlessSteel, 108, "Stainless Steel Crate");
        TITANIUM_CRATE = GTMachineUtils.registerCrate(GTMaterials.Titanium, 126, "Titanium Crate");
        TUNGSTENSTEEL_CRATE = GTMachineUtils.registerCrate(GTMaterials.TungstenSteel, 144, "Tungstensteel Crate");
        WOODEN_DRUM = GTMachineUtils.registerDrum(GTMaterials.Wood, 16000, "Wooden Barrel");
        BRONZE_DRUM = GTMachineUtils.registerDrum(GTMaterials.Bronze, 32000, "Bronze Drum");
        STEEL_DRUM = GTMachineUtils.registerDrum(GTMaterials.Steel, 64000, "Steel Drum");
        ALUMINIUM_DRUM = GTMachineUtils.registerDrum(GTMaterials.Aluminium, 128000, "Aluminium Drum");
        STAINLESS_STEEL_DRUM = GTMachineUtils.registerDrum(GTMaterials.StainlessSteel, 256000, "Stainless Steel Drum");
        GOLD_DRUM = GTMachineUtils.registerDrum(GTMaterials.Gold, 32000, "Gold Drum");
        TITANIUM_DRUM = GTMachineUtils.registerDrum(GTMaterials.Titanium, 512000, "Titanium Drum");
        TUNGSTENSTEEL_DRUM = GTMachineUtils.registerDrum(GTMaterials.TungstenSteel, 1024000, "Tungstensteel Drum");
        ITEM_IMPORT_BUS = GTMachineUtils.registerTieredMachines("input_bus", (holder, tier) -> new ItemBusPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " Input Bus").rotationState(RotationState.ALL).abilities(PartAbility.IMPORT_ITEMS).overlayTieredHullRenderer("item_bus.import").tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.import.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))})}).register(), GTMachineUtils.ALL_TIERS);
        ITEM_EXPORT_BUS = GTMachineUtils.registerTieredMachines("output_bus", (holder, tier) -> new ItemBusPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " Output Bus").rotationState(RotationState.ALL).abilities(PartAbility.EXPORT_ITEMS).overlayTieredHullRenderer("item_bus.export").tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.export.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))})}).register(), GTMachineUtils.ALL_TIERS);
        FLUID_IMPORT_HATCH = GTMachineUtils.registerFluidHatches("input_hatch", "Input Hatch", "fluid_hatch.import", "fluid_hatch.import", IO.IN, 8000, 1, GTMachineUtils.ALL_TIERS, PartAbility.IMPORT_FLUIDS, PartAbility.IMPORT_FLUIDS_1X);
        FLUID_IMPORT_HATCH_4X = GTMachineUtils.registerFluidHatches("input_hatch_4x", "Quadruple Input Hatch", "fluid_hatch.import_4x", "fluid_hatch.import", IO.IN, 2000, 4, GTMachineUtils.MULTI_HATCH_TIERS, PartAbility.IMPORT_FLUIDS, PartAbility.IMPORT_FLUIDS_4X);
        FLUID_IMPORT_HATCH_9X = GTMachineUtils.registerFluidHatches("input_hatch_9x", "Nonuple Input Hatch", "fluid_hatch.import_9x", "fluid_hatch.import", IO.IN, 1000, 9, GTMachineUtils.MULTI_HATCH_TIERS, PartAbility.IMPORT_FLUIDS, PartAbility.IMPORT_FLUIDS_9X);
        FLUID_EXPORT_HATCH = GTMachineUtils.registerFluidHatches("output_hatch", "Output Hatch", "fluid_hatch.export", "fluid_hatch.export", IO.OUT, 8000, 1, GTMachineUtils.ALL_TIERS, PartAbility.EXPORT_FLUIDS, PartAbility.EXPORT_FLUIDS_1X);
        FLUID_EXPORT_HATCH_4X = GTMachineUtils.registerFluidHatches("output_hatch_4x", "Quadruple Output Hatch", "fluid_hatch.export_4x", "fluid_hatch.export", IO.OUT, 2000, 4, GTMachineUtils.MULTI_HATCH_TIERS, PartAbility.EXPORT_FLUIDS, PartAbility.EXPORT_FLUIDS_4X);
        FLUID_EXPORT_HATCH_9X = GTMachineUtils.registerFluidHatches("output_hatch_9x", "Nonuple Output Hatch", "fluid_hatch.export_9x", "fluid_hatch.export", IO.OUT, 1000, 9, GTMachineUtils.MULTI_HATCH_TIERS, PartAbility.EXPORT_FLUIDS, PartAbility.EXPORT_FLUIDS_9X);
        ENERGY_INPUT_HATCH = GTMachineUtils.registerTieredMachines("energy_input_hatch", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 2, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.INPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in", (Object[])new Object[]{2}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 2))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.input.tooltip")}).overlayTieredHullRenderer("energy_hatch.input").register(), GTMachineUtils.ALL_TIERS);
        ENERGY_OUTPUT_HATCH = GTMachineUtils.registerTieredMachines("energy_output_hatch", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 2, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.OUTPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{2}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 2))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.output.tooltip")}).overlayTieredHullRenderer("energy_hatch.output").register(), GTMachineUtils.ALL_TIERS);
        ENERGY_INPUT_HATCH_4A = GTMachineUtils.registerTieredMachines("energy_input_hatch_4a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 4, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 4A Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.INPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in", (Object[])new Object[]{4}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 4))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.input_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.input_4a").register(), GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9));
        ENERGY_OUTPUT_HATCH_4A = GTMachineUtils.registerTieredMachines("energy_output_hatch_4a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 4, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 4A Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.OUTPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{4}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 4))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.output_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.output_4a").register(), GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9));
        ENERGY_INPUT_HATCH_16A = GTMachineUtils.registerTieredMachines("energy_input_hatch_16a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 16, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 16A Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.INPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in", (Object[])new Object[]{16}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 16))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.input_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.input_16a").register(), GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9));
        ENERGY_OUTPUT_HATCH_16A = GTMachineUtils.registerTieredMachines("energy_output_hatch_16a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 16, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 16A Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.OUTPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{16}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 16))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.output_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.output_16a").register(), GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9));
        SUBSTATION_ENERGY_INPUT_HATCH = GTMachineUtils.registerTieredMachines("substation_input_hatch_64a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 64, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 64A Substation Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.SUBSTATION_INPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in", (Object[])new Object[]{64}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 64))}), Component.m_237115_((String)"gtceu.machine.substation_hatch.input.tooltip")}).overlayTieredHullRenderer("energy_hatch.input_64a").register(), GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9));
        SUBSTATION_ENERGY_OUTPUT_HATCH = GTMachineUtils.registerTieredMachines("substation_output_hatch_64a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 64, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 64A Substation Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.SUBSTATION_OUTPUT_ENERGY).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{64}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, 64))}), Component.m_237115_((String)"gtceu.machine.substation_hatch.output.tooltip")}).overlayTieredHullRenderer("energy_hatch.output_64a").register(), GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9));
        MUFFLER_HATCH = GTMachineUtils.registerTieredMachines("muffler_hatch", MufflerPartMachine::new, (tier, builder) -> builder.langValue("Muffler Hatch " + GTValues.VNF[tier]).rotationState(RotationState.ALL).abilities(PartAbility.MUFFLER).overlayTieredHullRenderer("muffler_hatch").tooltips(new Component[]{LangHandler.getFromMultiLang("gtceu.machine.muffler_hatch.tooltip", 0), Component.m_237110_((String)"gtceu.muffler.recovery_tooltip", (Object[])new Object[]{Math.max(1, tier * 10)}), Component.m_237115_((String)"gtceu.universal.enabled"), LangHandler.getFromMultiLang("gtceu.machine.muffler_hatch.tooltip", 1).m_130940_(ChatFormatting.DARK_RED)}).register(), GTMachineUtils.ELECTRIC_TIERS);
        STEAM_IMPORT_BUS = GTRegistration.REGISTRATE.machine("steam_input_bus", holder -> new SteamItemBusPartMachine((IMachineBlockEntity)holder, IO.IN, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.STEAM_IMPORT_ITEMS).overlaySteamHullRenderer("item_bus.import").langValue("Steam Input Bus").tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.import.tooltip"), Component.m_237115_((String)"gtceu.machine.steam_bus.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{4})}).register();
        STEAM_EXPORT_BUS = GTRegistration.REGISTRATE.machine("steam_output_bus", holder -> new SteamItemBusPartMachine((IMachineBlockEntity)holder, IO.OUT, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.STEAM_EXPORT_ITEMS).overlaySteamHullRenderer("item_bus.export").langValue("Steam Output Bus").tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.export.tooltip"), Component.m_237115_((String)"gtceu.machine.steam_bus.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{4})}).register();
        STEAM_HATCH = GTRegistration.REGISTRATE.machine("steam_input_hatch", x$0 -> new SteamHatchPartMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.STEAM).overlaySteamHullRenderer("steam_hatch").tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{64000}), Component.m_237115_((String)"gtceu.machine.steam.steam_hatch.tooltip")}).register();
        COKE_OVEN_HATCH = GTRegistration.REGISTRATE.machine("coke_oven_hatch", x$0 -> new CokeOvenHatch((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.ALL).modelRenderer(() -> GTCEu.id("block/machine/part/coke_oven_hatch")).register();
        PUMP_HATCH = GTRegistration.REGISTRATE.machine("pump_hatch", x$0 -> new PumpHatchPartMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.PUMP_FLUID_HATCH).renderer(PumpHatchPartRenderer::new).register();
        MAINTENANCE_HATCH = GTRegistration.REGISTRATE.machine("maintenance_hatch", blockEntity -> new MaintenanceHatchPartMachine((IMachineBlockEntity)blockEntity, false)).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new Component[]{Component.m_237115_((String)"gtceu.universal.disabled")}).renderer(() -> new MaintenanceHatchPartRenderer(1, GTCEu.id("block/machine/part/maintenance"))).register();
        CONFIGURABLE_MAINTENANCE_HATCH = GTRegistration.REGISTRATE.machine("configurable_maintenance_hatch", blockEntity -> new MaintenanceHatchPartMachine((IMachineBlockEntity)blockEntity, true)).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new Component[]{Component.m_237115_((String)"gtceu.universal.disabled")}).renderer(() -> new MaintenanceHatchPartRenderer(3, GTCEu.id("block/machine/part/maintenance.configurable"))).register();
        CLEANING_MAINTENANCE_HATCH = GTRegistration.REGISTRATE.machine("cleaning_maintenance_hatch", holder -> new CleaningMaintenanceHatchPartMachine((IMachineBlockEntity)holder, CleanroomType.CLEANROOM)).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new Component[]{Component.m_237115_((String)"gtceu.universal.disabled"), Component.m_237115_((String)"gtceu.machine.maintenance_hatch_cleanroom_auto.tooltip.0"), Component.m_237115_((String)"gtceu.machine.maintenance_hatch_cleanroom_auto.tooltip.1")}).tooltipBuilder((stack, tooltips) -> tooltips.add(Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)CleanroomType.CLEANROOM.getTranslationKey()).m_130940_(ChatFormatting.GREEN)))).renderer(() -> new MaintenanceHatchPartRenderer(3, GTCEu.id("block/machine/part/maintenance.cleaning"))).register();
        AUTO_MAINTENANCE_HATCH = GTRegistration.REGISTRATE.machine("auto_maintenance_hatch", AutoMaintenanceHatchPartMachine::new).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new Component[]{Component.m_237115_((String)"gtceu.universal.disabled")}).renderer(() -> new MaintenanceHatchPartRenderer(3, GTCEu.id("block/machine/part/maintenance.full_auto"))).register();
        ITEM_PASSTHROUGH_HATCH = GTMachineUtils.registerTieredMachines("item_passthrough_hatch", (holder, tier) -> new ItemBusPartMachine((IMachineBlockEntity)holder, (int)tier, IO.BOTH, new Object[0]), (tier, builder) -> builder.langValue("%s Item Passthrough Hatch".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.PASSTHROUGH_HATCH).overlayTieredHullRenderer("item_passthrough_hatch").tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))}), Component.m_237115_((String)"gtceu.universal.enabled")}).register(), GTMachineUtils.ELECTRIC_TIERS);
        FLUID_PASSTHROUGH_HATCH = GTMachineUtils.registerTieredMachines("fluid_passthrough_hatch", (holder, tier) -> new FluidHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.BOTH, 8000, 1, new Object[0]), (tier, builder) -> builder.langValue("%s Fluid Passthrough Hatch".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.PASSTHROUGH_HATCH).overlayTieredHullRenderer("fluid_passthrough_hatch").tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{tier + 1, 16000}), Component.m_237115_((String)"gtceu.universal.enabled")}).register(), GTMachineUtils.ELECTRIC_TIERS);
        RESERVOIR_HATCH = GTRegistration.REGISTRATE.machine("reservoir_hatch", x$0 -> new ReservoirHatchPartMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Reservoir Hatch").tier(4).rotationState(RotationState.ALL).abilities(PartAbility.IMPORT_FLUIDS).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(2000000000)}), Component.m_237115_((String)"gtceu.universal.enabled")}).overlayTieredHullRenderer("reservoir_hatch").register();
        DUAL_IMPORT_HATCH = GTMachineUtils.registerTieredMachines("dual_input_hatch", (holder, tier) -> new DualHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, new Object[0]), (tier, builder) -> builder.langValue("%s Dual Input Hatch".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(GTMachineUtils.DUAL_INPUT_HATCH_ABILITIES).overlayTieredHullRenderer("dual_hatch.import").tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.dual_hatch.import.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(int)Math.pow(tier - 4, 2.0)}), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{tier - 4, DualHatchPartMachine.getTankCapacity(16000, tier)}), Component.m_237115_((String)"gtceu.universal.enabled")}).register(), GTMachineUtils.DUAL_HATCH_TIERS);
        DUAL_EXPORT_HATCH = GTMachineUtils.registerTieredMachines("dual_output_hatch", (holder, tier) -> new DualHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, new Object[0]), (tier, builder) -> builder.langValue("%s Dual Output Hatch".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(GTMachineUtils.DUAL_OUTPUT_HATCH_ABILITIES).overlayTieredHullRenderer("dual_hatch.export").tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.dual_hatch.export.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(int)Math.pow(tier - 4, 2.0)}), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{tier - 4, DualHatchPartMachine.getTankCapacity(16000, tier)}), Component.m_237115_((String)"gtceu.universal.enabled")}).register(), GTMachineUtils.DUAL_HATCH_TIERS);
        DIODE = GTMachineUtils.registerTieredMachines("diode", DiodePartMachine::new, (tier, builder) -> builder.langValue("%s Diode".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.PASSTHROUGH_HATCH).renderer(() -> new DiodeRenderer((int)tier)).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.diode.tooltip_general"), Component.m_237115_((String)"gtceu.machine.diode.tooltip_starts_at"), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in_out_till", (Object[])new Object[]{DiodePartMachine.MAX_AMPS})}).register(), GTMachineUtils.ELECTRIC_TIERS);
        ROTOR_HOLDER = GTMachineUtils.registerTieredMachines("rotor_holder", RotorHolderPartMachine::new, (tier, builder) -> builder.langValue("%s Rotor Holder".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.ROTOR_HOLDER).renderer(() -> new RotorHolderMachineRenderer((int)tier)).tooltips(new Component[]{LangHandler.getFromMultiLang("gtceu.machine.rotor_holder.tooltip", 0), LangHandler.getFromMultiLang("gtceu.machine.rotor_holder.tooltip", 1), Component.m_237115_((String)"gtceu.universal.disabled")}).register(), GTValues.tiersBetween(3, GTCEuAPI.isHighTier() ? 13 : 8));
        LASER_INPUT_HATCH_256 = GTMachineUtils.registerLaserHatch(IO.IN, 256, PartAbility.INPUT_LASER);
        LASER_OUTPUT_HATCH_256 = GTMachineUtils.registerLaserHatch(IO.OUT, 256, PartAbility.OUTPUT_LASER);
        LASER_INPUT_HATCH_1024 = GTMachineUtils.registerLaserHatch(IO.IN, 1024, PartAbility.INPUT_LASER);
        LASER_OUTPUT_HATCH_1024 = GTMachineUtils.registerLaserHatch(IO.OUT, 1024, PartAbility.OUTPUT_LASER);
        LASER_INPUT_HATCH_4096 = GTMachineUtils.registerLaserHatch(IO.IN, 4096, PartAbility.INPUT_LASER);
        LASER_OUTPUT_HATCH_4096 = GTMachineUtils.registerLaserHatch(IO.OUT, 4096, PartAbility.OUTPUT_LASER);
    }
}

