/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class DetectorCover
extends CoverBehavior
implements IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DetectorCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    @Persisted
    protected boolean isWorkingEnabled = true;
    protected TickableSubscription subscription;
    @Persisted
    @DescSynced
    private boolean isInverted;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public DetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscription = this.coverHolder.subscribeServerTick(this.subscription, this::update);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    protected abstract void update();

    private void toggleInvertedWithNotification() {
        this.setInverted(!this.isInverted());
        if (!this.coverHolder.isRemote()) {
            this.coverHolder.notifyBlockUpdate();
            this.coverHolder.markDirty();
        }
    }

    @Override
    public InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult superResult = super.onScrewdriverClick(playerIn, hand, hitResult);
        if (superResult != InteractionResult.PASS) {
            return superResult;
        }
        if (!this.coverHolder.isRemote()) {
            this.toggleInvertedWithNotification();
            String translationKey = this.isInverted() ? "cover.detector_base.message_inverted_state" : "cover.detector_base.message_normal_state";
            playerIn.m_213846_((Component)Component.m_237115_((String)translationKey));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public boolean canPipePassThrough() {
        return false;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }
}

