/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.capability;

import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.medicalcondition.Symptom;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class MedicalConditionTracker
implements IMedicalConditionTracker,
INBTSerializable<CompoundTag> {
    private final Object2FloatMap<MedicalCondition> medicalConditions = new Object2FloatOpenHashMap();
    private final Set<MedicalCondition> permanentConditions = new HashSet<MedicalCondition>();
    private final Object2IntMap<Symptom.ConfiguredSymptom> activeSymptoms = new Object2IntOpenHashMap();
    private final Object2IntMap<MobEffect> activeMobEffects = new Object2IntOpenHashMap();
    private final Set<MedicalCondition> flaggedForRemoval = new HashSet<MedicalCondition>();
    private int maxAirSupply = -1;
    private final Player player;

    public MedicalConditionTracker(Player player) {
        this.player = player;
    }

    @Override
    public void tick() {
        if (this.player.m_7500_()) {
            return;
        }
        for (Object2IntMap.Entry entry : this.activeMobEffects.object2IntEntrySet()) {
            this.player.m_7292_(new MobEffectInstance((MobEffect)entry.getKey(), 100, entry.getIntValue()));
        }
        if (this.player.m_9236_().m_46467_() % 20L == 0L) {
            for (MedicalCondition condition : this.medicalConditions.keySet()) {
                if (condition.idleProgressionType == MedicalCondition.IdleProgressionType.NONE || this.permanentConditions.contains(condition) && condition.idleProgressionType == MedicalCondition.IdleProgressionType.HEAL) continue;
                int multiplier = condition.idleProgressionType == MedicalCondition.IdleProgressionType.HEAL ? -1 : 1;
                this.medicalConditions.replace((Object)condition, this.medicalConditions.getFloat((Object)condition) + condition.idleProgressionRate * (float)multiplier);
                this.evaluateMedicalCondition(condition);
            }
            if (!this.medicalConditions.isEmpty()) {
                this.updateActiveSymptoms();
            }
        }
    }

    @Override
    public void progressCondition(@NotNull MedicalCondition condition, float strength) {
        if (this.player.m_7500_()) {
            return;
        }
        this.medicalConditions.put((Object)condition, this.medicalConditions.getOrDefault((Object)condition, 0.0f) + strength);
        this.updateActiveSymptoms();
    }

    private void updateActiveSymptoms() {
        for (MedicalCondition condition : this.medicalConditions.keySet()) {
            if (this.medicalConditions.getFloat((Object)condition) >= condition.maxProgression * 2.0f) {
                this.permanentConditions.add(condition);
            }
            for (Symptom.ConfiguredSymptom symptom : condition.symptoms) {
                int stage = this.calculateStage(condition, symptom);
                if (stage <= 0) continue;
                symptom.symptom.tick(this, condition, symptom, stage);
                Optional<Symptom.ConfiguredSymptom> currentSymptomOptional = this.activeSymptoms.keySet().stream().filter(symptom1 -> symptom1.symptom == symptom.symptom).findFirst();
                if (currentSymptomOptional.isEmpty()) {
                    this.activeSymptoms.put((Object)symptom, stage);
                    symptom.symptom.applyProgression(this, condition, null, stage);
                    continue;
                }
                Symptom.ConfiguredSymptom currentSymptom = currentSymptomOptional.get();
                if (currentSymptom == symptom && stage > this.activeSymptoms.getOrDefault((Object)symptom, 0)) {
                    symptom.symptom.applyProgression(this, condition, symptom, this.activeSymptoms.getOrDefault((Object)symptom, 0));
                    this.activeSymptoms.replace((Object)symptom, stage);
                    symptom.symptom.applyProgression(this, condition, symptom, stage);
                    continue;
                }
                if (!(symptom.relativeHarshness * (float)stage > currentSymptom.relativeHarshness * (float)this.activeSymptoms.getOrDefault((Object)currentSymptom, 0))) continue;
                currentSymptom.symptom.applyProgression(this, condition, symptom, this.activeSymptoms.getOrDefault((Object)currentSymptom, 0));
                this.activeSymptoms.removeInt((Object)currentSymptom);
                this.activeSymptoms.put((Object)symptom, stage);
                symptom.symptom.applyProgression(this, condition, symptom, stage);
            }
        }
        if (this.flaggedForRemoval.isEmpty()) {
            return;
        }
        for (MedicalCondition condition : this.flaggedForRemoval) {
            for (Symptom.ConfiguredSymptom configuredSymptom : this.activeSymptoms.keySet().stream().filter(condition.symptoms::contains).toList()) {
                configuredSymptom.symptom.applyProgression(this, condition, configuredSymptom, 0);
            }
            this.medicalConditions.removeFloat((Object)condition);
        }
        this.flaggedForRemoval.clear();
    }

    @Override
    public void removeMedicalCondition(MedicalCondition condition) {
        this.flaggedForRemoval.add(condition);
        this.permanentConditions.remove(condition);
    }

    private int calculateStage(MedicalCondition condition, Symptom.ConfiguredSymptom symptom) {
        return (int)Math.floor(Math.min(this.medicalConditions.getFloat((Object)condition), condition.maxProgression) / (symptom.progressionThreshold * condition.maxProgression * (float)symptom.stages));
    }

    private void evaluateMedicalCondition(MedicalCondition condition) {
        if (this.permanentConditions.contains(condition)) {
            return;
        }
        if (this.medicalConditions.getFloat((Object)condition) <= 0.0f) {
            this.removeMedicalCondition(condition);
        }
    }

    @Override
    public void heal(MedicalCondition condition, int progression) {
        if ((float)progression >= this.medicalConditions.getOrDefault((Object)condition, 0.0f)) {
            this.medicalConditions.removeFloat((Object)condition);
            this.permanentConditions.remove(condition);
            return;
        }
        this.medicalConditions.replace((Object)condition, this.medicalConditions.getOrDefault((Object)condition, 0.0f) - (float)progression);
    }

    @Override
    public int getMaxAirSupply() {
        return this.maxAirSupply;
    }

    @Override
    public void setMobEffect(MobEffect effect, int amplifier) {
        if (amplifier <= 0) {
            this.activeMobEffects.removeInt((Object)effect);
        } else if (amplifier >= this.activeMobEffects.getOrDefault((Object)effect, -1)) {
            this.activeMobEffects.put((Object)effect, amplifier);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag effectsTag = new ListTag();
        for (Object2FloatMap.Entry entry : this.medicalConditions.object2FloatEntrySet()) {
            CompoundTag medicalConditionTag = new CompoundTag();
            medicalConditionTag.m_128359_("condition", ((MedicalCondition)entry.getKey()).name);
            medicalConditionTag.m_128350_("progression", entry.getFloatValue());
            effectsTag.add((Object)medicalConditionTag);
        }
        tag.m_128365_("medical_conditions", (Tag)effectsTag);
        ListTag permanentsTag = new ListTag();
        for (MedicalCondition condition : this.permanentConditions) {
            permanentsTag.add((Object)StringTag.m_129297_((String)condition.name));
        }
        tag.m_128365_("permanent_conditions", (Tag)permanentsTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag arg) {
        ListTag medicalConditionsTag = arg.m_128437_("medical_conditions", 10);
        for (int i = 0; i < medicalConditionsTag.size(); ++i) {
            CompoundTag compoundTag = medicalConditionsTag.m_128728_(i);
            MedicalCondition condition = MedicalCondition.CONDITIONS.get(compoundTag.m_128461_("condition"));
            float progression = compoundTag.m_128457_("progression");
            this.medicalConditions.put((Object)condition, progression);
        }
        ListTag permanentConditionsTag = arg.m_128437_("permanent_conditions", 8);
        for (int i = 0; i < permanentConditionsTag.size(); ++i) {
            this.permanentConditions.add(MedicalCondition.CONDITIONS.get(permanentConditionsTag.m_128778_(i)));
        }
    }

    @Override
    public Object2FloatMap<MedicalCondition> getMedicalConditions() {
        return this.medicalConditions;
    }

    public void setMaxAirSupply(int maxAirSupply) {
        this.maxAirSupply = maxAirSupply;
    }

    public Player getPlayer() {
        return this.player;
    }
}

