/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.GTRenderTypes;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gregtechceu.gtceu.client.util.RenderBufferHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FusionReactorRenderer
extends WorkableCasingMachineRenderer {
    public FusionReactorRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof FusionReactorMachine) {
            FusionReactorMachine machine = (FusionReactorMachine)metaMachine;
            if (GTCEu.Mods.isShimmerLoaded()) {
                PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)stack);
                BloomUtils.entityBloom(source -> this.renderLightRing(machine, partialTicks, finalStack, (MultiBufferSource)source));
            } else {
                this.renderLightRing(machine, partialTicks, stack, buffer);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderLightRing(FusionReactorMachine machine, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        Integer color = machine.getColor();
        if (color == -1) {
            return;
        }
        int ringColor = ColorUtils.blendColor((int)color, (int)-1, (float)Eases.EaseQuadIn.getInterpolation(Math.abs((float)Math.abs(machine.getOffsetTimer() % 50L) + partialTicks - 25.0f) / 25.0f));
        Direction front = machine.getFrontFacing();
        Direction upwards = machine.getUpwardsFacing();
        boolean flipped = machine.isFlipped();
        Direction relativeBack = RelativeDirection.BACK.getRelativeFacing(front, upwards, flipped);
        Direction.Axis axis = RelativeDirection.UP.getRelativeFacing(front, upwards, flipped).m_122434_();
        float a = ColorUtils.alpha((int)ringColor);
        float r = ColorUtils.red((int)ringColor);
        float g = ColorUtils.green((int)ringColor);
        float b = ColorUtils.blue((int)ringColor);
        RenderBufferHelper.renderRing(stack, buffer.m_6299_(GTRenderTypes.getLightRing()), (float)(relativeBack.m_122429_() * 7) + 0.5f, (float)(relativeBack.m_122430_() * 7) + 0.5f, (float)(relativeBack.m_122431_() * 7) + 0.5f, 6.0f, 0.2f, 10, 20, r, g, b, a, axis);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 32;
    }
}

