/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.client.util.DrawUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public final class ToolChargeBarRenderer {
    private static final int BAR_W = 12;
    private static final int colorShadow = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0);
    private static final int colorBG = FastColor.ARGB32.m_13660_((int)255, (int)14, (int)1, (int)22);
    private static final int colorBarLeftEnergy = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)101, (int)178);
    private static final int colorBarRightEnergy = FastColor.ARGB32.m_13660_((int)255, (int)217, (int)238, (int)255);
    private static final int colorBarLeftDurability = FastColor.ARGB32.m_13660_((int)255, (int)20, (int)124, (int)0);
    private static final int colorBarRightDurability = FastColor.ARGB32.m_13660_((int)255, (int)115, (int)255, (int)89);
    private static final int colorBarLeftDepleted = FastColor.ARGB32.m_13660_((int)255, (int)122, (int)0, (int)0);
    private static final int colorBarRightDepleted = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)27, (int)27);

    public static void render(GuiGraphics graphics, int level, int xPosition, int yPosition, int offset, boolean shadow, int left, int right, boolean doDepletedColor) {
        if (doDepletedColor && level <= 3) {
            left = colorBarLeftDepleted;
            right = colorBarRightDepleted;
        }
        int x = xPosition + 2;
        int y = yPosition + 13 - offset;
        graphics.m_285795_(RenderType.m_286086_(), x, y, x + 13, y + (shadow ? 2 : 1), 400, colorShadow);
        DrawUtil.fillHorizontalGradient(graphics, RenderType.m_286086_(), x, y, x + level, y + 1, left, right, 400);
    }

    public static void renderBarsTool(GuiGraphics graphics, IGTTool tool, ItemStack stack, int xPosition, int yPosition) {
        boolean renderedDurability = false;
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_("Unbreakable")) {
            renderedDurability = ToolChargeBarRenderer.renderDurabilityBar(graphics, stack.m_150948_(), xPosition, yPosition);
        }
        if (tool.isElectric()) {
            ToolChargeBarRenderer.renderElectricBar(graphics, tool.getCharge(stack), tool.getMaxCharge(stack), xPosition, yPosition, renderedDurability);
        }
    }

    public static void renderBarsItem(GuiGraphics graphics, IComponentItem item, ItemStack stack, int xPosition, int yPosition) {
        IElectricItem electricItem;
        boolean renderedDurability = false;
        IDurabilityBar bar = null;
        for (IItemComponent component : item.getComponents()) {
            IDurabilityBar durabilityBar;
            if (!(component instanceof IDurabilityBar)) continue;
            bar = durabilityBar = (IDurabilityBar)component;
        }
        if (bar != null) {
            renderedDurability = ToolChargeBarRenderer.renderDurabilityBar(graphics, stack, bar, xPosition, yPosition);
        }
        if ((electricItem = GTCapabilityHelper.getElectricItem(stack)) != null) {
            ToolChargeBarRenderer.renderElectricBar(graphics, electricItem.getCharge(), electricItem.getMaxCharge(), xPosition, yPosition, renderedDurability);
        }
    }

    private static void renderElectricBar(GuiGraphics graphics, long charge, long maxCharge, int xPosition, int yPosition, boolean renderedDurability) {
        if (charge > 0L && maxCharge > 0L) {
            int level = Math.round((float)charge * 13.0f / (float)maxCharge);
            ToolChargeBarRenderer.render(graphics, level, xPosition, yPosition, renderedDurability ? 2 : 0, true, colorBarLeftEnergy, colorBarRightEnergy, true);
        }
    }

    private static boolean renderDurabilityBar(GuiGraphics graphics, ItemStack stack, IDurabilityBar manager, int xPosition, int yPosition) {
        float level = manager.getDurabilityForDisplay(stack);
        if ((double)level == 0.0 && !manager.showEmptyBar(stack)) {
            return false;
        }
        if ((double)level == 1.0 && !manager.showFullBar(stack)) {
            return false;
        }
        Pair<Integer, Integer> colors = manager.getDurabilityColorsForDisplay(stack);
        boolean doDepletedColor = manager.doDamagedStateColors(stack);
        int left = colors != null ? (Integer)colors.getLeft() : colorBarLeftDurability;
        int right = colors != null ? (Integer)colors.getRight() : colorBarRightDurability;
        ToolChargeBarRenderer.render(graphics, manager.getBarWidth(stack), xPosition, yPosition, 0, true, left, right, doDepletedColor);
        return true;
    }

    private static boolean renderDurabilityBar(GuiGraphics graphics, int level, int xPosition, int yPosition) {
        ToolChargeBarRenderer.render(graphics, level, xPosition, yPosition, 0, true, colorBarLeftDurability, colorBarRightDurability, true);
        return true;
    }

    private ToolChargeBarRenderer() {
    }
}

