/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.utils.ResourceHelper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SimpleCoverRenderer
implements ICoverRenderer {
    ResourceLocation texture;
    ResourceLocation emissiveTexture;

    public SimpleCoverRenderer(ResourceLocation texture) {
        this.texture = texture;
        if (GTCEu.isClientSide()) {
            this.registerEvent();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(this.texture);
            this.emissiveTexture = new ResourceLocation(this.texture.m_135827_(), this.texture.m_135815_() + "_emissive");
            if (ResourceHelper.isTextureExist((ResourceLocation)this.emissiveTexture)) {
                register.accept(this.emissiveTexture);
            } else {
                this.emissiveTexture = null;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderCover(List<BakedQuad> quads, Direction side, RandomSource rand, @NotNull CoverBehavior coverBehavior, Direction modelFacing, BlockPos pos, BlockAndTintGetter level, ModelState modelState) {
        if (side == coverBehavior.attachedSide && modelFacing != null) {
            quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)this.texture), modelState));
            if (this.emissiveTexture != null) {
                quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)this.emissiveTexture), modelState));
            }
        }
    }
}

