/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface RecipeModifier {
    public static final RecipeModifier NO_MODIFIER = (m, r) -> ModifierFunction.IDENTITY;

    @Contract(pure=true)
    @NotNull
    public ModifierFunction getModifier(@NotNull MetaMachine var1, @NotNull GTRecipe var2);

    @Contract(pure=true)
    @Nullable
    default public GTRecipe applyModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        return this.getModifier(machine, recipe).apply(recipe);
    }

    public static ModifierFunction nullWrongType(Class<?> type, MetaMachine actual) {
        GTCEu.LOGGER.error("Incorrect use of modifier, expected machine of type {}, received {}", (Object)type.getSimpleName(), (Object)actual.getDefinition().getName());
        return ModifierFunction.NULL;
    }
}

