/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public class SerializerBlockState
implements IContentSerializer<BlockState> {
    public static SerializerBlockState INSTANCE = new SerializerBlockState();

    private SerializerBlockState() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, BlockState content) {
        buf.m_130130_(BuiltInRegistries.f_256975_.m_7447_((Object)content.m_60734_()));
        ImmutableMap values = content.m_61148_();
        if (!values.isEmpty()) {
            buf.writeBoolean(true);
            for (Map.Entry entry : values.entrySet()) {
                buf.m_130070_(((Property)entry.getKey()).m_61708_());
                buf.m_130070_(((Property)entry.getKey()).m_6940_((Comparable)entry.getValue()));
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public BlockState fromNetwork(FriendlyByteBuf buf) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7942_(buf.m_130242_());
        BlockState blockState = block.m_49966_();
        if (buf.readBoolean()) {
            StateDefinition stateDefinition = block.m_49965_();
            ImmutableMap values = blockState.m_61148_();
            for (int i = 0; i < values.size(); ++i) {
                String propertyName = buf.m_130277_();
                String propertyValueName = buf.m_130277_();
                Property property = stateDefinition.m_61081_(propertyName);
                if (property == null) continue;
                Optional value = property.m_6215_(propertyValueName);
                value.ifPresent(comparable -> blockState.m_61124_(property, comparable));
            }
        }
        return blockState;
    }

    @Override
    public BlockState fromJson(JsonElement json) {
        return (BlockState)BlockState.f_61039_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    @Override
    public JsonElement toJson(BlockState content) {
        return (JsonElement)BlockState.f_61039_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)content).get().map(Function.identity(), partial -> JsonNull.INSTANCE);
    }

    @Override
    public BlockState of(Object o) {
        if (o instanceof BlockState) {
            BlockState state = (BlockState)o;
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public BlockState defaultValue() {
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public Codec<BlockState> codec() {
        return BlockState.f_61039_;
    }
}

