/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableFluidTank
extends NotifiableRecipeHandlerTrait<FluidIngredient>
implements ICapabilityTrait,
IFluidHandlerModifiable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableFluidTank.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    protected final CustomFluidTank[] storages;
    protected boolean allowSameFluids;
    private Boolean isEmpty;
    @Persisted
    @DescSynced
    protected CustomFluidTank lockedFluid = new CustomFluidTank(1000);
    protected Predicate<FluidStack> filter = f -> true;

    public NotifiableFluidTank(MetaMachine machine, int slots, int capacity, IO io, IO capabilityIO) {
        super(machine);
        this.handlerIO = io;
        this.storages = new CustomFluidTank[slots];
        this.capabilityIO = capabilityIO;
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i] = new CustomFluidTank(capacity);
            this.storages[i].setOnContentsChanged(this::onContentsChanged);
        }
    }

    public NotifiableFluidTank(MetaMachine machine, List<CustomFluidTank> storages, IO io, IO capabilityIO) {
        super(machine);
        this.handlerIO = io;
        this.storages = (CustomFluidTank[])storages.toArray(CustomFluidTank[]::new);
        this.capabilityIO = capabilityIO;
        for (CustomFluidTank storage : this.storages) {
            storage.setOnContentsChanged(this::onContentsChanged);
        }
        if (io == IO.IN) {
            this.allowSameFluids = true;
        }
    }

    public NotifiableFluidTank(MetaMachine machine, int slots, int capacity, IO io) {
        this(machine, slots, capacity, io, io);
    }

    public NotifiableFluidTank(MetaMachine machine, List<CustomFluidTank> storages, IO io) {
        this(machine, storages, io, io);
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
        if (io != this.handlerIO) {
            return left;
        }
        if (io != IO.IN && io != IO.OUT) {
            return left.isEmpty() ? null : left;
        }
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        FluidStack[] visited = new FluidStack[this.storages.length];
        Iterator<FluidIngredient> it = left.iterator();
        block0: while (it.hasNext()) {
            FluidIngredient ingredient = it.next();
            if (ingredient.isEmpty()) {
                it.remove();
                continue;
            }
            FluidStack[] fluids = ingredient.getStacks();
            if (fluids.length == 0 || fluids[0].isEmpty()) {
                it.remove();
                continue;
            }
            if (io == IO.OUT && !this.allowSameFluids) {
                CustomFluidTank existing = null;
                for (CustomFluidTank storage : this.storages) {
                    if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(fluids[0])) continue;
                    existing = storage;
                    break;
                }
                if (existing != null) {
                    FluidStack output = fluids[0];
                    int filled = existing.fill(output, action);
                    ingredient.shrink(filled);
                    if (ingredient.getAmount() > 0) continue;
                    it.remove();
                    continue;
                }
            }
            for (int tank = 0; tank < this.storages.length; ++tank) {
                int amount;
                FluidStack stored = this.getFluidInTank(tank);
                int n = amount = visited[tank] == null ? stored.getAmount() : visited[tank].getAmount();
                if (io == IO.IN) {
                    FluidStack drained;
                    if (amount == 0) continue;
                    if ((visited[tank] == null && ingredient.test(stored) || ingredient.test(visited[tank])) && (drained = this.storages[tank].drain(ingredient.getAmount(), action)).getAmount() > 0) {
                        visited[tank] = drained.copy();
                        visited[tank].setAmount(amount - drained.getAmount());
                        ingredient.shrink(drained.getAmount());
                    }
                } else {
                    int filled;
                    FluidStack output = fluids[0].copy();
                    output.setAmount(ingredient.getAmount());
                    if ((visited[tank] == null || visited[tank].isFluidEqual(output)) && (filled = this.storages[tank].fill(output, action)) > 0) {
                        visited[tank] = output.copy();
                        visited[tank].setAmount(filled);
                        ingredient.shrink(filled);
                        if (!this.allowSameFluids) {
                            if (ingredient.getAmount() > 0) continue block0;
                            it.remove();
                            continue block0;
                        }
                    }
                }
                if (ingredient.getAmount() > 0) continue;
                it.remove();
                continue block0;
            }
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public boolean test(FluidIngredient ingredient) {
        return !this.isLocked() || ingredient.test(this.lockedFluid.getFluid());
    }

    @Override
    public int getPriority() {
        return !this.isLocked() || this.lockedFluid.getFluid().isEmpty() ? super.getPriority() : 0x3FFFFFFF - this.getTanks();
    }

    public boolean isLocked() {
        return !this.lockedFluid.getFluid().isEmpty();
    }

    public void setLocked(boolean locked) {
        if (this.isLocked() == locked) {
            return;
        }
        FluidStack fluidStack = this.storages[0].getFluid();
        if (locked && !fluidStack.isEmpty()) {
            this.lockedFluid.setFluid(fluidStack.copy());
            this.lockedFluid.getFluid().setAmount(1);
            this.onContentsChanged();
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        } else {
            this.lockedFluid.setFluid(FluidStack.EMPTY);
            this.setFilter(stack -> true);
            this.onContentsChanged();
        }
    }

    public void setLocked(boolean locked, FluidStack fluidStack) {
        if (this.isLocked() == locked) {
            return;
        }
        if (locked && !fluidStack.isEmpty()) {
            this.lockedFluid.setFluid(fluidStack.copy());
            this.lockedFluid.getFluid().setAmount(1);
            this.onContentsChanged();
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        } else {
            this.lockedFluid.setFluid(FluidStack.EMPTY);
            this.setFilter(stack -> true);
            this.onContentsChanged();
        }
    }

    public NotifiableFluidTank setFilter(Predicate<FluidStack> filter) {
        this.filter = filter;
        for (CustomFluidTank storage : this.storages) {
            storage.setValidator(filter);
        }
        return this;
    }

    @Override
    public RecipeCapability<FluidIngredient> getCapability() {
        return FluidRecipeCapability.CAP;
    }

    public int getTanks() {
        return this.storages.length;
    }

    @Override
    public int getSize() {
        return this.getTanks();
    }

    @Override
    public List<Object> getContents() {
        ArrayList<FluidStack> ingredients = new ArrayList<FluidStack>();
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            ingredients.add(stack);
        }
        return Arrays.asList(ingredients.toArray());
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            amount += (long)stack.getAmount();
        }
        return amount;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (CustomFluidTank storage : this.storages) {
                if (storage.getFluid().isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<FluidStack> filter = this.getMachine().getFluidCapFilter(facing, IO.OUT);
            GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferFluidsFiltered(this, adj, filter));
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<FluidStack> filter = this.getMachine().getFluidCapFilter(facing, IO.IN);
            GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferFluidsFiltered(adj, this, filter));
        }
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.storages[tank].getFluid();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.storages[tank].setFluid(fluidStack);
    }

    public int getTankCapacity(int tank) {
        return this.storages[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.storages[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canCapInput()) {
            return 0;
        }
        return this.fillInternal(resource, action);
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidStack copied = resource.copy();
        CustomFluidTank existingStorage = null;
        if (!this.allowSameFluids) {
            for (CustomFluidTank storage : this.storages) {
                if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(resource)) continue;
                existingStorage = storage;
                break;
            }
        }
        if (existingStorage == null) {
            for (CustomFluidTank storage : this.storages) {
                int filled = storage.fill(copied.copy(), action);
                if (filled > 0) {
                    copied.shrink(filled);
                    if (!this.allowSameFluids) break;
                }
                if (!copied.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            copied.shrink(existingStorage.fill(copied.copy(), action));
        }
        return resource.getAmount() - copied.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.canCapOutput()) {
            return this.drainInternal(resource, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty()) {
            FluidStack copied = resource.copy();
            for (CustomFluidTank storage : this.storages) {
                FluidStack candidate = copied.copy();
                copied.shrink(storage.drain(candidate, action).getAmount());
                if (copied.isEmpty()) break;
            }
            copied.setAmount(resource.getAmount() - copied.getAmount());
            return copied;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.canCapOutput()) {
            return this.drainInternal(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack totalDrained = null;
        for (CustomFluidTank storage : this.storages) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = storage.drain(maxDrain, action);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = storage.drain(copy, action);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0) break;
        }
        return totalDrained == null ? FluidStack.EMPTY : totalDrained;
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        if (this.isLocked()) {
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        }
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    public CustomFluidTank[] getStorages() {
        return this.storages;
    }

    public boolean isAllowSameFluids() {
        return this.allowSameFluids;
    }

    public CustomFluidTank getLockedFluid() {
        return this.lockedFluid;
    }

    public Predicate<FluidStack> getFilter() {
        return this.filter;
    }
}

