/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class SteamEnergyRecipeHandler
implements IRecipeHandler<Long> {
    private final NotifiableFluidTank steamTank;
    private final double conversionRate;

    public SteamEnergyRecipeHandler(NotifiableFluidTank steamTank, double conversionRate) {
        this.steamTank = steamTank;
        this.conversionRate = conversionRate;
    }

    @Override
    public List<Long> handleRecipeInner(IO io, GTRecipe recipe, List<Long> left, @Nullable String slotName, boolean simulate) {
        long eut = left.stream().reduce(0L, Long::sum);
        int totalSteam = GTMath.saturatedCast((long)Math.ceil((double)eut * this.conversionRate));
        if (totalSteam > 0) {
            FluidIngredient steam = io == IO.IN ? FluidIngredient.of(GTMaterials.Steam.getFluidTag(), totalSteam) : FluidIngredient.of(GTMaterials.Steam.getFluid(totalSteam));
            ArrayList<FluidIngredient> list = new ArrayList<FluidIngredient>();
            list.add(steam);
            List<FluidIngredient> leftSteam = this.steamTank.handleRecipeInner(io, recipe, (List<FluidIngredient>)list, slotName, simulate);
            if (leftSteam == null || leftSteam.isEmpty()) {
                return null;
            }
            eut = (long)((double)leftSteam.get(0).getAmount() / this.conversionRate);
        }
        return eut <= 0L ? null : Collections.singletonList(eut);
    }

    @Override
    public List<Object> getContents() {
        ArrayList<FluidStack> tankContents = new ArrayList<FluidStack>();
        for (int i = 0; i < this.steamTank.getTanks(); ++i) {
            FluidStack stack = this.steamTank.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            tankContents.add(stack);
        }
        long sum = tankContents.stream().map(FluidStack::getAmount).reduce(0, Integer::sum).intValue();
        long realSum = (long)Math.ceil((double)sum * this.conversionRate);
        return List.of(Long.valueOf(realSum));
    }

    @Override
    public double getTotalContentAmount() {
        ArrayList<FluidStack> tankContents = new ArrayList<FluidStack>();
        for (int i = 0; i < this.steamTank.getTanks(); ++i) {
            FluidStack stack = this.steamTank.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            tankContents.add(stack);
        }
        long sum = tankContents.stream().map(FluidStack::getAmount).reduce(0, Integer::sum).intValue();
        return (long)Math.ceil((double)sum * this.conversionRate);
    }

    @Override
    public RecipeCapability<Long> getCapability() {
        return EURecipeCapability.CAP;
    }

    public long getCapacity() {
        return this.steamTank.getTankCapacity(0);
    }

    public long getStored() {
        FluidStack stack = this.steamTank.getFluidInTank(0);
        if (stack != FluidStack.EMPTY) {
            return stack.getAmount();
        }
        return 0L;
    }
}

