/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;

public interface IExplosionMachine
extends IMachineFeature {
    default public void checkWeatherOrTerrainExplosion(float explosionPower, double additionalFireChance) {
        if (!this.shouldWeatherOrTerrainExplosion()) {
            return;
        }
        MetaMachine machine = this.self();
        Level level = machine.getLevel();
        BlockPos pos = machine.getPos();
        if (GTValues.RNG.m_188503_(1000) == 0) {
            for (Direction side : GTUtil.DIRECTIONS) {
                FluidState fluidState = level.m_8055_(pos.m_121945_(side)).m_60819_();
                if (fluidState.m_76178_()) continue;
                this.doExplosion(explosionPower);
                return;
            }
        }
        if (GTValues.RNG.m_188503_(1000) == 0 && (level.m_46758_(pos) || level.m_46758_(pos.m_122029_()) || level.m_46758_(pos.m_122024_()) || level.m_46758_(pos.m_122012_()) || level.m_46758_(pos.m_122019_()))) {
            if (level.m_46470_() && GTValues.RNG.m_188503_(3) == 0) {
                this.doExplosion(explosionPower);
            } else if (GTValues.RNG.m_188503_(10) == 0) {
                this.doExplosion(explosionPower);
            } else {
                this.setOnFire(additionalFireChance);
            }
        }
    }

    default public void doExplosion(float explosionPower) {
        this.doExplosion(this.self().getPos(), explosionPower);
    }

    default public void doExplosion(BlockPos pos, float explosionPower) {
        MetaMachine machine = this.self();
        Level level = machine.getLevel();
        level.m_7471_(pos, false);
        level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, explosionPower, ConfigHolder.INSTANCE.machines.doesExplosionDamagesTerrain ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    default public void setOnFire(double additionalFireChance) {
        MetaMachine machine = this.self();
        Level level = machine.getLevel();
        BlockPos pos = machine.getPos();
        boolean isFirstFireSpawned = false;
        for (Direction side : GTUtil.DIRECTIONS) {
            if (!level.m_46859_(pos.m_121945_(side))) continue;
            if (!isFirstFireSpawned) {
                level.m_7731_(pos.m_121945_(side), Blocks.f_50083_.m_49966_(), 11);
                if (level.m_46859_(pos.m_121945_(side))) continue;
                isFirstFireSpawned = true;
                continue;
            }
            if (!(additionalFireChance >= GTValues.RNG.m_188500_() * 100.0)) continue;
            level.m_7731_(pos.m_121945_(side), Blocks.f_50083_.m_49966_(), 11);
        }
    }

    default public boolean shouldWeatherOrTerrainExplosion() {
        return true;
    }
}

